/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import jeresources.collection.TradeList;
import jeresources.entry.AbstractVillagerEntry;
import jeresources.reference.Resources;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VillagerWrapper
implements IRecipeCategoryExtension {
    private final AbstractVillagerEntry<?> entry;
    private IFocus<ItemStack> focus;

    public VillagerWrapper(AbstractVillagerEntry<?> entry) {
        this.entry = entry;
    }

    public TradeList getTrades(int level) {
        return this.entry.getVillagerTrades(level);
    }

    public int getMaxLevel() {
        return this.entry.getMaxLevel();
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        return this.entry.getPossibleLevels(focus);
    }

    public void setFocus(IFocus<ItemStack> focus) {
        this.focus = focus;
    }

    public List<ItemStack> getPois() {
        return this.entry.getPois();
    }

    public boolean hasPois() {
        return this.entry.hasPois();
    }

    public boolean hasLevels() {
        return this.entry.hasLevels();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, @NotNull PoseStack poseStack, double mouseX, double mouseY) {
        int i;
        Object villager = this.entry.getVillagerEntity();
        RenderHelper.renderEntity(poseStack, 37, 118, 36.0, 38.0 - mouseX, 80.0 - mouseY, villager);
        int y = 22 * (6 - this.getPossibleLevels(this.focus).size()) / 2;
        for (i = 0; i < this.getPossibleLevels(this.focus).size(); ++i) {
            RenderHelper.drawTexture(poseStack, 130, y + i * 22, 0, 120, 20, 20, Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture(poseStack, 95, y + i * 22, 22, 120, 18, 18, Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture(poseStack, 113, y + i * 22, 22, 120, 18, 18, Resources.Gui.Jei.VILLAGER.getResource());
            RenderHelper.drawTexture(poseStack, 150, y + i * 22, 22, 120, 18, 18, Resources.Gui.Jei.VILLAGER.getResource());
        }
        if (this.entry.hasLevels()) {
            i = 0;
            for (int level : this.getPossibleLevels(this.focus)) {
                Font.normal.print(poseStack, "lv. " + (level + 1), 72, y + i++ * 22 + 6);
            }
        }
        Font.normal.print(poseStack, TranslationHelper.translateAndFormat(this.entry.getDisplayName(), new Object[0]), 5, 5);
        if (this.entry.hasPois()) {
            Font.normal.splitPrint(poseStack, TranslationHelper.translateAndFormat("jer.villager.poi", new Object[0]), 5, 18, 45);
            RenderHelper.drawTexture(poseStack, 49, 18, 22, 120, 18, 18, Resources.Gui.Jei.VILLAGER.getResource());
        }
    }
}

