/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import com.communi.suggestu.scena.core.IScenaPlatform;
import com.communi.suggestu.scena.core.blockstate.ILevelBasedPropertyAccessor;
import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import com.communi.suggestu.scena.core.client.models.data.IModelDataBuilder;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.communi.suggestu.scena.core.entity.block.IBlockEntityWithModelData;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.entity.INetworkUpdateableEntity;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.IArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.data.ChiseledBlockModelDataManager;
import mod.chiselsandbits.network.packets.TileEntityUpdatedPacket;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.storage.IMultiThreadedStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.StorageEngineBuilder;
import mod.chiselsandbits.utils.BlockPosUtils;
import mod.chiselsandbits.utils.LZ4DataCompressionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import mod.chiselsandbits.voxelshape.MultiStateBlockEntityDiscreteVoxelShape;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockEntity
extends BlockEntity
implements IMultiStateBlockEntity,
INetworkUpdateableEntity,
IBlockEntityWithModelData {
    public static final float ONE_THOUSANDS = 0.001f;
    private MutableStatistics mutableStatistics;
    private final Map<UUID, IBatchMutation> batchMutations = Maps.newConcurrentMap();
    private final Object tagSyncHandle = new Object();
    private IStateEntryStorage storage;
    private IMultiThreadedStorageEngine storageEngine;
    private boolean isInitialized = false;
    private IBlockModelData modelData = IModelDataBuilder.create().build();
    private CompoundTag lastTag = null;
    private CompletableFuture<Void> storageFuture = null;
    private final List<CompoundTag> deserializationQueue = Collections.synchronizedList(Lists.newArrayList());

    public ChiseledBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CHISELED.get(), position, state);
        this.storage = new SimpleStateEntryStorage();
        this.mutableStatistics = new MutableStatistics(() -> ((ChiseledBlockEntity)this).m_58904_(), () -> ((ChiseledBlockEntity)this).m_58899_());
        this.createStorageEngine();
    }

    @NotNull
    private static Executor createDefaultExecutor() {
        return (Executor)DistExecutor.unsafeRunForDist(() -> Minecraft::m_91087_, () -> () -> new ServerSchedulingExecutor(IScenaPlatform.getInstance().getCurrentServer()));
    }

    private void createStorageEngine() {
        this.storageEngine = StorageEngineBuilder.create().with(new LZ4StorageBasedStorageHandler()).buildMultiThreaded(this.getExecutor());
    }

    private Executor getExecutor() {
        if (this.m_58904_() != null && this.m_58904_().m_7654_() != null) {
            return new ServerSchedulingExecutor(this.m_58904_().m_7654_());
        }
        return ChiseledBlockEntity.createDefaultExecutor();
    }

    public void updateModelData() {
        ChiseledBlockModelDataManager.getInstance().updateModelData(this);
    }

    private void updateModelDataIfInLoadedChunk() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && this.f_58857_.m_46749_(this.m_58899_())) {
            this.updateModelData();
            this.f_58857_.m_5518_().m_7174_(this.m_58899_());
        }
    }

    public void m_142339_(@Nullable Level level) {
        super.m_142339_(level);
        this.createStorageEngine();
        if (this.deserializationQueue.isEmpty()) {
            return;
        }
        this.deserializationQueue.forEach(this::deserializeNBT);
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.storage);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.storage.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (LevelAccessor)this.m_58904_(), this.m_58899_(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        return !(inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        Vec3 exactAreaPos = inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        BlockPos inAreaPos = VectorUtils.toBlockPos(exactAreaPos);
        IBlockInformation blockInformation = this.storage.getBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        return Optional.of(new StateEntry(blockInformation, (LevelAccessor)this.m_58904_(), this.m_58899_(), (Vec3i)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return MultiStateSnapshotUtils.createFromStorage(this.storage);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        if (this.m_58904_() != null) {
            this.deserializeNBT(nbt);
        }
        this.queueDeserializeNbt(nbt);
    }

    private void queueDeserializeNbt(CompoundTag nbt) {
        this.deserializationQueue.add(nbt);
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.deserializeNBT(nbt, this::updateModelDataIfInLoadedChunk);
    }

    public void deserializeNBT(CompoundTag nbt, Runnable onLoaded) {
        ((CompletableFuture)this.storageEngine.deserializeOffThread(nbt).thenRun(onLoaded)).thenRunAsync(() -> {
            if (this.mutableStatistics.isRequiresRecalculation()) {
                this.mutableStatistics.recalculate(this.storage, this.shouldUpdateWorld());
            }
            this.mutableStatistics.updatePrimaryState(this.shouldUpdateWorld());
        }, this.getExecutor());
        this.lastTag = nbt;
    }

    @Override
    public CompoundTag serializeNBT() {
        return this.m_187480_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        Object object = this.tagSyncHandle;
        synchronized (object) {
            if (this.lastTag != null) {
                CompoundTag nbt = this.lastTag.m_6426_();
                nbt.m_128431_().forEach(key -> compound.m_128365_(key, nbt.m_128423_(key)));
                return;
            }
        }
        if (this.storageFuture != null) {
            this.storageFuture.join();
            Validate.notNull((Object)this.lastTag, (String)"The storage future did not complete.", (Object[])new Object[0]);
            CompoundTag nbt = this.lastTag.m_6426_();
            nbt.m_128431_().forEach(key -> compound.m_128365_(key, nbt.m_128423_(key)));
            return;
        }
        this.storageEngine.serializeNBTInto(compound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6596_() {
        if (this.m_58904_() != null && this.batchMutations.isEmpty() && !this.m_58904_().m_5776_()) {
            this.mutableStatistics.updatePrimaryState(true);
            if (!this.m_58904_().m_5776_()) {
                Object object = this.tagSyncHandle;
                synchronized (object) {
                    if (this.storageFuture != null) {
                        this.storageFuture.cancel(false);
                    }
                    this.lastTag = null;
                    this.storageFuture = this.storageEngine.serializeOffThread(tag -> CompletableFuture.runAsync(() -> this.setOffThreadSaveResult((CompoundTag)tag), this.storageEngine));
                    ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new TileEntityUpdatedPacket(this), this.m_58904_().m_46745_(this.m_58899_()));
                }
            }
        }
        if (this.m_58904_() != null && this.batchMutations.isEmpty()) {
            super.m_6596_();
            this.m_58904_().m_5518_().m_7174_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_(), 3);
            this.m_58904_().m_46672_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()).m_60734_());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOffThreadSaveResult(CompoundTag tag) {
        Object object = this.tagSyncHandle;
        synchronized (object) {
            this.lastTag = tag;
        }
    }

    private boolean shouldUpdateWorld() {
        return this.m_58904_() != null && this.batchMutations.size() == 0 && this.m_58904_() instanceof ServerLevel;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        if (this.isInitialized || this.lastTag == null) {
            return (CompoundTag)this.storageEngine.serializeNBT();
        }
        return this.lastTag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        this.storage.serializeInto(packetBuffer);
        this.mutableStatistics.serializeInto(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.storage.deserializeFrom(packetBuffer);
        this.mutableStatistics.deserializeFrom(packetBuffer);
        this.updateModelDataIfInLoadedChunk();
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.storage.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (LevelAccessor)this.m_58904_(), this.m_58899_(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(IBlockInformation newInformation, Vec3 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        Vec3 exactAreaPos = inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        BlockPos inAreaPos = VectorUtils.toBlockPos(exactAreaPos);
        IBlockInformation information = this.storage.getBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        if (!information.isAir()) {
            throw new SpaceOccupiedException();
        }
        if (this.m_58904_() == null) {
            return;
        }
        this.storage.setBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_(), newInformation);
        if (newInformation.isAir() && !information.isAir()) {
            this.mutableStatistics.onBlockStateRemoved(information, inAreaPos, this.shouldUpdateWorld());
        } else if (!newInformation.isAir() && information.isAir()) {
            this.mutableStatistics.onBlockStateAdded(newInformation, inAreaPos, this.shouldUpdateWorld());
        } else if (!newInformation.isAir() && !information.isAir()) {
            this.mutableStatistics.onBlockStateReplaced(information, newInformation, inAreaPos, this.shouldUpdateWorld());
        }
        if (this.m_58904_() != null) {
            this.m_6596_();
        }
    }

    @Override
    public LevelAccessor getWorld() {
        return this.m_58904_();
    }

    @Override
    public Vec3 getInWorldStartPoint() {
        return Vec3.m_82528_((Vec3i)this.m_58899_());
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public Vec3 getInWorldEndPoint() {
        return this.getInWorldStartPoint().m_82520_(1.0, 1.0, 1.0).m_82492_((double)0.001f, (double)0.001f, (double)0.001f);
    }

    @Override
    public void clearInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        Vec3 exactAreaPos = inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        BlockPos inAreaPos = VectorUtils.toBlockPos(exactAreaPos);
        if (this.m_58904_() == null) {
            return;
        }
        IBlockInformation currentInformation = this.storage.getBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        if (currentInformation.isAir()) {
            return;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(currentInformation)) {
            return;
        }
        IBlockInformation blockState = BlockInformation.AIR;
        this.storage.setBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_(), blockState);
        if (blockState.isAir() && !currentInformation.isAir()) {
            this.mutableStatistics.onBlockStateRemoved(currentInformation, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.isAir() && currentInformation.isAir()) {
            this.mutableStatistics.onBlockStateAdded(blockState, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.isAir() && !currentInformation.isAir()) {
            this.mutableStatistics.onBlockStateReplaced(currentInformation, blockState, inAreaPos, this.shouldUpdateWorld());
        }
        if (this.m_58904_() != null) {
            this.m_6596_();
        }
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateObjectStatistics getStatistics() {
        return this.mutableStatistics;
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        if (this.m_58904_() == null) {
            return;
        }
        try (IBatchMutation ignored = this.batch();){
            this.storage.rotate(axis, rotationCount);
            this.mutableStatistics.recalculate(this.storage);
        }
    }

    @Override
    public void mirror(Direction.Axis axis) {
        if (this.m_58904_() == null) {
            return;
        }
        try (IBatchMutation ignored = this.batch();){
            this.storage.mirror(axis);
            this.mutableStatistics.recalculate(this.storage);
        }
    }

    @Override
    public void initializeWith(IBlockInformation newInitialInformation) {
        if (this.m_58904_() == null) {
            return;
        }
        try (IBatchMutation batchMutation = this.batch();){
            this.storage.initializeWith(newInitialInformation);
            this.mutableStatistics.initializeWith(newInitialInformation);
        }
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.storage.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (LevelAccessor)this.m_58904_(), this.m_58899_(), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> {
            Vec3i pos = positionMutator.mutate((Vec3i)blockPos);
            return new StateEntry(this.storage.getBlockInformation(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), (LevelAccessor)this.m_58904_(), this.m_58899_(), pos, this::setInAreaTarget, this::clearInAreaTarget);
        });
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
            Vec3i pos = positionMutator.mutate((Vec3i)blockPos);
            consumer.accept(new StateEntry(this.storage.getBlockInformation(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), (LevelAccessor)this.m_58904_(), this.m_58899_(), pos, this::setInAreaTarget, this::clearInAreaTarget));
        });
    }

    @Override
    public IBatchMutation batch() {
        UUID id = UUID.randomUUID();
        IBatchMutation storageBatch = this.storage.batch();
        this.batchMutations.put(id, new BatchMutationLock(() -> {
            this.batchMutations.remove(id);
            storageBatch.close();
            if (this.batchMutations.isEmpty()) {
                this.m_6596_();
            }
        }));
        return this.batchMutations.get(id);
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        IBatchMutation innerMutation = this.batch();
        IMultiStateSnapshot before = this.createSnapshot();
        return () -> {
            IMultiStateSnapshot after = this.createSnapshot();
            innerMutation.close();
            changeTracker.onBlockUpdated(this.m_58899_(), before, after);
        };
    }

    public void setModelData(IBlockModelData modelData) {
        this.modelData = modelData;
    }

    @NotNull
    public IBlockModelData getBlockModelData() {
        return this.modelData;
    }

    @Override
    public VoxelShape provideShape(CollisionType type, BlockPos offset, boolean simplify) {
        CubeVoxelShape shape = new CubeVoxelShape((DiscreteVoxelShape)new MultiStateBlockEntityDiscreteVoxelShape(this.getStatistics().getCollideableEntries(type)));
        if (offset != BlockPos.f_121853_) {
            shape = shape.m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        }
        if (simplify) {
            shape = shape.m_83296_();
        }
        return shape;
    }

    @Override
    @NotNull
    public AABB getBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
    }

    private final class MutableStatistics
    implements IMultiStateObjectStatistics,
    INBTSerializable<CompoundTag>,
    IPacketBufferSerializable {
        private final Supplier<LevelAccessor> worldReaderSupplier;
        private final Supplier<BlockPos> positionSupplier;
        private final Map<IBlockInformation, Integer> countMap = Maps.newConcurrentMap();
        private final Table<Integer, Integer, ColumnStatistics> columnStatisticsTable = HashBasedTable.create();
        private final Map<CollisionType, BitSet> collisionData = Maps.newConcurrentMap();
        private IBlockInformation primaryState = BlockInformation.AIR;
        private int totalUsedBlockCount = 0;
        private int totalUsedChecksWeakPowerCount = 0;
        private int totalLightLevel = 0;
        private int totalLightBlockLevel = 0;
        private boolean requiresRecalculation = false;

        private MutableStatistics(Supplier<LevelAccessor> worldReaderSupplier, Supplier<BlockPos> positionSupplier) {
            this.worldReaderSupplier = worldReaderSupplier;
            this.positionSupplier = positionSupplier;
        }

        @Override
        public IBlockInformation getPrimaryState() {
            return this.primaryState;
        }

        @Override
        public boolean isEmpty() {
            return this.countMap.size() == 1 && this.countMap.getOrDefault(BlockInformation.AIR, 0) == 4096;
        }

        @Override
        public Map<IBlockInformation, Integer> getStateCounts() {
            return Collections.unmodifiableMap(this.countMap);
        }

        @Override
        public boolean shouldCheckWeakPower() {
            return this.totalUsedChecksWeakPowerCount == this.totalUsedBlockCount;
        }

        @Override
        public float getFullnessFactor() {
            return (float)this.totalUsedBlockCount / (float)StateEntrySize.current().getBitsPerBlock();
        }

        @Override
        public float getSlipperiness() {
            return (float)this.columnStatisticsTable.values().stream().filter(columnStatistics -> columnStatistics.getHighestBit() >= 0).mapToDouble(ColumnStatistics::getHighestBitFriction).average().orElse(0.0);
        }

        @Override
        public float getLightEmissionFactor() {
            return (float)this.totalLightLevel / (float)this.totalUsedBlockCount;
        }

        @Override
        public float getLightBlockingFactor() {
            return (float)this.totalLightBlockLevel / (float)StateEntrySize.current().getBitsPerBlock();
        }

        @Override
        public float getRelativeBlockHardness(Player player) {
            double totalRelativeHardness = this.countMap.entrySet().stream().mapToDouble(entry -> (double)((IBlockInformation)entry.getKey()).getBlockState().m_60625_(player, (BlockGetter)new SingleBlockWorldReader((IBlockInformation)entry.getKey(), this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * (double)((Integer)entry.getValue()).intValue()).filter(Double::isFinite).sum();
            if (totalRelativeHardness == 0.0 || Double.isNaN(totalRelativeHardness) || Double.isInfinite(totalRelativeHardness)) {
                return 0.0f;
            }
            return (float)(totalRelativeHardness / (double)this.totalUsedBlockCount);
        }

        @Override
        public boolean canPropagateSkylight() {
            return this.columnStatisticsTable.values().stream().allMatch(ColumnStatistics::canPropagateSkylightDown);
        }

        @Override
        public boolean canSustainGrassBelow() {
            return this.columnStatisticsTable.values().stream().anyMatch(ColumnStatistics::canLowestBitSustainGrass);
        }

        @Override
        public BitSet getCollideableEntries(CollisionType collisionType) {
            BitSet collisionDataSet = this.collisionData.computeIfAbsent(collisionType, type -> {
                if (!ChiseledBlockEntity.this.shouldUpdateWorld()) {
                    return null;
                }
                BitSet bitSet = new BitSet(StateEntrySize.current().getBitsPerBlock());
                BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> bitSet.set(BlockPosUtils.getCollisionIndex(blockPos), type.isValidFor(ChiseledBlockEntity.this.storage.getBlockInformation((Vec3i)blockPos).getBlockState())));
                return bitSet;
            });
            if (collisionDataSet == null) {
                return new BitSet(0);
            }
            return collisionDataSet;
        }

        private void onBlockStateAdded(IBlockInformation blockInformation, BlockPos pos, boolean updateWorld) {
            this.countMap.putIfAbsent(blockInformation, 0);
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState(updateWorld);
            ++this.totalUsedBlockCount;
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                ++this.totalUsedChecksWeakPowerCount;
            }
            this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((BlockGetter)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!this.columnStatisticsTable.contains((Object)pos.m_123341_(), (Object)pos.m_123343_())) {
                this.columnStatisticsTable.put((Object)pos.m_123341_(), (Object)pos.m_123343_(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
            }
            ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.m_123341_(), (Object)pos.m_123343_())).onBlockStateAdded(blockInformation, pos);
            this.collisionData.forEach((collisionType, bitSet) -> bitSet.set(BlockPosUtils.getCollisionIndex(pos), collisionType.isValidFor(blockInformation.getBlockState())));
        }

        private void updatePrimaryState(boolean updateWorld) {
            IBlockInformation currentPrimary = this.primaryState;
            this.primaryState = this.countMap.entrySet().stream().filter(e -> !((IBlockInformation)e.getKey()).isAir()).min((o1, o2) -> -1 * ((Integer)o1.getValue() - (Integer)o2.getValue())).map(Map.Entry::getKey).orElse(BlockInformation.AIR);
            boolean primaryIsAir = this.primaryState.isAir();
            if ((this.countMap.getOrDefault(this.primaryState, 0).intValue() == StateEntrySize.current().getBitsPerBlock() || primaryIsAir || currentPrimary != this.primaryState) && updateWorld) {
                Optional<Block> optionalWithConvertedBlock;
                if (primaryIsAir) {
                    this.worldReaderSupplier.get().m_7731_(this.positionSupplier.get(), Blocks.f_50016_.m_49966_(), 3);
                } else if (this.countMap.getOrDefault(this.primaryState, 0).intValue() == StateEntrySize.current().getBitsPerBlock()) {
                    this.worldReaderSupplier.get().m_7731_(this.positionSupplier.get(), this.primaryState.getBlockState(), 3);
                } else if (currentPrimary != this.primaryState && (optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(this.primaryState.getBlockState())).isPresent()) {
                    Block convertedBlock = optionalWithConvertedBlock.get();
                    this.worldReaderSupplier.get().m_7731_(this.positionSupplier.get(), convertedBlock.m_49966_(), 3);
                }
            }
        }

        private void onBlockStateRemoved(IBlockInformation blockInformation, BlockPos pos, boolean updateWorld) {
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(blockInformation, 0);
            this.updatePrimaryState(updateWorld);
            --this.totalUsedBlockCount;
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                --this.totalUsedChecksWeakPowerCount;
            }
            this.totalLightLevel -= ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel -= ILevelBasedPropertyAccessor.getInstance().getLightBlock((BlockGetter)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!this.columnStatisticsTable.contains((Object)pos.m_123341_(), (Object)pos.m_123343_())) {
                this.columnStatisticsTable.put((Object)pos.m_123341_(), (Object)pos.m_123343_(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
            }
            ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.m_123341_(), (Object)pos.m_123343_())).onBlockStateRemoved(blockInformation, pos);
            this.collisionData.forEach((collisionType, bitSet) -> bitSet.set(BlockPosUtils.getCollisionIndex(pos), collisionType.isValidFor(Blocks.f_50016_.m_49966_())));
        }

        private void onBlockStateReplaced(IBlockInformation currentInformation, IBlockInformation newInformation, BlockPos pos, boolean updateWorld) {
            this.countMap.computeIfPresent(currentInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(currentInformation, 0);
            this.countMap.putIfAbsent(newInformation, 0);
            this.countMap.computeIfPresent(newInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState(updateWorld);
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((LevelReader)new SingleBlockWorldReader(currentInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                --this.totalUsedChecksWeakPowerCount;
            }
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((LevelReader)new SingleBlockWorldReader(newInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                ++this.totalUsedChecksWeakPowerCount;
            }
            this.totalLightLevel -= ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader(currentInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader(newInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel -= ILevelBasedPropertyAccessor.getInstance().getLightBlock((BlockGetter)new SingleBlockWorldReader(currentInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((BlockGetter)new SingleBlockWorldReader(newInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!this.columnStatisticsTable.contains((Object)pos.m_123341_(), (Object)pos.m_123343_())) {
                this.columnStatisticsTable.put((Object)pos.m_123341_(), (Object)pos.m_123343_(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
            }
            ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.m_123341_(), (Object)pos.m_123343_())).onBlockStateReplaced(currentInformation, newInformation, pos);
            this.collisionData.forEach((collisionType, bitSet) -> bitSet.set(BlockPosUtils.getCollisionIndex(pos), collisionType.isValidFor(newInformation.getBlockState())));
        }

        @Override
        public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
            this.primaryState.serializeInto(packetBuffer);
            packetBuffer.m_130130_(this.countMap.size());
            for (Map.Entry<IBlockInformation, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                blockStateIntegerEntry.getKey().serializeInto(packetBuffer);
                packetBuffer.m_130130_(blockStateIntegerEntry.getValue().intValue());
            }
            packetBuffer.m_130130_(this.columnStatisticsTable.size());
            this.columnStatisticsTable.cellSet().forEach(cell -> {
                packetBuffer.m_130130_(((Integer)cell.getRowKey()).intValue());
                packetBuffer.m_130130_(((Integer)cell.getColumnKey()).intValue());
                ((ColumnStatistics)cell.getValue()).serializeInto(packetBuffer);
            });
            packetBuffer.m_130130_(this.totalUsedBlockCount);
            packetBuffer.m_130130_(this.totalUsedChecksWeakPowerCount);
            packetBuffer.m_130130_(this.totalLightLevel);
            packetBuffer.m_130130_(this.totalLightBlockLevel);
            packetBuffer.m_130130_(this.collisionData.size());
            this.collisionData.forEach((collisionType, bitSet) -> {
                packetBuffer.m_130130_(collisionType.ordinal());
                packetBuffer.m_130091_(bitSet.toLongArray());
            });
        }

        @Override
        public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
            this.countMap.clear();
            this.columnStatisticsTable.clear();
            this.collisionData.clear();
            this.primaryState = new BlockInformation(packetBuffer);
            int stateCount = packetBuffer.m_130242_();
            for (int i = 0; i < stateCount; ++i) {
                this.countMap.put(new BlockInformation(packetBuffer), packetBuffer.m_130242_());
            }
            int columnBlockCount = packetBuffer.m_130242_();
            for (int i = 0; i < columnBlockCount; ++i) {
                ColumnStatistics statistics = new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier);
                this.columnStatisticsTable.put((Object)packetBuffer.m_130242_(), (Object)packetBuffer.m_130242_(), (Object)statistics);
                statistics.deserializeFrom(packetBuffer);
            }
            this.totalUsedBlockCount = packetBuffer.m_130242_();
            this.totalUsedChecksWeakPowerCount = packetBuffer.m_130242_();
            this.totalLightLevel = packetBuffer.m_130242_();
            this.totalLightBlockLevel = packetBuffer.m_130242_();
            int axisSizeHandlerCount = packetBuffer.m_130242_();
            for (int i = 0; i < axisSizeHandlerCount; ++i) {
                CollisionType collisionType = CollisionType.values()[packetBuffer.m_130242_()];
                BitSet set = BitSet.valueOf(packetBuffer.m_178381_());
                this.collisionData.put(collisionType, set);
            }
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("primary_block_information", this.primaryState.serializeNBT());
            ListTag blockStateList = new ListTag();
            for (Map.Entry<IBlockInformation, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                CompoundTag stateNbt = new CompoundTag();
                stateNbt.m_128365_("block_information", blockStateIntegerEntry.getKey().serializeNBT());
                stateNbt.m_128405_("count", blockStateIntegerEntry.getValue().intValue());
                blockStateList.add((Object)stateNbt);
            }
            CompoundTag columnStatisticsTableNbt = new CompoundTag();
            this.columnStatisticsTable.rowMap().forEach((rowKey, columnStatisticsMap) -> {
                CompoundTag rowNbt = new CompoundTag();
                columnStatisticsMap.forEach((columnKey, columnStatistics) -> rowNbt.m_128365_(String.valueOf(columnKey), (Tag)columnStatistics.serializeNBT()));
                columnStatisticsTableNbt.m_128365_(String.valueOf(rowKey), (Tag)rowNbt);
            });
            nbt.m_128365_("blockStates", (Tag)blockStateList);
            nbt.m_128365_("column_statistics", (Tag)columnStatisticsTableNbt);
            nbt.m_128405_("blockCount", this.totalUsedBlockCount);
            nbt.m_128405_("blockShouldCheckWeakPowerCount", this.totalUsedChecksWeakPowerCount);
            nbt.m_128405_("totalLightLevel", this.totalLightLevel);
            nbt.m_128405_("totalLightBlockLevel", this.totalLightBlockLevel);
            CompoundTag collisionDataNbt = new CompoundTag();
            for (CollisionType collisionType : CollisionType.values()) {
                collisionDataNbt.m_128388_(collisionType.name(), this.getCollideableEntries(collisionType).toLongArray());
            }
            nbt.m_128365_("collision_data", (Tag)collisionDataNbt);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.countMap.clear();
            this.primaryState = new BlockInformation(nbt.m_128469_("primary_block_information"));
            if (nbt.m_128425_("blockStates", 9)) {
                ListTag blockStateList = nbt.m_128437_("blockStates", 10);
                for (int i = 0; i < blockStateList.size(); ++i) {
                    CompoundTag stateNbt = blockStateList.m_128728_(i);
                    BlockInformation blockInformation = new BlockInformation(stateNbt.m_128469_("block_information"));
                    this.countMap.put(blockInformation, stateNbt.m_128451_("count"));
                }
            }
            this.columnStatisticsTable.clear();
            if (nbt.m_128425_("column_statistics", 10)) {
                CompoundTag columnStatisticsTableNbt = nbt.m_128469_("column_statistics");
                columnStatisticsTableNbt.m_128431_().forEach(rowKeyValue -> {
                    Integer rowKey = Integer.valueOf(rowKeyValue);
                    CompoundTag rowNbt = columnStatisticsTableNbt.m_128469_(rowKeyValue);
                    rowNbt.m_128431_().forEach(columnKeyValue -> {
                        Integer columnKey = Integer.valueOf(columnKeyValue);
                        CompoundTag columnStatisticsNbt = rowNbt.m_128469_(columnKeyValue);
                        ColumnStatistics columnStatistics = new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier);
                        columnStatistics.deserializeNBT(columnStatisticsNbt);
                        this.columnStatisticsTable.put((Object)rowKey, (Object)columnKey, (Object)columnStatistics);
                    });
                });
            } else {
                this.requiresRecalculation = true;
            }
            this.totalUsedBlockCount = nbt.m_128451_("blockCount");
            this.totalUsedChecksWeakPowerCount = nbt.m_128451_("blockShouldCheckWeakPowerCount");
            this.totalLightLevel = nbt.m_128451_("totalLightLevel");
            if (nbt.m_128441_("totalLightBlockLevel")) {
                this.totalLightBlockLevel = nbt.m_128451_("totalLightBlockLevel");
            } else {
                this.totalLightBlockLevel = 0;
                this.requiresRecalculation = true;
            }
            this.collisionData.clear();
            if (nbt.m_128441_("collision_data")) {
                CompoundTag collisionDataNbt = nbt.m_128469_("collision_data");
                collisionDataNbt.m_128431_().forEach(collisionTypeName -> {
                    CollisionType collisionType = CollisionType.valueOf(collisionTypeName);
                    BitSet set = BitSet.valueOf(collisionDataNbt.m_128467_(collisionTypeName));
                    this.collisionData.put(collisionType, set);
                });
            } else {
                this.requiresRecalculation = true;
            }
        }

        public void initializeWith(IBlockInformation blockInformation) {
            this.clear();
            boolean isAir = blockInformation.isAir();
            this.primaryState = blockInformation;
            if (!isAir) {
                this.countMap.put(blockInformation, StateEntrySize.current().getBitsPerBlock());
            }
            int n = this.totalUsedBlockCount = isAir ? 0 : StateEntrySize.current().getBitsPerBlock();
            if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                this.totalUsedChecksWeakPowerCount = StateEntrySize.current().getBitsPerBlock();
            }
            this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * StateEntrySize.current().getBitsPerBlock();
            this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((BlockGetter)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * StateEntrySize.current().getBitsPerBlock();
            this.columnStatisticsTable.clear();
            IntStream.range(0, StateEntrySize.current().getBitsPerBlockSide()).forEach(x -> IntStream.range(0, StateEntrySize.current().getBitsPerBlockSide()).forEach(z -> {
                ColumnStatistics columnStatistics = new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier);
                columnStatistics.initializeWith(blockInformation);
                this.columnStatisticsTable.put((Object)x, (Object)z, (Object)columnStatistics);
            }));
            this.collisionData.clear();
            for (CollisionType collisionType : CollisionType.values()) {
                boolean matches = collisionType.isValidFor(blockInformation.getBlockState());
                BitSet set = new BitSet(StateEntrySize.current().getBitsPerBlock());
                set.set(0, StateEntrySize.current().getBitsPerBlock(), matches);
                this.collisionData.put(collisionType, set);
            }
        }

        private void clear() {
            this.primaryState = BlockInformation.AIR;
            this.countMap.clear();
            this.columnStatisticsTable.clear();
            this.collisionData.clear();
            this.totalUsedBlockCount = 0;
            this.totalUsedChecksWeakPowerCount = 0;
            this.totalLightLevel = 0;
            this.totalLightBlockLevel = 0;
        }

        public boolean isRequiresRecalculation() {
            return this.requiresRecalculation;
        }

        private void recalculate(IStateEntryStorage source) {
            this.recalculate(source, true);
        }

        private void recalculate(IStateEntryStorage source, boolean mayUpdateWorld) {
            if (!mayUpdateWorld) {
                this.requiresRecalculation = true;
                return;
            }
            this.requiresRecalculation = false;
            this.clear();
            source.count(this.countMap::put);
            this.countMap.remove(BlockInformation.AIR);
            this.updatePrimaryState(mayUpdateWorld);
            this.totalUsedBlockCount = this.countMap.values().stream().mapToInt(i -> i).sum();
            this.countMap.forEach((blockState, count) -> {
                if (ILevelBasedPropertyAccessor.getInstance().shouldCheckWeakPower((LevelReader)new SingleBlockWorldReader((IBlockInformation)blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                    this.totalUsedChecksWeakPowerCount += count.intValue();
                }
                this.totalLightLevel += ILevelBasedPropertyAccessor.getInstance().getLightEmission((LevelReader)new SingleBlockWorldReader((IBlockInformation)blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * count;
                this.totalLightBlockLevel += ILevelBasedPropertyAccessor.getInstance().getLightBlock((BlockGetter)new SingleBlockWorldReader((IBlockInformation)blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * count;
            });
            BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(pos -> {
                IBlockInformation blockState = source.getBlockInformation(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (!this.columnStatisticsTable.contains((Object)pos.m_123341_(), (Object)pos.m_123343_())) {
                    this.columnStatisticsTable.put((Object)pos.m_123341_(), (Object)pos.m_123343_(), (Object)new ColumnStatistics(this.worldReaderSupplier, this.positionSupplier));
                }
                ((ColumnStatistics)this.columnStatisticsTable.get((Object)pos.m_123341_(), (Object)pos.m_123343_())).onBlockStateAdded(blockState, (BlockPos)pos);
            });
            this.collisionData.clear();
            for (CollisionType collisionType : CollisionType.values()) {
                this.getCollideableEntries(collisionType);
            }
        }
    }

    private final class LZ4StorageBasedStorageHandler
    implements IStorageHandler<Payload> {
        private LZ4StorageBasedStorageHandler() {
        }

        @Override
        public Payload readPayloadOffThread(CompoundTag nbt) {
            return LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                SimpleStateEntryStorage storage = new SimpleStateEntryStorage();
                MutableStatistics mutableStatistics = new MutableStatistics(() -> ((ChiseledBlockEntity)ChiseledBlockEntity.this).m_58904_(), () -> ((ChiseledBlockEntity)ChiseledBlockEntity.this).m_58899_());
                storage.deserializeNBT(compoundTag.m_128469_("chiseledData"));
                mutableStatistics.deserializeNBT(compoundTag.m_128469_("statistics"));
                return new Payload(storage, mutableStatistics);
            });
        }

        @Override
        public void syncPayloadOnGameThread(Payload payload) {
            ChiseledBlockEntity.this.storage = payload.storage;
            ChiseledBlockEntity.this.mutableStatistics = payload.mutableStatistics;
            if (!ChiseledBlockEntity.this.isInitialized) {
                ChiseledBlockEntity.this.m_6596_();
            }
            ChiseledBlockEntity.this.isInitialized = true;
        }

        @Override
        public CompoundTag serializeNBT() {
            return LZ4DataCompressionUtils.compress(compoundTag -> {
                compoundTag.m_128365_("chiseledData", ChiseledBlockEntity.this.storage.serializeNBT());
                compoundTag.m_128365_("statistics", (Tag)ChiseledBlockEntity.this.mutableStatistics.serializeNBT());
            });
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                ChiseledBlockEntity.this.storage.deserializeNBT(compoundTag.m_128469_("chiseledData"));
                ChiseledBlockEntity.this.mutableStatistics.deserializeNBT(compoundTag.m_128469_("statistics"));
            });
        }

        private record Payload(IStateEntryStorage storage, MutableStatistics mutableStatistics) {
        }
    }

    private static final class ServerSchedulingExecutor
    implements Executor {
        private final MinecraftServer server;

        private ServerSchedulingExecutor(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.server.m_6937_((Runnable)new TickTask(this.server.m_129921_(), command));
        }
    }

    private static final class Identifier
    implements IArrayBackedAreaShapeIdentifier {
        private final IStateEntryStorage snapshot;

        private Identifier(IStateEntryStorage section) {
            this.snapshot = section.createSnapshot();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            IArrayBackedAreaShapeIdentifier that = (IArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.getBackingData(), that.getBackingData()) && this.getPalette().equals(that.getPalette());
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }

        public String toString() {
            return "Identifier{snapshot=" + this.snapshot + "}";
        }

        @Override
        public byte[] getBackingData() {
            return this.snapshot.getRawData();
        }

        @Override
        public List<IBlockInformation> getPalette() {
            return this.snapshot.getContainedPalette();
        }
    }

    private static final class StateEntry
    implements IInWorldMutableStateEntryInfo {
        private final IBlockInformation blockInformation;
        private final LevelAccessor reader;
        private final BlockPos blockPos;
        private final Vec3 startPoint;
        private final Vec3 endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        public StateEntry(IBlockInformation blockInformation, LevelAccessor reader, BlockPos blockPos, Vec3i startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this(blockInformation, reader, blockPos, Vec3.m_82528_((Vec3i)startPoint).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), Vec3.m_82528_((Vec3i)startPoint).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).m_82520_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), stateSetter, stateClearer);
        }

        private StateEntry(IBlockInformation blockInformation, LevelAccessor reader, BlockPos blockPos, Vec3 startPoint, Vec3 endPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockInformation = blockInformation;
            this.reader = reader;
            this.blockPos = blockPos;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        @NotNull
        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        public void setBlockInformation(IBlockInformation blockState) throws SpaceOccupiedException {
            this.stateSetter.set(blockState, this.getStartPoint());
        }

        @Override
        @NotNull
        public Vec3 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public Vec3 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }

        @Override
        public LevelAccessor getWorld() {
            return this.reader;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.blockPos;
        }
    }

    private record BatchMutationLock(Runnable closeCallback) implements IBatchMutation
    {
        @Override
        public void close() {
            this.closeCallback.run();
        }
    }

    private final class ColumnStatistics
    implements INBTSerializable<CompoundTag>,
    IPacketBufferSerializable {
        private final BitSet skylightBlockingBits = new BitSet(StateEntrySize.current().getBitsPerBlockSide());
        private final BitSet noneAirBits = new BitSet(StateEntrySize.current().getBitsPerBlockSide());
        private final Supplier<LevelAccessor> worldReaderSupplier;
        private final Supplier<BlockPos> positionSupplier;
        private short highestBit = (short)-1;
        private float highestBitFriction = 0.0f;
        private boolean canPropagateSkylightDown = true;
        private boolean canLowestBitSustainGrass = true;

        private ColumnStatistics(Supplier<LevelAccessor> worldReaderSupplier, Supplier<BlockPos> positionSupplier) {
            this.worldReaderSupplier = worldReaderSupplier;
            this.positionSupplier = positionSupplier;
        }

        public BitSet getSkylightBlockingBits() {
            return this.skylightBlockingBits;
        }

        public BitSet getNoneAirBits() {
            return this.noneAirBits;
        }

        public short getHighestBit() {
            return this.highestBit;
        }

        public float getHighestBitFriction() {
            return this.highestBitFriction;
        }

        public boolean canPropagateSkylightDown() {
            return this.canPropagateSkylightDown;
        }

        public boolean canLowestBitSustainGrass() {
            return this.canLowestBitSustainGrass;
        }

        private void onBlockStateAdded(IBlockInformation blockState, BlockPos pos) {
            this.skylightBlockingBits.set(pos.m_123342_(), !ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((BlockGetter)new SingleBlockBlockReader(blockState, this.positionSupplier.get(), (BlockGetter)this.worldReaderSupplier.get()), this.positionSupplier.get()));
            if (this.skylightBlockingBits.get(pos.m_123342_())) {
                this.canPropagateSkylightDown = false;
            }
            if (!blockState.isAir() && pos.m_123342_() >= this.highestBit) {
                this.highestBit = (short)pos.m_123342_();
                this.highestBitFriction = ILevelBasedPropertyAccessor.getInstance().getFriction((LevelReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            if (pos.m_123342_() == 0) {
                this.canLowestBitSustainGrass = ILevelBasedPropertyAccessor.getInstance().canBeGrass((LevelReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), Blocks.f_50440_.m_49966_(), this.positionSupplier.get().m_7495_(), blockState.getBlockState(), this.positionSupplier.get()).orElseGet(() -> {
                    if (blockState.getBlockState().m_60713_(Blocks.f_50125_) && (Integer)blockState.getBlockState().m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
                        return true;
                    }
                    if (blockState.getBlockState().m_60819_().m_76186_() == 8) {
                        return false;
                    }
                    int i = LayerLightEngine.m_75667_((BlockGetter)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), (BlockState)Blocks.f_50440_.m_49966_(), (BlockPos)this.positionSupplier.get().m_7495_(), (BlockState)blockState.getBlockState(), (BlockPos)this.positionSupplier.get(), (Direction)Direction.UP, (int)blockState.getBlockState().m_60739_((BlockGetter)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()));
                    return i < this.worldReaderSupplier.get().m_7469_();
                });
            }
        }

        private void onBlockStateRemoved(IBlockInformation blockInformation, BlockPos pos) {
            this.skylightBlockingBits.set(pos.m_123342_(), !ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((BlockGetter)new SingleBlockBlockReader(blockInformation, this.positionSupplier.get(), (BlockGetter)this.worldReaderSupplier.get()), this.positionSupplier.get()));
            if (!this.skylightBlockingBits.get(pos.m_123342_())) {
                this.canPropagateSkylightDown = IntStream.range(0, StateEntrySize.current().getBitsPerBlockSide()).noneMatch(this.skylightBlockingBits::get);
            }
            if (pos.m_123342_() >= this.highestBit) {
                this.highestBit = (short)-1;
                this.highestBitFriction = 0.0f;
                for (int i = StateEntrySize.current().getBitsPerBlockSide() - 1; i >= 0; --i) {
                    if (!this.noneAirBits.get(i)) continue;
                    this.highestBit = (short)i;
                    this.highestBitFriction = ILevelBasedPropertyAccessor.getInstance().getFriction((LevelReader)new SingleBlockWorldReader(ChiseledBlockEntity.this.storage.getBlockInformation(pos.m_123341_(), i, pos.m_123343_()), this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
                    break;
                }
            }
            if (pos.m_123342_() == 0) {
                this.canLowestBitSustainGrass = true;
            }
        }

        private void onBlockStateReplaced(IBlockInformation currentInformation, IBlockInformation newInformation, BlockPos pos) {
            this.onBlockStateRemoved(currentInformation, pos);
            this.onBlockStateAdded(newInformation, pos);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128382_("skylight_blocking_bits", this.skylightBlockingBits.toByteArray());
            compoundTag.m_128382_("none_air_bits", this.noneAirBits.toByteArray());
            compoundTag.m_128376_("highestBit", this.highestBit);
            compoundTag.m_128350_("highestBitFriction", this.highestBitFriction);
            compoundTag.m_128379_("can_propagate_skylight_down", this.canPropagateSkylightDown);
            compoundTag.m_128379_("lowest_bit_can_sustain_grass", this.canLowestBitSustainGrass);
            return compoundTag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.skylightBlockingBits.clear();
            this.skylightBlockingBits.or(BitSet.valueOf(nbt.m_128463_("skylight_blocking_bits")));
            this.noneAirBits.clear();
            this.noneAirBits.or(BitSet.valueOf(nbt.m_128463_("none_air_bits")));
            this.highestBit = nbt.m_128448_("highestBit");
            this.highestBitFriction = nbt.m_128457_("highestBitFriction");
            this.canPropagateSkylightDown = nbt.m_128471_("can_propagate_skylight_down");
            this.canLowestBitSustainGrass = nbt.m_128471_("lowest_bit_can_sustain_grass");
        }

        @Override
        public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
            packetBuffer.m_178350_(this.skylightBlockingBits);
            packetBuffer.m_178350_(this.noneAirBits);
            packetBuffer.writeShort((int)this.highestBit);
            packetBuffer.writeFloat(this.highestBitFriction);
            packetBuffer.writeBoolean(this.canPropagateSkylightDown);
            packetBuffer.writeBoolean(this.canLowestBitSustainGrass);
        }

        @Override
        public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
            this.skylightBlockingBits.clear();
            this.skylightBlockingBits.or(packetBuffer.m_178384_());
            this.noneAirBits.clear();
            this.noneAirBits.or(packetBuffer.m_178384_());
            this.highestBit = packetBuffer.readShort();
            this.highestBitFriction = packetBuffer.readFloat();
            this.canPropagateSkylightDown = packetBuffer.readBoolean();
            this.canLowestBitSustainGrass = packetBuffer.readBoolean();
        }

        public void initializeWith(IBlockInformation blockInformation) {
            this.skylightBlockingBits.clear();
            this.noneAirBits.clear();
            this.skylightBlockingBits.set(0, StateEntrySize.current().getBitsPerBlockSide(), !ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((BlockGetter)new SingleBlockBlockReader(blockInformation, this.positionSupplier.get(), (BlockGetter)this.worldReaderSupplier.get()), this.positionSupplier.get()));
            this.noneAirBits.set(0, !blockInformation.isAir());
            if (blockInformation.isAir()) {
                this.highestBit = (short)-1;
                this.highestBitFriction = 0.0f;
            } else {
                this.highestBit = (short)(StateEntrySize.current().getBitsPerBlockSide() - 1);
                this.highestBitFriction = ILevelBasedPropertyAccessor.getInstance().getFriction((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            this.canPropagateSkylightDown = ILevelBasedPropertyAccessor.getInstance().propagatesSkylightDown((BlockGetter)new SingleBlockBlockReader(blockInformation, this.positionSupplier.get(), (BlockGetter)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.canLowestBitSustainGrass = blockInformation.isAir() || ILevelBasedPropertyAccessor.getInstance().canBeGrass((LevelReader)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), Blocks.f_50440_.m_49966_(), this.positionSupplier.get().m_7495_(), blockInformation.getBlockState(), this.positionSupplier.get()).orElseGet(() -> {
                if (blockInformation.getBlockState().m_60713_(Blocks.f_50125_) && (Integer)blockInformation.getBlockState().m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
                    return true;
                }
                if (blockInformation.getBlockState().m_60819_().m_76186_() == 8) {
                    return false;
                }
                int i = LayerLightEngine.m_75667_((BlockGetter)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), (BlockState)Blocks.f_50440_.m_49966_(), (BlockPos)this.positionSupplier.get().m_7495_(), (BlockState)blockInformation.getBlockState(), (BlockPos)this.positionSupplier.get(), (Direction)Direction.UP, (int)blockInformation.getBlockState().m_60739_((BlockGetter)new SingleBlockWorldReader(blockInformation, this.positionSupplier.get(), (LevelReader)this.worldReaderSupplier.get()), this.positionSupplier.get()));
                return i < this.worldReaderSupplier.get().m_7469_();
            }) != false;
        }
    }
}

