/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.query.index.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.index.NodeIndex;
import io.github.douira.glsl_transformer.ast.query.index.PrefixIdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.match.HintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.util.Passthrough;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Root {
    public final NodeIndex<?> nodeIndex;
    public final IdentifierIndex<?, ?> identifierIndex;
    public static final Supplier<NodeIndex<?>> nodeIndexFactoryDefault = NodeIndex::withUnordered;
    public static final Supplier<IdentifierIndex<?, ?>> identifierIndexFactoryDefault = IdentifierIndex::withOnlyExact;
    public static Supplier<NodeIndex<?>> nodeIndexFactory = nodeIndexFactoryDefault;
    public static Supplier<IdentifierIndex<?, ?>> identifierIndexFactory = identifierIndexFactoryDefault;
    private static Deque<Root> activeBuildRoots = new ArrayDeque<Root>();
    private List<? extends ASTNode> nodeList;
    private boolean activity;

    public Root(NodeIndex<?> nodeIndex, IdentifierIndex<?, ?> identifierIndex) {
        this.nodeIndex = nodeIndex;
        this.identifierIndex = identifierIndex;
    }

    public Root() {
        this(nodeIndexFactory.get(), identifierIndexFactory.get());
    }

    public static Root withExactUnordered() {
        return new Root(NodeIndex.withUnordered(), IdentifierIndex.withOnlyExact());
    }

    public static Root withExactOrdered() {
        return new Root(NodeIndex.withOrdered(), IdentifierIndex.withOnlyExact());
    }

    public static Root withExactOrderedBoth() {
        return new Root(NodeIndex.withOrdered(), IdentifierIndex.withOnlyExact(LinkedHashSet::new));
    }

    public static Root withPrefixUnordered() {
        return new Root(NodeIndex.withUnordered(), PrefixIdentifierIndex.withPrefix());
    }

    public static Root withPrefixOrdered() {
        return new Root(NodeIndex.withOrdered(), PrefixIdentifierIndex.withPrefix());
    }

    public static Root withPrefixOrderedBoth() {
        return new Root(NodeIndex.withOrdered(), PrefixIdentifierIndex.withPrefix(LinkedHashSet::new));
    }

    public static void resetRootFactories() {
        nodeIndexFactory = nodeIndexFactoryDefault;
        identifierIndexFactory = identifierIndexFactoryDefault;
    }

    public static Root getActiveBuildRoot() {
        return activeBuildRoots.peekFirst();
    }

    protected static final synchronized <R> R withActiveBuildRoot(Root instance, Function<Root, R> rootConsumer) {
        activeBuildRoots.push(instance);
        try {
            R r = rootConsumer.apply(instance);
            return r;
        }
        finally {
            activeBuildRoots.pop();
        }
    }

    public static synchronized <N extends ASTNode> N indexNodes(Root instance, Supplier<N> builder) {
        return (N)Root.withActiveBuildRoot(instance, root -> {
            ASTNode result = (ASTNode)builder.get();
            root.registerNode(result);
            return result;
        });
    }

    public static <N extends ASTNode> N indexNodes(Supplier<N> builder) {
        return Root.indexNodes(new Root(), builder);
    }

    public static <N extends ASTNode> N indexNodes(ASTNode parentTreeMember, Supplier<N> builder) {
        return Root.indexNodes(parentTreeMember.getRoot(), builder);
    }

    public static synchronized void indexBuildSession(Root instance, Runnable session) {
        Root.withActiveBuildRoot(instance, root -> {
            session.run();
            return null;
        });
    }

    public static void indexBuildSession(Runnable session) {
        Root.indexBuildSession(new Root(), session);
    }

    public static void indexBuildSession(ASTNode treeMember, Runnable session) {
        Root.indexBuildSession(treeMember.getRoot(), session);
    }

    public static synchronized <N extends ASTNode> void indexSeparateTrees(Root instance, Consumer<Passthrough<N>> registererConsumer) {
        Root.withActiveBuildRoot(instance, root -> {
            registererConsumer.accept(Passthrough.of(root::registerNode));
            return null;
        });
    }

    public static <N extends ASTNode> void indexSeparateTrees(Consumer<Passthrough<N>> registerer) {
        Root.indexSeparateTrees(new Root(), registerer);
    }

    public static <N extends ASTNode> void indexSeparateTrees(ASTNode treeMember, Consumer<Passthrough<N>> registerer) {
        Root.indexSeparateTrees(treeMember.getRoot(), registerer);
    }

    public PrefixIdentifierIndex<?, ?> getPrefixIdentifierIndex() {
        IdentifierIndex<?, ?> identifierIndex = this.identifierIndex;
        if (identifierIndex instanceof PrefixIdentifierIndex) {
            PrefixIdentifierIndex index = (PrefixIdentifierIndex)identifierIndex;
            return index;
        }
        throw new IllegalStateException("The identifier index is not a prefix index");
    }

    public void registerNode(ASTNode node) {
        this.nodeIndex.add(node);
        if (node instanceof Identifier) {
            Identifier identifier = (Identifier)node;
            this.identifierIndex.add(identifier);
        }
    }

    public void unregisterNode(ASTNode node) {
        this.nodeIndex.remove(node);
        if (node instanceof Identifier) {
            Identifier identifier = (Identifier)node;
            this.identifierIndex.remove(identifier);
        }
    }

    public void unregisterIdentifierRename(Identifier identifier) {
        this.identifierIndex.remove(identifier);
    }

    public void registerIdentifierRename(Identifier identifier) {
        this.identifierIndex.add(identifier);
    }

    private void ensureEmptyNodeList() {
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<ASTNode>();
        } else {
            this.nodeList.clear();
        }
    }

    public boolean rename(String oldName, String newName) {
        return this.identifierIndex.rename(oldName, newName);
    }

    public <N extends ASTNode> boolean process(Stream<? extends N> targets, Consumer<? super N> replacer) {
        this.ensureEmptyNodeList();
        if (targets == null) {
            return false;
        }
        List<? extends ASTNode> typedList = this.nodeList;
        targets.forEach(typedList::add);
        boolean activity = false;
        for (ASTNode aSTNode : typedList) {
            if (aSTNode == null) continue;
            replacer.accept(aSTNode);
            activity = true;
        }
        return activity;
    }

    public boolean process(String name, Consumer<Identifier> replacer) {
        return this.process(this.identifierIndex.getStream(name), replacer);
    }

    public void replaceReferenceExpressions(ASTParser t, String name, String expression) {
        this.replaceReferenceExpressions(t, this.identifierIndex.getStream(name), expression);
    }

    public boolean replaceReferenceExpressionsReport(ASTParser t, String name, String expression) {
        return this.replaceReferenceExpressionsReport(t, this.identifierIndex.getStream(name), expression);
    }

    public void replaceReferenceExpressions(ASTParser t, Stream<Identifier> targets, String expression) {
        this.process(targets, (? super N identifier) -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            parent.replaceByAndDelete(t.parseExpression((ASTNode)identifier, expression));
        });
    }

    public boolean replaceReferenceExpressionsReport(ASTParser t, Stream<Identifier> targets, String expression) {
        this.activity = false;
        this.process(targets, (? super N identifier) -> {
            ASTNode parent = identifier.getParent();
            if (!(parent instanceof ReferenceExpression)) {
                return;
            }
            parent.replaceByAndDelete(t.parseExpression((ASTNode)identifier, expression));
            this.activity = true;
        });
        return this.activity;
    }

    public boolean replaceExpressions(ASTParser t, Stream<? extends Expression> targets, String expression) {
        return this.process(targets, (? super N node) -> node.replaceByAndDelete(t.parseExpression((ASTNode)node, expression)));
    }

    public static boolean replaceExpressionsConcurrent(ASTParser t, List<? extends Expression> targets, String expression) {
        for (Expression expression2 : targets) {
            expression2.replaceByAndDelete(t.parseExpression((ASTNode)expression2, expression));
        }
        return !targets.isEmpty();
    }

    public <N extends ASTNode> boolean processMatches(ASTParser t, Stream<? extends ASTNode> matchTargetChildren, Matcher<N> matcher, Consumer<? super N> replacer) {
        Class matchClass = matcher.getPatternClass();
        return this.process(matchTargetChildren.map(node -> node.getAncestor(matchClass)).distinct().filter(matcher::matches), replacer);
    }

    public <N extends ASTNode> boolean processMatches(ASTParser t, HintedMatcher<N> hintedMatcher, Consumer<? super N> replacer) {
        return this.processMatches(t, this.identifierIndex.getStream(hintedMatcher.getHint()), hintedMatcher, replacer);
    }

    public <N extends Expression> boolean replaceExpressionMatches(ASTParser t, Stream<? extends ASTNode> matchTargetChildren, Matcher<N> matcher, String expression) {
        Class matchClass = matcher.getPatternClass();
        return this.replaceExpressions(t, matchTargetChildren.map(node -> (Expression)node.getAncestor(matchClass)).distinct().filter(matcher::matches), expression);
    }

    public <N extends Expression> boolean replaceExpressionMatches(ASTParser t, HintedMatcher<N> hintedMatcher, String expression) {
        return this.replaceExpressionMatches(t, this.identifierIndex.getStream(hintedMatcher.getHint()), hintedMatcher, expression);
    }
}

