/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query.index;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.query.index.Index;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class IdentifierIndex<S extends Set<Identifier>, I extends Map<String, S>>
implements Index<Identifier> {
    public final I index;
    public final Supplier<S> setFactory;

    public IdentifierIndex(I index, Supplier<S> setFactory) {
        this.index = index;
        this.setFactory = setFactory;
    }

    @Override
    public void add(Identifier node) {
        String name = node.getName();
        Set set = (Set)this.index.get(name);
        if (set == null) {
            set = (Set)this.setFactory.get();
            this.index.put((String)name, (Set)set);
        }
        set.add(node);
    }

    @Override
    public void remove(Identifier node) {
        String name = node.getName();
        Set set = (Set)this.index.get(name);
        if (set == null) {
            return;
        }
        set.remove(node);
        if (set.isEmpty()) {
            this.index.remove(name);
        }
    }

    public Set<Identifier> get(String key) {
        Set result = (Set)this.index.get(key);
        return result == null ? Collections.emptySet() : result;
    }

    public Stream<Identifier> getStream(String key) {
        Set result = (Set)this.index.get(key);
        return result == null ? Stream.empty() : result.stream();
    }

    public <N extends ASTNode> Stream<N> getAncestors(String key, Class<N> ancestorType) {
        return this.getStream(key).map(id -> id.getAncestor(ancestorType)).filter(Objects::nonNull);
    }

    public Stream<ReferenceExpression> getReferenceExpressions(String key) {
        return this.getStream(key).map(id -> id.getAncestor(ReferenceExpression.class)).filter(Objects::nonNull);
    }

    public ReferenceExpression getOneReferenceExpression(String key) {
        return this.getReferenceExpressions(key).findFirst().orElse(null);
    }

    public Identifier getOne(String key) {
        Iterator iterator = ((Set)this.index.get(key)).iterator();
        return iterator.hasNext() ? (Identifier)iterator.next() : null;
    }

    public Identifier getUnique(String key) {
        int resultSize;
        Set set = (Set)this.index.get(key);
        int n = resultSize = set == null ? 0 : set.size();
        if (resultSize != 1) {
            throw new IllegalStateException("Expected exactly one identifier for key " + key + ", but got " + resultSize);
        }
        return (Identifier)set.iterator().next();
    }

    public boolean has(String key) {
        Set result = (Set)this.index.get(key);
        return result != null && !result.isEmpty();
    }

    public boolean rename(String oldName, String newName) {
        if (oldName.equals(newName)) {
            return false;
        }
        Identifier.validateContents(newName);
        Set set = (Set)this.index.get(oldName);
        if (set == null) {
            return false;
        }
        this.index.remove(oldName);
        Set existing = (Set)this.index.get(newName);
        if (existing == null) {
            this.index.put((String)newName, (Set)set);
        } else {
            existing.addAll(set);
        }
        for (Identifier id : set) {
            id._setNameInternal(newName);
        }
        return true;
    }

    public static IdentifierIndex<HashSet<Identifier>, HashMap<String, HashSet<Identifier>>> withOnlyExact() {
        return new IdentifierIndex<HashSet<Identifier>, HashMap<String, HashSet<Identifier>>>(new HashMap(), HashSet::new);
    }

    public static <R extends Set<Identifier>> IdentifierIndex<R, HashMap<String, R>> withOnlyExact(Supplier<R> setFactory) {
        return new IdentifierIndex(new HashMap(), setFactory);
    }
}

