/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class XHFPTerrainVertex
implements ChunkVertexEncoder,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;
    private boolean flipUpcomingNormal;

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }

    @Override
    public void flipUpcomingQuadNormal() {
        this.flipUpcomingNormal = true;
    }

    public long write(long ptr, ChunkVertexEncoder.Vertex vertex, int chunkId) {
        this.uSum += vertex.u;
        this.vSum += vertex.v;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)(ptr + 0L), (short)XHFPModelVertexType.encodePosition(vertex.x));
        MemoryUtil.memPutShort((long)(ptr + 2L), (short)XHFPModelVertexType.encodePosition(vertex.y));
        MemoryUtil.memPutShort((long)(ptr + 4L), (short)XHFPModelVertexType.encodePosition(vertex.z));
        MemoryUtil.memPutShort((long)(ptr + 6L), (short)((short)chunkId));
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)vertex.color);
        MemoryUtil.memPutShort((long)(ptr + 12L), (short)XHFPModelVertexType.encodeBlockTexture(vertex.u));
        MemoryUtil.memPutShort((long)(ptr + 14L), (short)XHFPModelVertexType.encodeBlockTexture(vertex.v));
        MemoryUtil.memPutInt((long)(ptr + 16L), (int)vertex.light);
        MemoryUtil.memPutShort((long)(ptr + 36L), (short)this.contextHolder.blockId);
        MemoryUtil.memPutShort((long)(ptr + 38L), (short)this.contextHolder.renderType);
        MemoryUtil.memPutInt((long)(ptr + 40L), (int)ExtendedDataHelper.computeMidBlock(vertex.x, vertex.y, vertex.z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            MemoryUtil.memPutFloat((long)(ptr + 20L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(ptr + 20L - 44L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(ptr + 20L - 88L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(ptr + 20L - 132L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(ptr + 24L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(ptr + 24L - 44L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(ptr + 24L - 88L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(ptr + 24L - 132L), (float)this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(ptr, 44);
            if (this.flipUpcomingNormal) {
                NormalHelper.computeFaceNormalFlipped(this.normal, this.quad);
                this.flipUpcomingNormal = false;
            } else {
                NormalHelper.computeFaceNormal(this.normal, this.quad);
            }
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtil.memPutInt((long)(ptr + 32L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(ptr + 32L - 44L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(ptr + 32L - 88L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(ptr + 32L - 132L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(ptr + 28L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 28L - 44L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 28L - 88L), (int)tangent);
            MemoryUtil.memPutInt((long)(ptr + 28L - 132L), (int)tangent);
        }
        return ptr + 44L;
    }
}

