/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.parameter.SodiumParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;

public class SodiumTransformer {
    public static void transform(ASTParser t, TranslationUnit tree, Root root, SodiumParameters parameters) {
        CommonTransformer.transform(t, tree, root, parameters);
        root.replaceExpressionMatches(t, CommonTransformer.glTextureMatrix0, "mat4(1.0)");
        root.replaceExpressionMatches(t, CommonTransformer.glTextureMatrix1, "iris_LightmapTextureMatrix");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_FUNCTIONS, "uniform mat4 iris_LightmapTextureMatrix;");
        root.rename("gl_ProjectionMatrix", "iris_ProjectionMatrix");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            root.rename("gl_MultiTexCoord2", "gl_MultiTexCoord1");
            if (parameters.inputs.hasTex()) {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord0", "vec4(_vert_tex_diffuse_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord0", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            if (parameters.inputs.hasLight()) {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord1", "vec4(_vert_tex_light_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            }
            AttributeTransformer.patchMultiTexCoord3(t, tree, root, parameters);
            CommonTransformer.replaceGlMultiTexCoordBounded(t, root, 4, 7);
        }
        if (parameters.inputs.hasColor()) {
            root.rename("gl_Color", "_vert_color");
        } else {
            root.replaceReferenceExpressions(t, "gl_Color", "vec4(1.0)");
        }
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            if (parameters.inputs.hasNormal()) {
                root.rename("gl_Normal", "iris_Normal");
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec3 iris_Normal;");
            } else {
                root.replaceReferenceExpressions(t, "gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        root.replaceReferenceExpressions(t, "gl_NormalMatrix", "mat3(iris_NormalMatrix)");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_NormalMatrix;");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatrixInverse;");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ProjectionMatrixInverse;");
        root.rename("gl_ModelViewMatrix", "iris_ModelViewMatrix");
        root.rename("gl_ModelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        root.rename("gl_ProjectionMatrixInverse", "iris_ProjectionMatrixInverse");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            if (root.identifierIndex.has("ftransform")) {
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, "vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
            }
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec3 _vert_position;", "vec2 _vert_tex_diffuse_coord;", "ivec2 _vert_tex_light_coord;", "vec4 _vert_color;", "uint _draw_id;", "in vec4 a_PosId;", "in vec4 a_Color;", "in vec2 a_TexCoord;", "in ivec2 a_LightCoord;", "void _vert_init() {_vert_position = (a_PosId.xyz * " + String.valueOf(parameters.positionScale) + " + " + String.valueOf(parameters.positionOffset) + ");_vert_tex_diffuse_coord = (a_TexCoord * " + String.valueOf(parameters.textureScale) + ");_vert_tex_light_coord = a_LightCoord;_vert_color = a_Color;_draw_id = uint(a_PosId.w); }", "struct DrawParameters { vec4 offset; };", "layout(std140) uniform ubo_DrawParameters {DrawParameters Chunks[256]; };", "uniform mat4 iris_ProjectionMatrix;", "uniform mat4 iris_ModelViewMatrix;", "uniform vec3 u_RegionOffset;", "vec4 getVertexPosition() { return vec4(u_RegionOffset + Chunks[_draw_id].offset.xyz + _vert_position, 1.0); }");
            tree.prependMainFunctionBody(t, "_vert_init();");
            root.replaceReferenceExpressions(t, "gl_Vertex", "getVertexPosition()");
        } else {
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatrix;", "uniform mat4 iris_ProjectionMatrix;");
        }
        root.replaceReferenceExpressions(t, "gl_ModelViewProjectionMatrix", "(iris_ProjectionMatrix * iris_ModelViewMatrix)");
        CommonTransformer.applyIntelHd4000Workaround(root);
    }
}

