/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Minecraft;

public class ShadowCompositeRenderer {
    private final ShadowRenderTargets renderTargets;
    private final ImmutableList<Pass> passes;
    private final TextureAccess noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final Object2ObjectMap<String, TextureAccess> customTextureIds;
    private final ImmutableSet<Integer> flippedAtLeastOnceFinal;
    private final CustomUniforms customUniforms;
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures;
    private final WorldRenderingPipeline pipeline;

    public ShadowCompositeRenderer(WorldRenderingPipeline pipeline, PackDirectives packDirectives, ProgramSource[] sources, ComputeSource[][] computes, ShadowRenderTargets renderTargets, TextureAccess noiseTexture, FrameUpdateNotifier updateNotifier, Object2ObjectMap<String, TextureAccess> customTextureIds, ImmutableMap<Integer, Boolean> explicitPreFlips, Object2ObjectMap<String, TextureAccess> irisCustomTextures, CustomUniforms customUniforms) {
        this.pipeline = pipeline;
        this.noiseTexture = noiseTexture;
        this.updateNotifier = updateNotifier;
        this.renderTargets = renderTargets;
        this.customTextureIds = customTextureIds;
        this.irisCustomTextures = irisCustomTextures;
        this.customUniforms = customUniforms;
        PackRenderTargetDirectives renderTargetDirectives = packDirectives.getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> renderTargetSettings = renderTargetDirectives.getRenderTargetSettings();
        ImmutableList.Builder passes = ImmutableList.builder();
        ImmutableSet.Builder flippedAtLeastOnce = new ImmutableSet.Builder();
        explicitPreFlips.forEach((buffer, shouldFlip) -> {
            if (shouldFlip.booleanValue()) {
                renderTargets.flip((int)buffer);
            }
        });
        int sourcesLength = sources.length;
        for (int i = 0; i < sourcesLength; ++i) {
            Pass pass;
            ProgramSource source = sources[i];
            ImmutableSet<Integer> flipped = renderTargets.snapshot();
            ImmutableSet flippedAtLeastOnceSnapshot = flippedAtLeastOnce.build();
            if (source == null || !source.isValid()) {
                if (computes[i] == null) continue;
                pass = new ComputeOnlyPass();
                ((ComputeOnlyPass)pass).computes = this.createComputes(computes[i], flipped, (ImmutableSet<Integer>)flippedAtLeastOnceSnapshot, renderTargets);
                passes.add((Object)pass);
                continue;
            }
            pass = new Pass();
            ProgramDirectives directives = source.getDirectives();
            pass.program = this.createProgram(source, flipped, (ImmutableSet<Integer>)flippedAtLeastOnceSnapshot, renderTargets);
            pass.computes = this.createComputes(computes[i], flipped, (ImmutableSet<Integer>)flippedAtLeastOnceSnapshot, renderTargets);
            int[] drawBuffers = new int[]{0, 1};
            GlFramebuffer framebuffer = renderTargets.createColorFramebuffer(flipped, drawBuffers);
            pass.stageReadsFromAlt = flipped;
            pass.framebuffer = framebuffer;
            pass.viewportScale = directives.getViewportScale();
            pass.mipmappedBuffers = directives.getMipmappedBuffers();
            pass.flippedAtLeastOnce = flippedAtLeastOnceSnapshot;
            passes.add((Object)pass);
            ImmutableMap<Integer, Boolean> explicitFlips = directives.getExplicitFlips();
            for (int buffer2 : drawBuffers) {
                if (explicitFlips.get((Object)buffer2) == Boolean.FALSE) continue;
                renderTargets.flip(buffer2);
                flippedAtLeastOnce.add((Object)buffer2);
            }
            explicitFlips.forEach((buffer, shouldFlip) -> {
                if (shouldFlip.booleanValue()) {
                    renderTargets.flip((int)buffer);
                    flippedAtLeastOnce.add(buffer);
                }
            });
        }
        this.passes = passes.build();
        this.flippedAtLeastOnceFinal = flippedAtLeastOnce.build();
        GlStateManager.m_84486_((int)36008, (int)0);
    }

    public ImmutableSet<Integer> getFlippedAtLeastOnceFinal() {
        return this.flippedAtLeastOnceFinal;
    }

    public void renderAll() {
        RenderSystem.m_69461_();
        FullScreenQuadRenderer.INSTANCE.begin();
        for (Pass renderPass : this.passes) {
            boolean ranCompute = false;
            for (ComputeProgram computeProgram : renderPass.computes) {
                if (computeProgram == null) continue;
                ranCompute = true;
                computeProgram.use();
                this.customUniforms.push(computeProgram);
                com.mojang.blaze3d.pipeline.RenderTarget main = Minecraft.m_91087_().m_91385_();
                computeProgram.dispatch(main.f_83915_, main.f_83916_);
            }
            if (ranCompute) {
                IrisRenderSystem.memoryBarrier(40);
            }
            Program.unbind();
            if (renderPass instanceof ComputeOnlyPass) continue;
            if (!renderPass.mipmappedBuffers.isEmpty()) {
                RenderSystem.m_69388_((int)33984);
                UnmodifiableIterator unmodifiableIterator = renderPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int index = (Integer)unmodifiableIterator.next();
                    ShadowCompositeRenderer.setupMipmapping(this.renderTargets.get(index), renderPass.stageReadsFromAlt.contains((Object)index));
                }
            }
            float scaledWidth = (float)this.renderTargets.getResolution() * renderPass.viewportScale;
            float scaledHeight = (float)this.renderTargets.getResolution() * renderPass.viewportScale;
            RenderSystem.m_69949_((int)0, (int)0, (int)((int)scaledWidth), (int)((int)scaledHeight));
            renderPass.framebuffer.bind();
            renderPass.program.use();
            this.customUniforms.push(renderPass.program);
            FullScreenQuadRenderer.INSTANCE.renderQuad();
        }
        FullScreenQuadRenderer.INSTANCE.end();
        ProgramUniforms.clearActiveUniforms();
        GlStateManager.m_84478_((int)0);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            ShadowCompositeRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        RenderSystem.m_69388_((int)33984);
    }

    private static void setupMipmapping(RenderTarget target, boolean readFromAlt) {
        int texture = readFromAlt ? target.getAltTexture() : target.getMainTexture();
        IrisRenderSystem.generateMipmaps(texture, 3553);
        IrisRenderSystem.texParameteri(texture, 3553, 10241, 9987);
    }

    private static void resetRenderTarget(RenderTarget target) {
        IrisRenderSystem.texParameteri(target.getMainTexture(), 3553, 10241, 9729);
        IrisRenderSystem.texParameteri(target.getAltTexture(), 3553, 10241, 9729);
    }

    private Program createProgram(ProgramSource source, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, ShadowRenderTargets targets) {
        ProgramBuilder builder;
        Map<PatchShaderType, String> transformed = TransformPatcher.patchComposite(source.getVertexSource().orElseThrow(NullPointerException::new), source.getGeometrySource().orElse(null), source.getFragmentSource().orElseThrow(NullPointerException::new), TextureStage.SHADOWCOMP, this.pipeline.getTextureMap());
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        PatchedShaderPrinter.debugPatchedShaders(source.getName(), vertex, geometry, fragment);
        Objects.requireNonNull(flipped);
        try {
            builder = ProgramBuilder.begin(source.getName(), vertex, geometry, fragment, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
        CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
        this.customUniforms.assignTo(builder);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
        IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, targets, flipped);
        IrisImages.addShadowColorImages(builder, targets, flipped);
        Program build = builder.build();
        this.customUniforms.mapholderToPass(builder, build);
        return build;
    }

    private ComputeProgram[] createComputes(ComputeSource[] sources, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, ShadowRenderTargets targets) {
        ComputeProgram[] programs = new ComputeProgram[sources.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = sources[i];
            if (source == null || !source.getSource().isPresent()) continue;
            Objects.requireNonNull(flipped);
            try {
                builder = ProgramBuilder.beginCompute(source.getName(), TransformPatcher.patchCompute(source.getSource().orElse(null), TextureStage.SHADOWCOMP, this.pipeline.getTextureMap()), IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Shader compilation failed!", e);
            }
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
            CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
            this.customUniforms.assignTo(builder);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, targets, flipped);
            IrisImages.addShadowColorImages(builder, targets, flipped);
            programs[i] = builder.buildCompute();
            this.customUniforms.mapholderToPass(builder, programs[i]);
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups());
        }
        return programs;
    }

    public void destroy() {
        for (Pass renderPass : this.passes) {
            renderPass.destroy();
        }
    }

    private static class ComputeOnlyPass
    extends Pass {
        private ComputeOnlyPass() {
        }

        @Override
        protected void destroy() {
            for (ComputeProgram compute : this.computes) {
                if (compute == null) continue;
                compute.destroy();
            }
        }
    }

    private static class Pass {
        Program program;
        GlFramebuffer framebuffer;
        ImmutableSet<Integer> flippedAtLeastOnce;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;
        float viewportScale;
        ComputeProgram[] computes;

        private Pass() {
        }

        protected void destroy() {
            this.program.destroy();
            for (ComputeProgram compute : this.computes) {
                if (compute == null) continue;
                compute.destroy();
            }
        }
    }
}

