/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedSlopedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction orientation;
    private final boolean ySlope;

    public FramedSlopedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        this.facing = cmpDir.direction();
        this.orientation = cmpDir.orientation();
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean yFacing = Utils.isY(this.facing);
        boolean yOrient = Utils.isY(this.orientation);
        Direction orientOpp = this.orientation.m_122424_();
        Direction quadFace = quad.m_111306_();
        if (quadFace == orientOpp && !yOrient) {
            if (!yFacing) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing)).apply(Modifiers.makeHorizontalSlope(this.orientation == this.facing.m_122427_(), 45.0f)).export(quadMap.get(null));
            } else if (!this.ySlope) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing)).apply(Modifiers.makeVerticalSlope(this.facing == Direction.UP, 45.0f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && yFacing && Utils.isY(quadFace)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(orientOpp, 45.0f)).export(quadMap.get(null));
            Direction offAxisCW = this.orientation.m_122427_();
            Direction offAxisCCW = this.orientation.m_122428_();
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(offAxisCW, 0.5f)).apply(Modifiers.cutTopBottom(orientOpp, 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(offAxisCCW, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(offAxisCCW, 0.5f)).apply(Modifiers.cutTopBottom(orientOpp, 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(offAxisCW, 45.0f)).export(quadMap.get(null));
        } else if (!this.ySlope && yOrient && quadFace == this.facing) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(this.orientation == Direction.DOWN, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && yOrient && quadFace == orientOpp) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        } else if (quadFace == this.orientation) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing)).export(quadMap.get(quadFace));
        } else if (!this.ySlope && yFacing && quadFace.m_122434_() == this.orientation.m_122427_().m_122434_()) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), up ? 0.0f : 1.0f, up ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (yOrient && quadFace.m_122434_() == this.facing.m_122427_().m_122434_()) {
            boolean right = quadFace == this.facing.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.cutSideUpDown(this.orientation == Direction.UP, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.m_122428_(), 45.0f)).export(quadMap.get(null));
        } else if (!(this.ySlope || yOrient || yFacing || quadFace != this.facing)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && !yOrient && !yFacing && Utils.isY(quadFace)) {
            boolean right = this.orientation == this.facing.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.cutTopBottom(orientOpp, right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlopedPrism.get()).m_49966_().m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.UP_WEST));
    }
}

