/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;
import xfacthd.framedblocks.common.net.SignUpdatePacket;

public class FramedSignScreen
extends Screen {
    private static final Table<BlockState, Direction, TextureAtlasSprite> SPRITE_CACHE = HashBasedTable.create();
    private static final ResourceLocation DEFAULT_TEXTURE = Utils.rl("block/framed_block");
    public static final Component TITLE = Utils.translate("title", "sign.edit");
    public static final Component DONE = Utils.translate("button", "gui.done");
    private static final int TEX_W = 128;
    private static final int TEX_H = 64;
    private static final int TEX_MAX_V = 8;
    private final FramedSignBlockEntity sign;
    private final String[] lines = new String[4];
    private int blinkCounter = 0;
    private int currLine = 0;
    private TextFieldHelper inputUtil;
    private int texX;
    private int texY;

    public FramedSignScreen(FramedSignBlockEntity sign) {
        super(TITLE);
        this.sign = sign;
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = sign.getLine(i).getString();
        }
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)DONE, btn -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 60).m_253046_(200, 20).m_253136_());
        this.inputUtil = new TextFieldHelper(() -> this.lines[this.currLine], line -> {
            this.lines[this.currLine] = line;
            this.sign.setLine(this.currLine, (Component)Component.m_237113_((String)line));
        }, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), line -> this.f_96541_.f_91062_.m_92895_(line) <= 90);
        this.texX = this.f_96543_ / 2 - 64;
        this.texY = this.f_96544_ / 2 - 32 - 20;
    }

    public void m_7861_() {
        FramedBlocks.CHANNEL.sendToServer((Object)new SignUpdatePacket(this.sign.m_58899_(), new String[]{this.sign.getLine(0).getString(), this.sign.getLine(1).getString(), this.sign.getLine(2).getString(), this.sign.getLine(3).getString()}));
    }

    public void m_86600_() {
        ++this.blinkCounter;
        if (!this.sign.m_58903_().m_155262_(this.sign.m_58900_())) {
            this.m_7861_();
        }
    }

    public boolean m_5534_(char character, int modifiers) {
        this.inputUtil.m_95143_(character);
        return true;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 265) {
            this.currLine = this.currLine - 1 & 3;
            this.inputUtil.m_95193_();
            return true;
        }
        if (key == 264 || key == 257 || key == 335) {
            this.currLine = this.currLine + 1 & 3;
            this.inputUtil.m_95193_();
            return true;
        }
        return this.inputUtil.m_95145_(key) || super.m_7933_(key, scanCode, modifiers);
    }

    public void m_86412_(PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
        Lighting.m_84930_();
        this.m_7333_(mstack);
        FramedSignScreen.m_93215_((PoseStack)mstack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)40, (int)ChatFormatting.WHITE.m_126665_());
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        TextureAtlasSprite sprite = this.getFrontSprite();
        FramedSignScreen.m_93112_((Matrix4f)mstack.m_85850_().m_252922_(), (int)this.texX, (int)(this.texX + 128), (int)this.texY, (int)(this.texY + 64), (int)0, (float)sprite.m_118409_(), (float)sprite.m_118410_(), (float)sprite.m_118411_(), (float)sprite.m_118393_(8.0));
        mstack.m_85836_();
        mstack.m_85837_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0 - 20.0, 0.0);
        mstack.m_85841_(1.2f, 1.2f, 1.0f);
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        this.drawLines(mstack.m_85850_().m_252922_(), buffer, this.lines);
        this.drawCursor(mstack, buffer, this.lines);
        mstack.m_85849_();
        Lighting.m_84931_();
        super.m_86412_(mstack, mouseX, mouseY, partialTicks);
    }

    private void drawLines(Matrix4f matrix, MultiBufferSource.BufferSource buffer, String[] lines) {
        int color = this.sign.getTextColor().m_41071_();
        for (int line = 0; line < lines.length; ++line) {
            String text = lines[line];
            if (text == null) continue;
            if (this.f_96547_.m_92718_()) {
                text = this.f_96547_.m_92801_(text);
            }
            float textX = (float)(-this.f_96547_.m_92895_(text)) / 2.0f;
            this.f_96547_.m_271703_(text, textX, (float)(line * 10 - 20), color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        buffer.m_109911_();
    }

    private void drawCursor(PoseStack mstack, MultiBufferSource.BufferSource buffer, String[] lines) {
        Matrix4f matrix = mstack.m_85850_().m_252922_();
        int color = this.sign.getTextColor().m_41071_();
        boolean blink = this.blinkCounter / 6 % 2 == 0;
        int dir = this.f_96547_.m_92718_() ? -1 : 1;
        int y = this.currLine * 10 - 20;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || i != this.currLine || this.inputUtil.m_95194_() < 0) continue;
            int hw = this.f_96547_.m_92895_(line) / 2;
            int selectionEnd = this.f_96547_.m_92895_(line.substring(0, Math.max(Math.min(this.inputUtil.m_95194_(), line.length()), 0)));
            int cursorX = (selectionEnd - hw) * dir;
            if (blink) {
                if (this.inputUtil.m_95194_() < line.length()) {
                    FramedSignScreen.m_93172_((PoseStack)mstack, (int)cursorX, (int)(y - 1), (int)(cursorX + 1), (int)(y + 9), (int)(0xFF000000 | color));
                } else {
                    this.f_96547_.m_271703_("_", (float)cursorX, (float)y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    buffer.m_109911_();
                }
            }
            if (this.inputUtil.m_95197_() == this.inputUtil.m_95194_()) continue;
            int x1 = (this.f_96547_.m_92895_(line.substring(0, this.inputUtil.m_95197_())) - hw) * dir;
            int x2 = (this.f_96547_.m_92895_(line.substring(0, this.inputUtil.m_95194_())) - hw) * dir;
            int xStart = Math.min(x1, x2);
            int xEnd = Math.max(x1, x2);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder tessBuffer = tessellator.m_85915_();
            RenderSystem.m_69479_();
            RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            tessBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            tessBuffer.m_252986_(matrix, (float)xStart, (float)y + 9.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            tessBuffer.m_252986_(matrix, (float)xEnd, (float)y + 9.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            tessBuffer.m_252986_(matrix, (float)xEnd, (float)y - 1.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            tessBuffer.m_252986_(matrix, (float)xStart, (float)y - 1.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)tessBuffer.m_231175_());
            RenderSystem.m_69462_();
        }
    }

    private TextureAtlasSprite getFrontSprite() {
        Direction front;
        BlockState state = this.sign.m_58900_();
        if (state.m_60734_() == FBContent.blockFramedWallSign.get()) {
            front = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        } else {
            int rot = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
            double angle = (double)rot * 360.0 / 16.0;
            front = Direction.m_122364_((double)angle);
        }
        BlockState camoState = this.sign.getCamo().getState();
        if (camoState.m_60795_()) {
            camoState = ((Block)FBContent.blockFramedCube.get()).m_49966_();
        }
        if (!SPRITE_CACHE.contains((Object)camoState, (Object)front)) {
            BakedModel model = this.f_96541_.m_91289_().m_110910_(camoState);
            ChunkRenderTypeSet layers = model.getRenderTypes(camoState, this.f_96541_.f_91073_.m_213780_(), ModelData.EMPTY);
            List quads = model.getQuads(camoState, front, this.f_96541_.f_91073_.m_213780_(), ModelData.EMPTY, (RenderType)layers.iterator().next());
            TextureAtlasSprite sprite = !quads.isEmpty() ? ((BakedQuad)quads.get(0)).m_173410_() : (TextureAtlasSprite)this.f_96541_.m_91258_(TextureAtlas.f_118259_).apply(DEFAULT_TEXTURE);
            SPRITE_CACHE.put((Object)camoState, (Object)front, (Object)sprite);
        }
        return (TextureAtlasSprite)SPRITE_CACHE.get((Object)camoState, (Object)front);
    }

    public static void onTextureStitch(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            SPRITE_CACHE.clear();
        }
    }
}

