/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDividedSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedDividedSlopeBlock
extends AbstractFramedDoubleBlock {
    public FramedDividedSlopeBlock() {
        super(BlockType.FRAMED_DIVIDED_SLOPE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedDividedSlopeBlock.withSlopeType(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        return FramedDividedSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.m_122424_()) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (type == SlopeType.HORIZONTAL) {
            BlockState defState = ((Block)FBContent.blockFramedVerticalHalfSlope.get()).m_49966_();
            return new Tuple((Object)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
        }
        BlockState defState = ((Block)FBContent.blockFramedHalfSlope.get()).m_49966_();
        boolean top = type == SlopeType.TOP;
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDividedSlopeBlockEntity(pos, state);
    }
}

