/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedDoubleCornerBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)));
        if (type.isHorizontal()) {
            if (side == null) {
                return false;
            }
            return side == dir || side == dir.m_122424_() || side == dir.m_122428_() && !type.isRight() || side == dir.m_122427_() && type.isRight() || side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop();
        }
        return side != null && Utils.isY(side) || side == dir || side == dir.m_122428_();
    };

    public FramedDoubleCornerBlock() {
        super(BlockType.FRAMED_DOUBLE_CORNER);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.CORNER_TYPE, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction side;
        BlockState state = this.m_49966_();
        Direction typeSide = side = context.m_43719_();
        Vec3 hitPoint = Utils.fraction(context.m_43720_());
        if (!Utils.isY(side)) {
            if (hitPoint.m_7098_() < 0.1875) {
                typeSide = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                typeSide = Direction.DOWN;
            }
        }
        return FramedDoubleCornerBlock.withCornerType(state, context, side, typeSide, hitPoint, context.m_8125_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            return (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.rotate(rot)));
        }
        return this.m_6843_(state, rot);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            BlockState newState = Utils.mirrorFaceBlock(state, mirror);
            if (newState != state) {
                return (BlockState)newState.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.horizontalOpposite()));
            }
            return state;
        }
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedInnerCornerSlope.get()).m_49966_().m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedCornerSlope.get()).m_49966_().m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.verticalOpposite()))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleCornerBlockEntity(pos, state);
    }
}

