/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedVerticalHalfSlopeBlock
extends FramedBlock {
    public static final VoxelShape SHAPE_BOTTOM = Shapes.m_83124_((VoxelShape)FramedVerticalHalfSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)8.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedVerticalHalfSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)15.5), FramedVerticalHalfSlopeBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), FramedVerticalHalfSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0), FramedVerticalHalfSlopeBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)8.0, (double)4.0), FramedVerticalHalfSlopeBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)0.5)});
    public static final VoxelShape SHAPE_TOP = Shapes.m_83124_((VoxelShape)FramedVerticalHalfSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedVerticalHalfSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)16.0, (double)15.5), FramedVerticalHalfSlopeBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedVerticalHalfSlopeBlock.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedVerticalHalfSlopeBlock.m_49796_((double)12.0, (double)8.0, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedVerticalHalfSlopeBlock.m_49796_((double)15.5, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)});

    public FramedVerticalHalfSlopeBlock() {
        super(BlockType.FRAMED_VERTICAL_HALF_SLOPE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction side = context.m_43719_();
        Vec3 hitVec = context.m_43720_();
        Direction dir = side.m_122424_();
        if (Utils.fractionInDir(hitVec, side.m_122428_()) > 0.5) {
            dir = dir.m_122427_();
        }
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        state = FramedVerticalHalfSlopeBlock.withTop(state, side, hitVec);
        return FramedVerticalHalfSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(facing));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            VoxelShape shape = top ? SHAPE_TOP : SHAPE_BOTTOM;
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

