/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedStackedSlopePanelBlockEntity
extends FramedDoubleBlockEntity {
    private final boolean corner;
    private final boolean innerCorner;

    public FramedStackedSlopePanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedStackedSlopePanel.get(), pos, state);
        BlockType type = (BlockType)this.getBlockType();
        this.corner = type != BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER;
        this.innerCorner = type == BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER;
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        Direction side = hit.m_82434_();
        Vec3 vec = Utils.fraction(hit.m_82450_());
        if (side == facing) {
            return false;
        }
        if (side == facing.m_122424_()) {
            return true;
        }
        return Utils.fractionInDir(vec, facing.m_122424_()) > 0.5;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        return DoubleSoundMode.EITHER;
    }

    @Override
    public CamoContainer getCamo(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == facing) {
            return this.getCamo();
        }
        if (side == facing.m_122424_()) {
            return this.getCamoTwo();
        }
        return EmptyCamoContainer.EMPTY;
    }

    @Override
    public boolean isSolidSide(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == facing || side == facing.m_122424_()) {
            return this.getCamo(side).isSolid((BlockGetter)this.f_58857_, this.f_58858_);
        }
        HorizontalRotation rot = (HorizontalRotation)((Object)this.m_58900_().m_61143_(PropertyHolder.ROTATION));
        HorizontalRotation rotCw = rot.rotate(Rotation.COUNTERCLOCKWISE_90);
        if (rot.withFacing(facing) == side.m_122424_() && !this.corner || rotCw.withFacing(facing) == side.m_122424_() && this.innerCorner) {
            return this.getCamo().isSolid((BlockGetter)this.f_58857_, this.f_58858_) && this.getCamoTwo().isSolid((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return false;
    }
}

