/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;

public final class FramingSawRecipe
implements Recipe<Container> {
    public static final int CUBE_MATERIAL_VALUE = 6144;
    public static final int MAX_ADDITIVE_COUNT = 3;
    private static final Lazy<ItemStack> TOAST_ICON = Lazy.of(() -> new ItemStack((ItemLike)FBContent.blockFramingSaw.get()));
    private final ResourceLocation id;
    private final int materialAmount;
    private final List<FramingSawRecipeAdditive> additives;
    private final ItemStack result;
    private final IBlockType resultType;
    private final boolean disabled;

    FramingSawRecipe(ResourceLocation id, int materialAmount, List<FramingSawRecipeAdditive> additives, ItemStack result, IBlockType resultType, boolean disabled) {
        this.id = id;
        this.materialAmount = materialAmount;
        this.additives = additives;
        this.result = result;
        this.resultType = resultType;
        this.disabled = disabled;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.matchWithResult(container, level).success();
    }

    public FramingSawRecipeMatchResult matchWithResult(Container container, Level level) {
        ItemStack input = container.m_8020_(0);
        if (input.m_41619_()) {
            return FramingSawRecipeMatchResult.MATERIAL_VALUE;
        }
        int inputValue = FramingSawRecipeCalculation.getInputValue(input, level.m_5776_());
        int totalInputValue = inputValue * input.m_41613_();
        if (totalInputValue < this.materialAmount) {
            return FramingSawRecipeMatchResult.MATERIAL_VALUE;
        }
        long matLcm = FramingSawRecipeCalculation.getMaterialLCM(this, inputValue);
        if (matLcm > (long)totalInputValue) {
            return FramingSawRecipeMatchResult.MATERIAL_LCM;
        }
        for (int idx = 0; idx < 3; ++idx) {
            ItemStack stack = container.m_8020_(idx + 1);
            FramingSawRecipeAdditive additive = idx < this.additives.size() ? this.additives.get(idx) : null;
            boolean empty = stack.m_41619_();
            if (empty && additive == null) continue;
            if (!empty && additive == null) {
                return FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE[idx];
            }
            if (empty) {
                return FramingSawRecipeMatchResult.MISSING_ADDITIVE[idx];
            }
            if (!additive.ingredient().test(stack)) {
                return FramingSawRecipeMatchResult.INCORRECT_ADDITIVE[idx];
            }
            if (stack.m_41613_() >= FramingSawRecipeCalculation.getAdditiveCount(this, additive, matLcm)) continue;
            return FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE[idx];
        }
        return FramingSawRecipeMatchResult.SUCCESS;
    }

    public FramingSawRecipeCalculation makeCraftingCalculation(Container container, boolean client) {
        return new FramingSawRecipeCalculation(this, container, client);
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public int getMaterialAmount() {
        return this.materialAmount;
    }

    public List<FramingSawRecipeAdditive> getAdditives() {
        return this.additives;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public IBlockType getResultType() {
        return this.resultType;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return (ItemStack)TOAST_ICON.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FBContent.recipeSerializerFramingSawRecipe.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FBContent.recipeTypeFramingSawRecipe.get();
    }
}

