/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.util.MathUtils;

public final class FramingSawRecipeCalculation {
    private final FramingSawRecipe recipe;
    private final int inputValue;
    private final long lcm;

    FramingSawRecipeCalculation(FramingSawRecipe recipe, Container container, boolean client) {
        this.recipe = recipe;
        this.inputValue = FramingSawRecipeCalculation.getInputValue(container.m_8020_(0), client);
        this.lcm = FramingSawRecipeCalculation.getMaterialLCM(recipe, this.inputValue);
    }

    public int getInputCount() {
        return (int)(this.lcm / (long)this.inputValue);
    }

    public int getOutputCount() {
        return (int)(this.lcm / (long)this.recipe.getMaterialAmount()) * this.recipe.getResult().m_41613_();
    }

    public int getAdditiveCount(int idx) {
        return FramingSawRecipeCalculation.getAdditiveCount(this.recipe, this.recipe.getAdditives().get(idx), this.lcm);
    }

    static int getInputValue(ItemStack input, boolean client) {
        FramingSawRecipeCache cache = FramingSawRecipeCache.get(client);
        return cache.getMaterialValue(input.m_41720_());
    }

    static long getMaterialLCM(FramingSawRecipe recipe, int inputValue) {
        return MathUtils.lcm(inputValue, recipe.getMaterialAmount());
    }

    static int getAdditiveCount(FramingSawRecipe recipe, FramingSawRecipeAdditive additive, long lcm) {
        return (int)(lcm / (long)recipe.getMaterialAmount()) * additive.count();
    }
}

