/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.GuidebookBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.SectionBuilder;

public final class ChapterBuilder {
    private final List<SectionBuilder> sections = new ArrayList<SectionBuilder>();
    private GuidebookBuilder book = null;
    private String id = null;
    private String condition = null;

    ChapterBuilder() {
    }

    public ChapterBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ChapterBuilder section(SectionBuilder section) {
        this.sections.add(section);
        return this;
    }

    public ChapterBuilder condition(String condition) {
        this.condition = condition;
        return this;
    }

    void captureBook(GuidebookBuilder book) {
        this.book = book;
        this.sections.forEach(s -> s.captureBook(book));
    }

    void print(Document doc, Element bookElem) {
        Element chapterElem = doc.createElement("chapter");
        if (this.id != null) {
            chapterElem.setAttribute("id", this.id);
        }
        if (this.condition != null) {
            if (!this.book.hasCondition(this.condition)) {
                throw new IllegalArgumentException("Unknown condition: " + this.condition);
            }
            chapterElem.setAttribute("condition", this.condition);
        }
        this.sections.forEach(section -> section.print(doc, chapterElem));
        bookElem.appendChild(chapterElem);
    }
}

