/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.ContainerElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.GuidebookBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.TitleElementBuilder;

public final class SectionBuilder
extends ContainerElementBuilder<SectionBuilder> {
    private GuidebookBuilder book = null;
    private String id = null;
    private TitleElementBuilder title = null;
    private String condition = null;

    SectionBuilder() {
    }

    public SectionBuilder id(String id) {
        this.id = id;
        return this;
    }

    public SectionBuilder pageTitle(TitleElementBuilder title) {
        this.title = title;
        return this;
    }

    public SectionBuilder condition(String condition) {
        this.condition = condition;
        return this;
    }

    void captureBook(GuidebookBuilder book) {
        this.book = book;
    }

    @Override
    public void print(Document doc, Element chapterElem) {
        Element sectionElem = doc.createElement("section");
        if (this.id != null) {
            sectionElem.setAttribute("id", this.id);
        }
        if (this.title != null) {
            Element pageTitleElem = doc.createElement("page_title");
            this.title.print(doc, pageTitleElem);
            sectionElem.appendChild(pageTitleElem);
        }
        if (this.condition != null) {
            if (!this.book.hasCondition(this.condition)) {
                throw new IllegalArgumentException("Unknown condition: " + this.condition);
            }
            chapterElem.setAttribute("condition", this.condition);
        }
        super.print(doc, sectionElem);
        chapterElem.appendChild(sectionElem);
    }
}

