/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.ElementBuilder;

public final class ImageElementBuilder
implements ElementBuilder {
    private final String source;
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;
    private int tx = 0;
    private int ty = 0;
    private int tw = 0;
    private int th = 0;

    public ImageElementBuilder(String source) {
        this.source = source;
    }

    public ImageElementBuilder pos(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ImageElementBuilder size(int w, int h) {
        this.w = w;
        this.h = h;
        return this;
    }

    public ImageElementBuilder uv(int tx, int ty) {
        this.tx = tx;
        this.ty = ty;
        return this;
    }

    public ImageElementBuilder imgSize(int tw, int th) {
        this.tw = tw;
        this.th = th;
        return this;
    }

    @Override
    public void print(Document doc, Element parentElem) {
        Element imageElem = doc.createElement("image");
        imageElem.setAttribute("src", this.source);
        ImageElementBuilder.writeIntAttribute(imageElem, "x", this.x);
        ImageElementBuilder.writeIntAttribute(imageElem, "y", this.y);
        ImageElementBuilder.writeIntAttribute(imageElem, "w", this.w);
        ImageElementBuilder.writeIntAttribute(imageElem, "h", this.h);
        ImageElementBuilder.writeIntAttribute(imageElem, "tx", this.tx);
        ImageElementBuilder.writeIntAttribute(imageElem, "ty", this.ty);
        ImageElementBuilder.writeIntAttribute(imageElem, "tw", this.tw);
        ImageElementBuilder.writeIntAttribute(imageElem, "th", this.th);
        parentElem.appendChild(imageElem);
    }

    private static void writeIntAttribute(Element elem, String name, int value) {
        if (value != 0) {
            elem.setAttribute(name, Integer.toString(value));
        }
    }
}

