/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky77.register;

import mod.lucky77.Configuration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lucky77", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegisterSpawn {
    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register(EntityType.f_20562_, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkDrownedSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20458_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkHuskSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20481_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkStraySpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20554_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20558_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20566_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20454_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20524_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20479_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20495_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20496_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20497_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20501_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20530_, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20568_, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20459_, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20518_, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20491_, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(EntityType.f_20493_, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RegisterSpawn::checkMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Monster> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && RegisterSpawn.isDarkEnoughToSpawn(level, pos, random, entity) && RegisterSpawn.isValidSpawnPoint(entity, (LevelAccessor)level, spawnType, pos, random);
    }

    public static boolean checkDrownedSpawnRules(EntityType<Drowned> entity, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean flag;
        if (!levelAccessor.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        Holder holder = levelAccessor.m_204166_(pos);
        boolean bl = flag = levelAccessor.m_46791_() != Difficulty.PEACEFUL && RegisterSpawn.isDarkEnoughToSpawn(levelAccessor, pos, random, entity) && (spawnType == MobSpawnType.SPAWNER || levelAccessor.m_6425_(pos).m_205070_(FluidTags.f_13131_));
        if (holder.m_203656_(BiomeTags.f_215814_)) {
            return random.m_188503_(15) == 0 && flag;
        }
        return random.m_188503_(40) == 0 && RegisterSpawn.isDeepEnoughToSpawn((LevelAccessor)levelAccessor, pos) && flag;
    }

    public static boolean checkHuskSpawnRules(EntityType<Husk> entity, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return RegisterSpawn.checkMonsterSpawnRules(entity, levelAccessor, spawnType, pos, random) && (spawnType == MobSpawnType.SPAWNER || levelAccessor.m_45527_(pos));
    }

    public static boolean checkStraySpawnRules(EntityType<Stray> entity, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos;
        while (levelAccessor.m_8055_(blockpos = blockpos.m_7494_()).m_60713_(Blocks.f_152499_)) {
        }
        return RegisterSpawn.checkMonsterSpawnRules(entity, levelAccessor, spawnType, pos, random) && (spawnType == MobSpawnType.SPAWNER || levelAccessor.m_45527_(blockpos.m_7495_()));
    }

    public static boolean isValidSpawnPoint(EntityType<? extends Mob> entity, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.m_7495_();
        return spawnType == MobSpawnType.SPAWNER || level.m_8055_(blockpos).m_60643_((BlockGetter)level, blockpos, entity);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random, EntityType<? extends Mob> entity) {
        if (entity == EntityType.f_20562_) {
            if (((Boolean)Configuration.SPAWN.drowned.get()).booleanValue()) {
                RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            } else {
                RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
            }
        }
        if (entity == EntityType.f_20458_) {
            if (((Boolean)Configuration.SPAWN.husk.get()).booleanValue()) {
                RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            } else {
                RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
            }
        }
        if (entity == EntityType.f_20481_) {
            if (((Boolean)Configuration.SPAWN.stray.get()).booleanValue()) {
                RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            } else {
                RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
            }
        }
        if (entity == EntityType.f_20554_) {
            if (((Boolean)Configuration.SPAWN.cave_spider.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20558_) {
            if (((Boolean)Configuration.SPAWN.creeper.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20566_) {
            if (((Boolean)Configuration.SPAWN.enderman.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20454_) {
            if (((Boolean)Configuration.SPAWN.giant.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20524_) {
            if (((Boolean)Configuration.SPAWN.skeleton.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20479_) {
            if (((Boolean)Configuration.SPAWN.spider.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20495_) {
            if (((Boolean)Configuration.SPAWN.witch.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20496_) {
            if (((Boolean)Configuration.SPAWN.wither.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20497_) {
            if (((Boolean)Configuration.SPAWN.wither_skeleton.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20501_) {
            if (((Boolean)Configuration.SPAWN.zombie.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20530_) {
            if (((Boolean)Configuration.SPAWN.zombie_villager.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20568_) {
            if (((Boolean)Configuration.SPAWN.evoker.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20459_) {
            if (((Boolean)Configuration.SPAWN.illusioner.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20518_) {
            if (((Boolean)Configuration.SPAWN.ravager.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20491_) {
            if (((Boolean)Configuration.SPAWN.vex.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        if (entity == EntityType.f_20493_) {
            if (((Boolean)Configuration.SPAWN.vindicator.get()).booleanValue()) {
                return RegisterSpawn.isDarkEnoughToSpawnSimple(level, pos, random);
            }
            return RegisterSpawn.isDarkEnoughToSpawnComplex(level, pos, random);
        }
        return false;
    }

    public static boolean isDarkEnoughToSpawnSimple(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        DimensionType dimensiontype = level.m_6042_();
        if (dimensiontype.f_223549_()) {
            int light = level.m_46803_(pos);
            return light <= 2;
        }
        return true;
    }

    public static boolean isDarkEnoughToSpawnComplex(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = levelAccessor.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && levelAccessor.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(pos, 10) : levelAccessor.m_46803_(pos);
        return j <= dimensiontype.m_223569_().m_214085_(random);
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor levelAccessor, BlockPos pos) {
        return pos.m_123342_() < levelAccessor.m_5736_() - 5;
    }
}

