/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky77.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mod.lucky77.item.ItemBook;
import mod.lucky77.util.Vector2;
import mod.lucky77.util.button.ButtonSet;
import mod.lucky77.util.content.ContentPage;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBook
extends Screen {
    private ResourceLocation BOOK = new ResourceLocation("lucky77", "textures/gui/book_gray.png");
    private final List<ContentPage> content = new ArrayList<ContentPage>();
    private final ButtonSet buttonSet = new ButtonSet();
    private int currentPage;

    public ScreenBook(ItemBook item) {
        super((Component)Component.m_237119_());
        this.loadPages(item);
        this.createButtons();
    }

    private void createButtons() {
        this.buttonSet.addButton(0, new Vector2(30, 156), new Vector2(215, 246), new Vector2(215, 246), new Vector2(238, 246), new Vector2(18, 10), -1, () -> this.currentPage > 0, () -> this.commandPageBack());
        this.buttonSet.addButton(1, new Vector2(208, 156), new Vector2(215, 233), new Vector2(215, 233), new Vector2(238, 233), new Vector2(18, 10), -1, () -> this.currentPage + 2 < this.content.size(), () -> this.commandPageForward());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        switch (keyCode) {
            case 263: 
            case 266: {
                this.commandPageBack();
                return true;
            }
            case 262: 
            case 267: {
                this.commandPageForward();
                return true;
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 180) / 2;
        this.buttonSet.interact(x, y, mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_86412_(PoseStack matrix, int mousePosX, int mousePosY, float partialTick) {
        this.m_7333_(matrix);
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 180) / 2;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BOOK);
        ScreenBook.m_93228_((PoseStack)matrix, (int)x, (int)y, (int)0, (int)0, (int)256, (int)180);
        this.buttonSet.update(x, y, mousePosX, mousePosY);
        for (int i = 0; i < 2; ++i) {
            int offset = 118 * i;
            if (this.content.get((int)(this.currentPage + i)).pageHeader.length() > 0) {
                int w = this.f_96547_.m_92895_(this.content.get((int)(this.currentPage + i)).pageHeader) / 2;
                this.f_96547_.m_92883_(matrix, this.content.get((int)(this.currentPage + i)).pageHeader, (float)(x + 68 - w + offset), (float)(y + 16), 100000);
            }
            if (this.content.get((int)(this.currentPage + i)).imageID > -1) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.content.get((int)(this.currentPage + i)).imageSource);
                ScreenBook.m_93228_((PoseStack)matrix, (int)(x + 8 + 22 - 8 + 4 + offset), (int)(y + 26), (int)(this.content.get((int)(this.currentPage + i)).imageID % 3 * 84), (int)(this.content.get((int)(this.currentPage + i)).imageID / 3 * 128), (int)84, (int)128);
            }
            for (int k = 0; k < this.content.get((int)(this.currentPage + i)).pageBody.size(); ++k) {
                this.f_96547_.m_92883_(matrix, this.content.get((int)(this.currentPage + i)).pageBody.get(k), (float)(x + 16 + offset), (float)(y + 32 + 9 * k), 0);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BOOK);
        while (this.buttonSet.next()) {
            if (this.buttonSet.isVisible()) {
                ScreenBook.m_93228_((PoseStack)matrix, (int)(x + this.buttonSet.pos().X), (int)(y + this.buttonSet.pos().Y), (int)this.buttonSet.map().X, (int)this.buttonSet.map().Y, (int)this.buttonSet.sizeX(), (int)this.buttonSet.sizeY());
            }
            if (!this.buttonSet.isHighlighted()) continue;
            ScreenBook.m_93228_((PoseStack)matrix, (int)(x + this.buttonSet.pos().X), (int)(y + this.buttonSet.pos().Y), (int)this.buttonSet.highlight().X, (int)this.buttonSet.highlight().Y, (int)this.buttonSet.sizeX(), (int)this.buttonSet.sizeY());
        }
        super.m_86412_(matrix, mousePosX, mousePosY, partialTick);
    }

    private void commandPageBack() {
        this.currentPage -= 2;
    }

    private void commandPageForward() {
        this.currentPage += 2;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
    }

    protected boolean mouseRect(int x, int y, int width, int height, double mouseX, double mouseY) {
        if ((double)x < mouseX && mouseX < (double)(x + width)) {
            return (double)y < mouseY && mouseY < (double)(y + height);
        }
        return false;
    }

    private void loadPages(ItemBook item) {
        for (int i = 0; i < item.getMaxPages(); ++i) {
            String header = I18n.m_118938_((String)item.getPage((int)i).pageHeader, (Object[])new Object[0]);
            List<String> text = this.createTextField(I18n.m_118938_((String)item.getPage((int)i).pageBody.get(0), (Object[])new Object[0]));
            ResourceLocation imageSource = item.getPage((int)i).imageSource;
            int imageID = item.getPage((int)i).imageID;
            if (text.size() > 13) {
                this.content.add(new ContentPage(header, text.subList(0, 13), imageSource, imageID));
                for (int line = 13; line < text.size(); line += 13) {
                    this.content.add(new ContentPage("", text.subList(line, line + 13 > text.size() ? text.size() : line + 13), imageSource, -1));
                }
                continue;
            }
            this.content.add(new ContentPage(header, text, imageSource, imageID));
        }
        if (this.content.size() % 2 == 1) {
            this.content.add(new ContentPage("", "", "", -1, ""));
        }
        switch (item.getColorID()) {
            case 0: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_gray.png");
                break;
            }
            case 1: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_red.png");
                break;
            }
            case 2: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_blue.png");
                break;
            }
            case 3: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_yellow.png");
                break;
            }
            case 4: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_green.png");
                break;
            }
            case 5: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_orange.png");
                break;
            }
            case 6: {
                this.BOOK = new ResourceLocation("lucky77", "textures/gui/book_violet.png");
            }
        }
    }

    private List<String> createTextField(String text) {
        int length = 20;
        ArrayList<String> list = new ArrayList<String>();
        char[] charlist = text.toCharArray();
        if (charlist.length <= length) {
            list.add(text);
        } else {
            int point_last = 0;
            while (point_last + 1 < text.length()) {
                int point_next = 0;
                for (int x = 0; x < length; ++x) {
                    if (point_last + x >= charlist.length) continue;
                    if (x + point_last + 1 == charlist.length) {
                        point_next = x + 1;
                    }
                    if (charlist[x + point_last] == ' ') {
                        point_next = x + 1;
                    }
                    if (charlist[x + point_last] != '/' || charlist[x + 1 + point_last] != 'b') continue;
                    charlist[x + point_last] = 32;
                    charlist[x + 1 + point_last] = 32;
                    point_next = x + 2;
                    break;
                }
                list.add(new String(charlist, point_last, point_next));
                point_last += point_next;
            }
        }
        return list;
    }
}

