/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.common.block;

import enemeez.simplefarming.common.block.GourdAttachedStemBlock;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class GourdStemBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)};
    private final Supplier<Item> SEED;
    private final Supplier<Block> FRUIT;
    private final Supplier<Block> ATTACHED_STEM;
    private final Set<Block> GRASS_LIKE = Set.of(Blocks.f_50093_, Blocks.f_50493_, Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50440_);

    public GourdStemBlock(BlockBehaviour.Properties pProperties, Supplier<Item> pSeedSupplier, Supplier<Block> fruit, Supplier<Block> attachedStem) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.SEED = pSeedSupplier;
        this.FRUIT = fruit;
        this.ATTACHED_STEM = attachedStem;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)AGE)];
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_(Blocks.f_50093_);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = this.getGrowthSpeed((Block)this, (BlockGetter)pLevel, pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            int CURR_AGE = (Integer)pState.m_61143_((Property)AGE);
            if (CURR_AGE < 7) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(CURR_AGE + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(pRandom);
                BlockPos blockpos = pPos.m_121945_(direction);
                BlockState blockstate = pLevel.m_8055_(blockpos.m_7495_());
                Block block = blockstate.m_60734_();
                if (pLevel.m_46859_(blockpos) && (blockstate.canSustainPlant((BlockGetter)pLevel, blockpos.m_7495_(), Direction.UP, (IPlantable)this) || this.GRASS_LIKE.contains(block))) {
                    pLevel.m_46597_(blockpos, this.getFruit().m_49966_());
                    pLevel.m_46597_(pPos, (BlockState)this.getAttachedStem().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
                }
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this.SEED.get());
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)AGE) != 7;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int i = Math.min(7, (Integer)pState.m_61143_((Property)AGE) + Mth.m_216271_((RandomSource)pLevel.f_46441_, (int)2, (int)5));
        BlockState blockstate = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i));
        pLevel.m_7731_(pPos, blockstate, 2);
        if (i == 7) {
            blockstate.m_222972_(pLevel, pPos, pLevel.f_46441_);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }

    private float getGrowthSpeed(Block pBlock, BlockGetter pLevel, BlockPos pPos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pPos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = pLevel.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(pLevel, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)pBlock)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(pLevel, pPos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pPos.m_122012_();
        BlockPos blockpos2 = pPos.m_122019_();
        BlockPos blockpos3 = pPos.m_122024_();
        BlockPos blockpos4 = pPos.m_122029_();
        boolean flag = pLevel.m_8055_(blockpos3).m_60713_(pBlock) || pLevel.m_8055_(blockpos4).m_60713_(pBlock);
        boolean bl = flag1 = pLevel.m_8055_(blockpos1).m_60713_(pBlock) || pLevel.m_8055_(blockpos2).m_60713_(pBlock);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = pLevel.m_8055_(blockpos3.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122019_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos3.m_122019_()).m_60713_(pBlock);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private Block getFruit() {
        return this.FRUIT.get();
    }

    private GourdAttachedStemBlock getAttachedStem() {
        return (GourdAttachedStemBlock)this.ATTACHED_STEM.get();
    }
}

