/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2ic;

@Environment(value=EnvType.CLIENT)
public class AdvancedTooltip
extends Tooltip {
    @Nullable
    protected Supplier<Component> supplier;
    protected int maxWidth = 170;
    protected boolean renderWithoutGap = false;

    public AdvancedTooltip(Component message, @Nullable Component narration) {
        super(message, narration);
    }

    public AdvancedTooltip(Component message) {
        this(message, message);
    }

    public AdvancedTooltip(Supplier<Component> message) {
        this(message.get());
        this.supplier = message;
    }

    public AdvancedTooltip setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public AdvancedTooltip setRenderWithoutGap(boolean render) {
        this.renderWithoutGap = render;
        return this;
    }

    public Component getMessage() {
        return this.supplier != null ? this.supplier.get() : this.f_256850_;
    }

    public List<FormattedCharSequence> m_257408_(Minecraft minecraft) {
        if (this.supplier == null) {
            if (this.f_256766_ == null) {
                this.f_256766_ = AdvancedTooltip.splitTooltip(minecraft, this.getMessage(), this.maxWidth);
            }
            return this.f_256766_;
        }
        return AdvancedTooltip.splitTooltip(minecraft, this.getMessage(), this.maxWidth);
    }

    public boolean hasCustomRender() {
        return this.renderWithoutGap;
    }

    public void doCustomRender(Screen screen, PoseStack poseStack, int x, int y, ClientTooltipPositioner positioner) {
        if (!this.renderWithoutGap) {
            throw new UnsupportedOperationException("This tooltip doesn't support custom render!");
        }
        this.renderTooltipNoGap(screen, poseStack, AdvancedTooltip.splitTooltip(screen.f_96541_, this.getMessage(), this.maxWidth), x, y, positioner);
    }

    public static List<FormattedCharSequence> splitTooltip(Minecraft minecraft, Component component, int maxWidth) {
        return minecraft.f_91062_.m_92923_((FormattedText)component, maxWidth);
    }

    protected void renderTooltipNoGap(Screen screen, PoseStack poseStack, List<? extends FormattedCharSequence> list, int x, int y, ClientTooltipPositioner positioner) {
        this.renderTooltipInternalNoGap(screen, poseStack, list.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), x, y, positioner);
    }

    protected void renderTooltipInternalNoGap(Screen screen, PoseStack poseStack, List<ClientTooltipComponent> list, int i2, int j2, ClientTooltipPositioner clientTooltipPositioner) {
        ClientTooltipComponent clientTooltipComponent2;
        int t;
        if (list.isEmpty()) {
            return;
        }
        int k2 = 0;
        int l2 = list.size() == 1 ? -2 : -2;
        for (ClientTooltipComponent clientTooltipComponent : list) {
            int m2 = clientTooltipComponent.m_142069_(screen.f_96547_);
            if (m2 > k2) {
                k2 = m2;
            }
            l2 += clientTooltipComponent.m_142103_();
        }
        int n2 = k2;
        int o2 = l2;
        Vector2ic vector2ic = clientTooltipPositioner.m_262814_(screen, i2, j2, n2, o2);
        int p = vector2ic.x();
        int q = vector2ic.y();
        poseStack.m_85836_();
        int r = 400;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder2 = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder2.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f2 = poseStack.m_85850_().m_252922_();
        TooltipRenderUtil.m_262796_((matrix4f, bufferBuilder, i, j, k, l, m, n, o) -> AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, i, j, k, l, m, n, o), (Matrix4f)matrix4f2, (BufferBuilder)bufferBuilder2, (int)p, (int)q, (int)n2, (int)o2, (int)400);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder2.m_231175_());
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        int s = q;
        for (t = 0; t < list.size(); ++t) {
            clientTooltipComponent2 = list.get(t);
            clientTooltipComponent2.m_142440_(screen.f_96547_, p, s, matrix4f2, bufferSource);
            s += clientTooltipComponent2.m_142103_() + 0;
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        s = q;
        for (t = 0; t < list.size(); ++t) {
            clientTooltipComponent2 = list.get(t);
            clientTooltipComponent2.m_183452_(screen.f_96547_, p, s, poseStack, screen.f_96542_);
            s += clientTooltipComponent2.m_142103_() + 0;
        }
    }

    protected static void fillGradient(Matrix4f matrix4f, BufferBuilder bufferBuilder, int i, int j, int k, int l, int m, int n, int o) {
        float f = (float)(n >> 24 & 0xFF) / 255.0f;
        float g = (float)(n >> 16 & 0xFF) / 255.0f;
        float h = (float)(n >> 8 & 0xFF) / 255.0f;
        float p = (float)(n & 0xFF) / 255.0f;
        float q = (float)(o >> 24 & 0xFF) / 255.0f;
        float r = (float)(o >> 16 & 0xFF) / 255.0f;
        float s = (float)(o >> 8 & 0xFF) / 255.0f;
        float t = (float)(o & 0xFF) / 255.0f;
        bufferBuilder.m_252986_(matrix4f, (float)k, (float)j, (float)m).m_85950_(g, h, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)i, (float)j, (float)m).m_85950_(g, h, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)i, (float)l, (float)m).m_85950_(r, s, t, q).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)k, (float)l, (float)m).m_85950_(r, s, t, q).m_5752_();
    }
}

