/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.paperdoll;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.paperdoll.PaperDollSettings;
import dev.tr7zw.paperdoll.PaperDollShared;
import dev.tr7zw.paperdoll.PlayerAccess;
import dev.tr7zw.paperdoll.util.NMSHelper;
import java.util.stream.Stream;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PaperDollRenderer {
    private final Minecraft mc_instance = Minecraft.m_91087_();
    private final PaperDollShared instance = PaperDollShared.instance;
    private long showTill = 0L;

    public void render(float delta) {
        Entity playerEntity;
        if (!this.instance.settings.dollEnabled || this.mc_instance.f_91066_.f_92063_ || this.mc_instance.f_91073_ == null) {
            return;
        }
        int xpos = 0;
        int ypos = 0;
        switch (this.instance.settings.location) {
            case TOP_LEFT: {
                xpos = 25 + this.instance.settings.dollXOffset;
                ypos = 55 + this.instance.settings.dollYOffset;
                break;
            }
            case TOP_RIGHT: {
                xpos = this.mc_instance.m_91268_().m_85445_() - (25 + this.instance.settings.dollXOffset);
                ypos = 55 + this.instance.settings.dollYOffset;
                break;
            }
            case BOTTOM_LEFT: {
                xpos = 25 + this.instance.settings.dollXOffset;
                ypos = this.mc_instance.m_91268_().m_85446_() - (55 + this.instance.settings.dollYOffset);
                break;
            }
            case BOTTOM_RIGHT: {
                xpos = this.mc_instance.m_91268_().m_85445_() - (25 + this.instance.settings.dollXOffset);
                ypos = this.mc_instance.m_91268_().m_85446_() - (55 + this.instance.settings.dollYOffset);
            }
        }
        int fXpos = xpos;
        int fYpos = ypos;
        int size = 25 + this.instance.settings.dollSize;
        int lookSides = -this.instance.settings.dollLookingSides;
        int lookUpDown = this.instance.settings.dollLookingUpDown;
        Object object = playerEntity = this.mc_instance.m_91288_() != null ? this.mc_instance.m_91288_() : this.mc_instance.f_91074_;
        if (this.instance.settings.autoHide && playerEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)playerEntity;
            boolean hide = true;
            if (livingEntity.m_6047_() || livingEntity.m_20142_() || livingEntity.m_21255_() || livingEntity.m_20159_() || livingEntity.m_6067_()) {
                hide = false;
            }
            if (livingEntity.m_21254_() || livingEntity.m_6117_() || livingEntity.f_20911_ || livingEntity.m_6060_() || livingEntity.f_20916_ > 0) {
                hide = false;
            }
            if (livingEntity.f_146808_) {
                hide = false;
            }
            if (hide && System.currentTimeMillis() > this.showTill) {
                return;
            }
            if (!hide) {
                this.showTill = System.currentTimeMillis() + 500L;
            }
        }
        if (this.instance.settings.hideInF5 && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        if (playerEntity.m_20159_()) {
            Entity vehicle = playerEntity.m_20201_();
            this.getPassengersAndSelf(vehicle).forEachOrdered(entity -> {
                double yOffset = fYpos;
                if (entity != playerEntity) {
                    yOffset += (playerEntity.m_20186_() - entity.m_20186_()) * (double)size;
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    this.drawLivingEntity(fXpos, yOffset, size, lookSides, lookUpDown, living, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
                } else {
                    this.drawEntity(fXpos, yOffset, size, lookSides, lookUpDown, (Entity)entity, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
                }
            });
        } else if (playerEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)playerEntity;
            this.drawLivingEntity(fXpos, fYpos, size, lookSides, lookUpDown, living, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
        } else {
            this.drawEntity(fXpos, fYpos, size, lookSides, lookUpDown, playerEntity, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
        }
    }

    public Stream<Entity> getPassengersAndSelf(Entity vehicle) {
        return Stream.concat(vehicle.m_20197_().stream(), Stream.of(vehicle));
    }

    private void drawLivingEntity(double xpos, double ypos, int size, float lookSides, float lookUpDown, LivingEntity livingEntity, float delta, boolean lockHead) {
        Entity entity;
        Entity entity2;
        float rotationSide = (float)Math.atan(lookSides / 40.0f);
        float rotationUp = (float)Math.atan(lookUpDown / 40.0f);
        PoseStack poseStack = this.getPoseStack();
        poseStack.m_85836_();
        if (livingEntity.m_21255_() || livingEntity.m_21209_()) {
            float f2 = (float)livingEntity.m_21256_() + delta;
            float f3 = Mth.m_14036_((float)(f2 * f2 / 100.0f), (float)0.0f, (float)1.0f);
            ypos -= (double)((90.0f + f3) / 90.0f * (float)size - 5.0f);
        }
        poseStack.m_85837_(xpos, ypos, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        this.prepareViewMatrix(xpos, ypos);
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(0.0, 0.0, 1000.0);
        matrixStack.m_85841_((float)size, (float)size, (float)size);
        Quaternionf quaternion = NMSHelper.ZP.m_252977_(180.0f);
        Quaternionf quaternion2 = NMSHelper.XP.m_252977_(rotationUp * 20.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.m_252781_(quaternion);
        float yBodyRot = livingEntity.f_20883_;
        float yRot = NMSHelper.getYRot((Entity)livingEntity);
        float yRotO = livingEntity.f_19859_;
        float yBodyRotO = livingEntity.f_20884_;
        float xRot = NMSHelper.getXRot((Entity)livingEntity);
        float xRotO = livingEntity.f_19860_;
        float yHeadRotO = livingEntity.f_20886_;
        float yHeadRot = livingEntity.f_20885_;
        Vec3 deltaMovement = livingEntity.m_20184_();
        float vehicleYBodyRot = 0.0f;
        float vehicleYBodyRotO = 0.0f;
        livingEntity.f_20883_ = 180.0f + rotationSide * 20.0f;
        NMSHelper.setYRot((Entity)livingEntity, 180.0f + rotationSide * 40.0f);
        livingEntity.f_20884_ = livingEntity.f_20883_;
        livingEntity.f_19859_ = NMSHelper.getYRot((Entity)livingEntity);
        Vec3 lastDeltaMovement = null;
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess player = (PlayerAccess)livingEntity;
            lastDeltaMovement = player.getLastDelataMovement();
            player.setLastDeletaMovement(Vec3.f_82478_);
        }
        if (livingEntity.m_20159_() && (entity2 = livingEntity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity2;
            vehicleYBodyRot = livingVehicle.f_20883_;
            vehicleYBodyRotO = livingVehicle.f_20884_;
            livingVehicle.f_20883_ = livingEntity.f_20883_;
            livingVehicle.f_20884_ = livingEntity.f_20884_;
        }
        if (livingEntity.m_21255_() || livingEntity.m_21209_()) {
            livingEntity.m_20256_(Vec3.f_82478_);
        }
        if (lockHead || livingEntity.m_21255_() || livingEntity.m_21209_()) {
            NMSHelper.setXRot((Entity)livingEntity, -rotationUp * 20.0f);
            livingEntity.f_19860_ = NMSHelper.getXRot((Entity)livingEntity);
            livingEntity.f_20885_ = NMSHelper.getYRot((Entity)livingEntity);
            livingEntity.f_20886_ = NMSHelper.getYRot((Entity)livingEntity);
        } else if (this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.FREE) {
            livingEntity.f_20885_ = 180.0f + rotationSide * 40.0f - (yBodyRot - yHeadRot);
            livingEntity.f_20886_ = 180.0f + rotationSide * 40.0f - (yBodyRotO - yHeadRotO);
        } else {
            livingEntity.f_20885_ = 180.0f + rotationSide * 40.0f - (yRot - yHeadRot);
            livingEntity.f_20886_ = 180.0f + rotationSide * 40.0f - (yRotO - yHeadRotO);
        }
        this.prepareLighting();
        EntityRenderDispatcher entityRenderDispatcher = this.mc_instance.m_91290_();
        this.conjugate(quaternion2);
        entityRenderDispatcher.m_252923_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        if (livingEntity.m_20159_()) {
            Entity vehicle = livingEntity.m_20202_();
            double offsetXTmp = livingEntity.m_20185_() - vehicle.m_20185_();
            double offsetZTmp = livingEntity.m_20189_() - vehicle.m_20189_();
            float rotation = NMSHelper.getYRot(vehicle) - 180.0f - rotationSide * 20.0f;
            rotation *= (float)Math.PI / 180;
            offsetX += Math.cos(rotation *= -1.0f) * offsetXTmp - Math.sin(rotation) * offsetZTmp;
            offsetZ += Math.sin(rotation) * offsetXTmp + Math.cos(rotation) * offsetZTmp;
        }
        entityRenderDispatcher.m_114384_((Entity)livingEntity, offsetX, offsetY, offsetZ, 0.0f, delta, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess player = (PlayerAccess)livingEntity;
            player.setLastDeletaMovement(lastDeltaMovement);
        }
        livingEntity.f_20883_ = yBodyRot;
        livingEntity.f_20884_ = yBodyRotO;
        NMSHelper.setYRot((Entity)livingEntity, yRot);
        livingEntity.f_19859_ = yRotO;
        NMSHelper.setXRot((Entity)livingEntity, xRot);
        livingEntity.f_19860_ = xRotO;
        livingEntity.f_20886_ = yHeadRotO;
        livingEntity.f_20885_ = yHeadRot;
        livingEntity.m_20256_(deltaMovement);
        if (livingEntity.m_20159_() && (entity = livingEntity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity;
            livingVehicle.f_20883_ = vehicleYBodyRot;
            livingVehicle.f_20884_ = vehicleYBodyRotO;
        }
        poseStack.m_85849_();
        this.resetViewMatrix();
        Lighting.m_84931_();
    }

    private void prepareViewMatrix(double xpos, double ypos) {
        RenderSystem.m_157182_();
    }

    private void resetViewMatrix() {
        RenderSystem.m_157182_();
    }

    private void prepareLighting() {
        Lighting.m_166384_();
    }

    private void conjugate(Quaternionf quaternion2) {
        quaternion2.conjugate();
    }

    private PoseStack getPoseStack() {
        PoseStack poseStack = RenderSystem.m_157191_();
        return poseStack;
    }

    private void drawEntity(double xpos, double ypos, int size, float lookSides, float lookUpDown, Entity entity, float delta, boolean lockHead) {
        float rotationSide = (float)Math.atan(lookSides / 40.0f);
        float rotationUp = (float)Math.atan(lookUpDown / 40.0f);
        PoseStack poseStack = this.getPoseStack();
        poseStack.m_85836_();
        if (this.mc_instance.f_91074_.m_21255_() || this.mc_instance.f_91074_.m_21209_()) {
            ypos -= (double)((90.0f + entity.f_19860_) / 90.0f * (float)size - 5.0f);
        }
        poseStack.m_85837_(xpos, ypos, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        this.prepareViewMatrix(xpos, ypos);
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(0.0, 0.0, 1000.0);
        matrixStack.m_85841_((float)size, (float)size, (float)size);
        Quaternionf quaternion = NMSHelper.ZP.m_252977_(180.0f);
        Quaternionf quaternion2 = NMSHelper.XP.m_252977_(rotationUp * 20.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.m_252781_(quaternion);
        float yRot = NMSHelper.getYRot(entity);
        float yRotO = entity.f_19859_;
        float xRot = NMSHelper.getXRot(entity);
        float xRotO = entity.f_19860_;
        Vec3 vel = entity.m_20184_();
        Vec3 pos = entity.m_20182_();
        double yOld = entity.f_19791_;
        NMSHelper.setYRot(entity, 0.0f);
        entity.f_19859_ = NMSHelper.getYRot(entity);
        entity.m_20256_(Vec3.f_82478_);
        entity.m_146884_(pos.m_82520_(0.0, 500.0, 0.0));
        entity.f_19791_ += 500.0;
        if (lockHead) {
            NMSHelper.setXRot(entity, -rotationUp * 20.0f);
            entity.f_19860_ = NMSHelper.getXRot(entity);
        }
        this.prepareLighting();
        EntityRenderDispatcher entityRenderDispatcher = this.mc_instance.m_91290_();
        this.conjugate(quaternion2);
        entityRenderDispatcher.m_252923_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        float extraRotation = 0.0f;
        if (entity instanceof Minecart) {
            extraRotation += 90.0f;
        }
        entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 180.0f + rotationSide * 20.0f + extraRotation, delta, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        NMSHelper.setYRot(entity, yRot);
        entity.f_19859_ = yRotO;
        NMSHelper.setXRot(entity, xRot);
        entity.f_19860_ = xRotO;
        entity.m_20256_(vel);
        entity.m_146884_(pos);
        entity.f_19791_ = yOld;
        poseStack.m_85849_();
        this.resetViewMatrix();
        Lighting.m_84931_();
    }
}

