/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.blockentity;

import com.google.common.collect.Lists;
import einstein.jmc.blocks.CakeOvenBlock;
import einstein.jmc.init.ModBlockEntityTypes;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import einstein.jmc.menu.MenuDataProvider;
import einstein.jmc.menu.cakeoven.CakeOvenMenu;
import einstein.jmc.platform.Services;
import einstein.jmc.util.CakeOvenConstants;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CakeOvenBlockEntity
extends BaseContainerBlockEntity
implements MenuDataProvider,
WorldlyContainer,
RecipeHolder,
StackedContentsCompatible,
CakeOvenConstants {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> remainingItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CakeOvenBlockEntity.this.litTime;
                case 1 -> CakeOvenBlockEntity.this.litDuration;
                case 2 -> CakeOvenBlockEntity.this.cookingProgress;
                case 3 -> CakeOvenBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CakeOvenBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    CakeOvenBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    CakeOvenBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    CakeOvenBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public CakeOvenBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CAKE_OVEN.get(), pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.jmc.cake_oven");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new CakeOvenMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CakeOvenBlockEntity blockEntity) {
        boolean flag = blockEntity.isLit();
        boolean flag2 = false;
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        ItemStack fuelStack = (ItemStack)blockEntity.items.get(4);
        if (!(!blockEntity.isLit() && (fuelStack.m_41619_() || ((ItemStack)blockEntity.items.get(0)).m_41619_() && ((ItemStack)blockEntity.items.get(1)).m_41619_() && ((ItemStack)blockEntity.items.get(2)).m_41619_() && ((ItemStack)blockEntity.items.get(3)).m_41619_()))) {
            Recipe recipe = level.m_7465_().m_44015_(ModRecipes.CAKE_OVEN_RECIPE.get(), (Container)blockEntity, level).orElse(null);
            int stackSize = blockEntity.m_6893_();
            RegistryAccess access = level.m_9598_();
            if (!blockEntity.isLit() && blockEntity.hasResultSpace(access, recipe, blockEntity.items, stackSize)) {
                blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(fuelStack);
                if (blockEntity.isLit()) {
                    flag2 = true;
                    ItemStack remainingStack = new ItemStack((ItemLike)fuelStack.m_41720_().m_41469_());
                    if (fuelStack.m_41720_().m_41470_()) {
                        blockEntity.items.set(4, (Object)remainingStack);
                    } else if (!fuelStack.m_41619_()) {
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            blockEntity.items.set(4, (Object)remainingStack);
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.hasResultSpace(access, recipe, blockEntity.items, stackSize)) {
                ++blockEntity.cookingProgress;
                if (blockEntity.cookingProgress == blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = CakeOvenBlockEntity.getTotalCookTime(level, (Container)blockEntity);
                    if (blockEntity.smeltRecipe(access, recipe, blockEntity.items, stackSize)) {
                        blockEntity.m_6029_(recipe);
                    }
                }
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.m_14045_((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (flag != blockEntity.isLit()) {
            flag2 = true;
            state = (BlockState)state.m_61124_((Property)CakeOvenBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (flag2) {
            CakeOvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean hasResultSpace(RegistryAccess access, @Nullable Recipe<?> recipe, NonNullList<ItemStack> slotItems, int maxStackSize) {
        if (recipe != null) {
            ItemStack stack = ((CakeOvenRecipe)recipe).m_5874_((Container)this, access);
            if (stack.m_41619_()) {
                return false;
            }
            ItemStack resultStack = (ItemStack)slotItems.get(5);
            if (resultStack.m_41619_()) {
                return true;
            }
            if (!resultStack.m_41656_(stack)) {
                return false;
            }
            if (resultStack.m_41613_() + stack.m_41613_() <= maxStackSize && resultStack.m_41613_() + stack.m_41613_() <= resultStack.m_41741_()) {
                return true;
            }
            return resultStack.m_41613_() + stack.m_41613_() <= stack.m_41741_();
        }
        return false;
    }

    private boolean smeltRecipe(RegistryAccess access, @Nullable Recipe<?> recipe, NonNullList<ItemStack> slotItems, int maxStackSize) {
        if (recipe != null && this.hasResultSpace(access, recipe, slotItems, maxStackSize)) {
            ItemStack resultStack = (ItemStack)slotItems.get(5);
            ItemStack stack = ((CakeOvenRecipe)recipe).m_5874_((Container)this, access);
            if (resultStack.m_41619_()) {
                slotItems.set(5, (Object)stack.m_41777_());
            } else if (resultStack.m_150930_(stack.m_41720_())) {
                resultStack.m_41769_(stack.m_41613_());
            }
            ((CakeOvenRecipe)recipe).consumeIngredients((Container)this, this.remainingItems);
            return true;
        }
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slotIndex) {
        return (ItemStack)this.items.get(slotIndex);
    }

    public ItemStack m_7407_(int slotIndex, int count) {
        return ContainerHelper.m_18969_(this.items, (int)slotIndex, (int)count);
    }

    public ItemStack m_8016_(int slotIndex) {
        return ContainerHelper.m_18966_(this.items, (int)slotIndex);
    }

    public void m_6836_(int slotIndex, ItemStack stack) {
        ItemStack stack1 = (ItemStack)this.items.get(slotIndex);
        boolean flag = !stack.m_41619_() && stack.m_41656_(stack1) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)stack1);
        this.items.set(slotIndex, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slotIndex != 0 && slotIndex != 1 && slotIndex != 2 && slotIndex != 3 || flag)) {
            this.cookingTotalTime = CakeOvenBlockEntity.getTotalCookTime(this.f_58857_, (Container)this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    private static int getTotalCookTime(Level level, Container container) {
        return level.m_7465_().m_44015_(ModRecipes.CAKE_OVEN_RECIPE.get(), container, level).map(CakeOvenRecipe::getCookingTime).orElse(200);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int slotIndex, ItemStack stack) {
        if (slotIndex == 5) {
            return false;
        }
        if (slotIndex != 4) {
            return true;
        }
        return Services.HOOKS.getBurnTime(stack) > 0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.remainingItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag.m_128469_("RemainingItems"), this.remainingItems);
        this.litTime = tag.m_128451_("BurnTime");
        this.cookingProgress = tag.m_128451_("CookTime");
        this.cookingTotalTime = tag.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(4));
        CompoundTag usedRecipes = tag.m_128469_("RecipesUsed");
        for (String recipe : usedRecipes.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(recipe), usedRecipes.m_128451_(recipe));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BurnTime", this.litTime);
        tag.m_128405_("CookTime", this.cookingProgress);
        tag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        CompoundTag remainingItemsTag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)remainingItemsTag, this.remainingItems);
        tag.m_128365_("RemainingItems", (Tag)remainingItemsTag);
        CompoundTag usedRecipes = new CompoundTag();
        this.recipesUsed.forEach((id, par1) -> usedRecipes.m_128405_(id.toString(), par1.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)usedRecipes);
    }

    protected int getBurnDuration(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return Services.HOOKS.getBurnTime(stack);
    }

    public void m_6029_(Recipe<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.m_6423_(), 1);
        }
    }

    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player player) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 pos) {
        ArrayList recipes = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                recipes.add(recipe);
                AbstractFurnaceBlockEntity.m_154998_((ServerLevel)level, (Vec3)pos, (int)entry.getIntValue(), (float)((CakeOvenRecipe)recipe).getExperience());
            });
        }
        return recipes;
    }

    public void dropRemainingItems(Level level, BlockPos pos) {
        Containers.m_19010_((Level)level, (BlockPos)pos, this.remainingItems);
        this.remainingItems.clear();
    }

    public int[] m_7071_(Direction faceDirection) {
        if (faceDirection == Direction.DOWN) {
            return HOPPER_PULL_SLOTS;
        }
        if (faceDirection == Direction.UP) {
            return HOPPER_FEED_THROUGH_TOP_SLOTS;
        }
        return HOPPER_FEED_THROUGH_SIDE_SLOTS;
    }

    public boolean m_7155_(int slotIndex, ItemStack stack, Direction direction) {
        return this.m_7013_(slotIndex, stack);
    }

    public boolean m_7157_(int slotIndex, ItemStack stack, Direction direction) {
        return true;
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.m_36491_(stack);
        }
    }

    @Override
    public void writeMenuData(ServerPlayer player, FriendlyByteBuf buf) {
    }

    public NonNullList<ItemStack> getRemainingItems() {
        return this.remainingItems;
    }
}

