/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import einstein.jmc.JustMoreCakes;
import einstein.jmc.compat.jei.JEIPlugin;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import einstein.jmc.util.CakeOvenConstants;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CakeOvenRecipeCategory
implements IRecipeCategory<CakeOvenRecipe>,
CakeOvenConstants {
    private static final ResourceLocation TEXTURE = JustMoreCakes.loc("textures/gui/jei_cake_oven_gui.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated flame;
    private final Component title;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CakeOvenRecipeCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 133, 44);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.CAKE_OVEN.get()));
        this.title = Component.m_237115_((String)"gui.jei.jmc.category.cake_oven");
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(TEXTURE, 133, 0, 14, 14), 300, IDrawableAnimated.StartDirection.TOP, true);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(TEXTURE, 133, 14, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    @Nullable
    public ResourceLocation getRegistryName(CakeOvenRecipe recipe) {
        return this.getRecipeType().getUid();
    }

    public RecipeType<CakeOvenRecipe> getRecipeType() {
        return JEIPlugin.CAKE_OVEN;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CakeOvenRecipe recipe, IFocusGroup focuses) {
        Level level = (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        IRecipeSlotBuilder[] ingredientSlots = new IRecipeSlotBuilder[]{builder.addSlot(RecipeIngredientRole.INPUT, 34, 5), builder.addSlot(RecipeIngredientRole.INPUT, 52, 5), builder.addSlot(RecipeIngredientRole.INPUT, 34, 23), builder.addSlot(RecipeIngredientRole.INPUT, 52, 23)};
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            ingredientSlots[i].addIngredients((Ingredient)recipe.m_7527_().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 14).addItemStack(recipe.m_8043_(level.m_9598_()));
        builder.setShapeless();
    }

    private IDrawableAnimated getArrow(CakeOvenRecipe recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = 200;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public void draw(CakeOvenRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.flame.draw(stack, 1, 4);
        this.getArrow(recipe).draw(stack, 75, 13);
        this.drawExperienceText(recipe, stack, 0);
        this.drawCookTimeText(recipe, stack, 37);
    }

    private void drawExperienceText(CakeOvenRecipe recipe, PoseStack stack, int y) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            MutableComponent experienceText = Component.m_237110_((String)"gui.jei.jmc.category.cake_oven.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            fontRenderer.m_92889_(stack, (Component)experienceText, (float)(this.background.getWidth() - fontRenderer.m_92852_((FormattedText)experienceText) - 13), (float)y, -8355712);
        }
    }

    private void drawCookTimeText(CakeOvenRecipe recipe, PoseStack stack, int y) {
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent cookTimeText = Component.m_237110_((String)"gui.jei.jmc.category.cake_oven.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            fontRenderer.m_92889_(stack, (Component)cookTimeText, (float)(this.background.getWidth() - fontRenderer.m_92852_((FormattedText)cookTimeText)), (float)y, -8355712);
        }
    }
}

