/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item.crafting.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.util.CakeOvenConstants;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CakeOvenRecipeBuilder
implements RecipeBuilder,
CakeOvenConstants {
    private final RecipeCategory category;
    private final Item result;
    private final NonNullList<Ingredient> ingredients;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    private CakeOvenRecipeBuilder(RecipeCategory category, NonNullList<Ingredient> ingredients, ItemLike result, float experience, int cookingTime) {
        this.category = category;
        this.result = result.m_5456_();
        this.ingredients = ingredients;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public static CakeOvenRecipeBuilder cakeBaking(ItemLike result, float experience, int cookingTime, RecipeCategory category, Ingredient ... ingredients) {
        if (ingredients.length > 4) {
            throw new IllegalArgumentException("Too many ingredients for cake oven recipe. The max is 4");
        }
        NonNullList ingredientsList = NonNullList.m_122779_();
        Collections.addAll(ingredientsList, ingredients);
        return new CakeOvenRecipeBuilder(category, (NonNullList<Ingredient>)ingredientsList, result, experience, cookingTime);
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this;
    }

    public RecipeBuilder m_126145_(String group) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(recipeId, this.ingredients, this.result, this.experience, this.cookingTime, this.advancement, recipeId.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation recipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final NonNullList<Ingredient> ingredients;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation recipeId, NonNullList<Ingredient> ingredients, Item result, float experience, int cookingTime, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.recipeId = recipeId;
            this.ingredients = ingredients;
            this.result = result;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonIngredients = new JsonArray(4);
            for (Ingredient ingredient : this.ingredients) {
                jsonIngredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonIngredients);
            json.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingTime", (Number)this.cookingTime);
        }

        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.CAKE_OVEN_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

