/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.DistType;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ObjectShareAccess;
import fuzs.puzzleslib.api.core.v1.ServiceProviderHelper;
import java.nio.file.Path;
import java.util.Optional;

public interface ModLoaderEnvironment {
    public static final ModLoaderEnvironment INSTANCE = ServiceProviderHelper.load(ModLoaderEnvironment.class);

    public ModLoader getModLoader();

    default public boolean isForge() {
        return this.getModLoader().isForge();
    }

    default public boolean isFabric() {
        return this.getModLoader().isFabric();
    }

    default public boolean isQuilt() {
        return this.getModLoader().isQuilt();
    }

    public DistType getEnvironmentType();

    default public boolean isEnvironmentType(DistType envType) {
        return this.getEnvironmentType() == envType;
    }

    default public boolean isClient() {
        return this.isEnvironmentType(DistType.CLIENT);
    }

    default public boolean isServer() {
        return !this.isClient();
    }

    public Path getGameDirectory();

    public Path getModsDirectory();

    public Path getConfigDirectory();

    public Optional<Path> findModResource(String var1, String ... var2);

    public boolean isDevelopmentEnvironment();

    public boolean isModLoaded(String var1);

    default public boolean isModLoadedSafe(String modId) {
        return this.isModLoaded(modId);
    }

    public Optional<String> getModName(String var1);

    public ObjectShareAccess getObjectShareAccess();
}

