/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.data.LanguageProvider;

public abstract class AbstractLanguageProvider
extends LanguageProvider {
    protected final String modId;

    public AbstractLanguageProvider(PackOutput packOutput, String modId) {
        super(packOutput, modId, "en_us");
        this.modId = modId;
    }

    protected abstract void addTranslations();

    public void addCreativeModeTab(String value) {
        this.addCreativeModeTab("main", value);
    }

    public void addCreativeModeTab(String tabId, String value) {
        this.add(CreativeModeTabRegistry.getTab((ResourceLocation)new ResourceLocation(this.modId, tabId)), value);
    }

    public void add(CreativeModeTab tab, String value) {
        Objects.requireNonNull(tab, "tab is null");
        ComponentContents componentContents = tab.m_40786_().m_214077_();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Cannot add language entry for tab %s".formatted(tab.m_40786_().getString()));
        }
        TranslatableContents contents = (TranslatableContents)componentContents;
        this.add(contents.m_237508_(), value);
    }

    public void add(Attribute entityAttribute, String value) {
        this.add(entityAttribute.m_22087_(), value);
    }

    public void add(StatType<?> statType, String value) {
        this.add(statType.m_12904_(), value);
    }

    public void add(Potion potion, String value) {
        String potionName = potion.m_43492_("");
        this.add("item.minecraft.tipped_arrow.effect." + potionName, "Arrow of " + value);
        this.add("item.minecraft.potion.effect." + potionName, "Potion of " + value);
        this.add("item.minecraft.splash_potion.effect." + potionName, "Splash Potion of " + value);
        this.add("item.minecraft.lingering_potion.effect." + potionName, "Lingering Potion of " + value);
    }

    public void add(SoundEvent soundEvent, String value) {
        this.add("subtitles." + soundEvent.m_11660_().m_135815_(), value);
    }

    public void add(KeyMapping keyMapping, String value) {
        this.add(keyMapping.m_90860_(), value);
    }

    public void add(ResourceLocation identifier, String value) {
        this.add(identifier.m_214298_(), value);
    }

    public void addAdditional(Block block, String key, String value) {
        this.add(block.m_7705_() + "." + key, value);
    }

    public void addAdditional(Item item, String key, String value) {
        this.add(item.m_5524_() + "." + key, value);
    }

    public void addAdditional(Enchantment enchantment, String key, String value) {
        this.add(enchantment.m_44704_() + "." + key, value);
    }

    public void addAdditional(MobEffect mobEffect, String key, String value) {
        this.add(mobEffect.m_19481_() + "." + key, value);
    }

    public void addAdditional(EntityType<?> entityType, String key, String value) {
        this.add(entityType.m_20675_() + "." + key, value);
    }

    @Deprecated(forRemoval=true)
    public void addDamageSource(String damageSource, String value) {
        this.add("death.attack." + damageSource, value);
    }

    public void addDamageType(ResourceKey<DamageType> damageType, String value) {
        this.add("death.attack." + damageType.m_135782_().m_135815_(), value);
    }

    public void addPlayerDamageType(ResourceKey<DamageType> damageType, String value) {
        this.add("death.attack." + damageType.m_135782_().m_135815_() + ".player", value);
    }

    public void addItemDamageType(ResourceKey<DamageType> damageType, String value) {
        this.add("death.attack." + damageType.m_135782_().m_135815_() + ".item", value);
    }
}

