/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v2;

import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.init.v2.RegistryReference;
import fuzs.puzzleslib.api.init.v2.builder.ExtendedMenuSupplier;
import fuzs.puzzleslib.api.init.v2.builder.PoiTypeBuilder;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public interface RegistryManager {
    public static RegistryManager instant(String modId) {
        return ModContext.get(modId).getRegistryManager(false);
    }

    public static RegistryManager deferred(String modId) {
        return ModContext.get(modId).getRegistryManager(true);
    }

    public String namespace();

    public RegistryManager whenOn(ModLoader ... var1);

    default public RegistryManager whenNotOn(ModLoader ... forbiddenModLoaders) {
        if (forbiddenModLoaders.length == 0) {
            throw new IllegalArgumentException("Must provide at least one mod loader to not register on");
        }
        ModLoader[] allowedModLoaders = (ModLoader[])Stream.of(ModLoader.values()).filter(modLoader -> !ArrayUtils.contains((Object[])forbiddenModLoaders, (Object)modLoader)).toArray(ModLoader[]::new);
        return this.whenOn(allowedModLoaders);
    }

    default public void applyRegistration() {
    }

    default public <T> RegistryReference<T> placeholder(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        return RegistryReference.placeholder(registryKey, this.makeKey(path));
    }

    public <T> RegistryReference<T> register(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3);

    default public RegistryReference<Block> registerBlock(String path, Supplier<Block> entry) {
        return this.register(Registries.f_256747_, path, entry);
    }

    default public RegistryReference<Item> registerItem(String path, Supplier<Item> entry) {
        return this.register(Registries.f_256913_, path, entry);
    }

    default public RegistryReference<Item> registerBlockItem(RegistryReference<Block> blockReference) {
        return this.registerBlockItem(blockReference, new Item.Properties());
    }

    default public RegistryReference<Item> registerBlockItem(RegistryReference<Block> blockReference, Item.Properties itemProperties) {
        return this.registerItem(blockReference.getResourceLocation().m_135815_(), () -> new BlockItem((Block)blockReference.get(), itemProperties));
    }

    default public RegistryReference<Item> registerSpawnEggItem(RegistryReference<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeReference, backgroundColor, highlightColor, new Item.Properties());
    }

    public RegistryReference<Item> registerSpawnEggItem(RegistryReference<? extends EntityType<? extends Mob>> var1, int var2, int var3, Item.Properties var4);

    default public RegistryReference<Fluid> registerFluid(String path, Supplier<Fluid> entry) {
        return this.register(Registries.f_256808_, path, entry);
    }

    default public RegistryReference<MobEffect> registerMobEffect(String path, Supplier<MobEffect> entry) {
        return this.register(Registries.f_256929_, path, entry);
    }

    default public RegistryReference<SoundEvent> registerSoundEvent(String path) {
        return this.register(Registries.f_256840_, path, () -> SoundEvent.m_262824_((ResourceLocation)this.makeKey(path)));
    }

    default public RegistryReference<Potion> registerPotion(String path, Supplier<Potion> entry) {
        return this.register(Registries.f_256973_, path, entry);
    }

    default public RegistryReference<Enchantment> registerEnchantment(String path, Supplier<Enchantment> entry) {
        return this.register(Registries.f_256762_, path, entry);
    }

    default public <T extends Entity> RegistryReference<EntityType<T>> registerEntityType(String path, Supplier<EntityType.Builder<T>> entry) {
        return this.register(Registries.f_256939_, path, () -> ((EntityType.Builder)entry.get()).m_20712_(path));
    }

    default public <T extends BlockEntity> RegistryReference<BlockEntityType<T>> registerBlockEntityType(String path, Supplier<BlockEntityType.Builder<T>> entry) {
        return this.register(Registries.f_256922_, path, () -> ((BlockEntityType.Builder)entry.get()).m_58966_(null));
    }

    default public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerMenuType(String path, Supplier<MenuType.MenuSupplier<T>> entry) {
        return this.register(Registries.f_256798_, path, () -> new MenuType((MenuType.MenuSupplier)entry.get(), FeatureFlags.f_244377_));
    }

    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerExtendedMenuType(String var1, Supplier<ExtendedMenuSupplier<T>> var2);

    public RegistryReference<PoiType> registerPoiTypeBuilder(String var1, Supplier<PoiTypeBuilder> var2);

    default public <T extends Recipe<?>> RegistryReference<RecipeType<T>> registerRecipeType(final String path) {
        return this.register(Registries.f_256954_, path, () -> new RecipeType<T>(){
            private final String id;
            {
                this.id = RegistryManager.this.makeKey(path).toString();
            }

            public String toString() {
                return this.id;
            }
        });
    }

    default public RegistryReference<GameEvent> registerGameEvent(String path, int notificationRadius) {
        return this.register(Registries.f_256827_, path, () -> new GameEvent(path, notificationRadius));
    }

    default public <T> TagKey<T> createTag(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return TagKey.m_203882_(registryKey, (ResourceLocation)this.makeKey(path));
    }

    @Deprecated(forRemoval=true)
    default public TagKey<Block> createBlockTag(String path) {
        return this.registerBlockTag(path);
    }

    default public TagKey<Block> registerBlockTag(String path) {
        return this.createTag(Registries.f_256747_, path);
    }

    default public TagKey<Item> registerItemTag(String path) {
        return this.createTag(Registries.f_256913_, path);
    }

    @Deprecated(forRemoval=true)
    default public TagKey<EntityType<?>> createEntityTypeTag(String path) {
        return this.registerEntityTypeTag(path);
    }

    default public TagKey<EntityType<?>> registerEntityTypeTag(String path) {
        return this.createTag(Registries.f_256939_, path);
    }

    default public TagKey<GameEvent> registerGameEventTag(String path) {
        return this.createTag(Registries.f_256827_, path);
    }

    default public TagKey<DamageType> registerDamageTypeTag(String path) {
        return this.createTag(Registries.f_268580_, path);
    }

    default public <T> ResourceKey<T> registerResourceKey(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return ResourceKey.m_135785_(registryKey, (ResourceLocation)this.makeKey(path));
    }

    default public ResourceKey<DamageType> registerDamageType(String path) {
        return this.registerResourceKey(Registries.f_268580_, path);
    }

    default public ResourceLocation makeKey(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        return new ResourceLocation(this.namespace(), path);
    }
}

