/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.predicate;

import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.predicate.AndConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.NotConnectionPredicate;
import com.supermartijn642.fusion.predicate.OrConnectionPredicate;
import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class DefaultConnectionPredicates {
    public static ConnectionPredicate and(ConnectionPredicate ... predicates) {
        return new AndConnectionPredicate(Arrays.asList(predicates));
    }

    public static ConnectionPredicate or(ConnectionPredicate ... predicates) {
        return new OrConnectionPredicate(Arrays.asList(predicates));
    }

    public static ConnectionPredicate not(ConnectionPredicate predicate) {
        return new NotConnectionPredicate(predicate);
    }

    public static ConnectionPredicate isFaceVisible() {
        return new IsSameBlockConnectionPredicate();
    }

    public static ConnectionPredicate isSameBlock() {
        return new IsSameBlockConnectionPredicate();
    }

    public static ConnectionPredicate isSameState() {
        return new IsSameStateConnectionPredicate();
    }

    public static ConnectionPredicate matchBlock(Block block) {
        return new MatchBlockConnectionPredicate(block);
    }

    public static ConnectionPredicate matchState(Block block, Pair<Property<?>, ?> ... properties) {
        return new MatchStateConnectionPredicate(block, properties);
    }

    public static ConnectionPredicate matchState(BlockState state) {
        return DefaultConnectionPredicates.matchState(state.m_60734_(), (Pair[])state.m_61147_().stream().map(p -> Pair.of(p, state.m_61143_(p))).toArray(Pair[]::new));
    }
}

