/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ResourcePackLoader.class}, remap=false)
public class ResourcePackLoaderMixin {
    @Inject(method={"createPackForMod"}, at={@At(value="RETURN")})
    private static void createPackForMod(IModFileInfo mf, CallbackInfoReturnable<PathPackResources> ci) {
        PathPackResources resources = (PathPackResources)ci.getReturnValue();
        if (resources instanceof PackResourcesExtension) {
            String overridesFolder;
            Path path = mf.getFile().findResource(new String[]{"pack.mcmeta"});
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                overridesFolder = (String)AbstractPackResources.m_10214_((MetadataSectionSerializer)FusionPackMetadataSection.INSTANCE, (InputStream)stream);
            }
            catch (IOException ignored) {
                return;
            }
            if (overridesFolder != null) {
                ((PackResourcesExtension)resources).setFusionOverridesFolder(overridesFolder);
            }
        }
    }
}

