/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.block;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.blockentity.BlockEntityArcade;
import mod.casinocraft.blockentity.BlockEntityMachine;
import mod.lucky77.block.MachinaTall;
import mod.lucky77.blockentity.BlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.NetworkHooks;

public class BlockArcade
extends MachinaTall
implements EntityBlock {
    private static final IntegerProperty MODULE = IntegerProperty.m_61631_((String)"module", (int)0, (int)17);
    private final DyeColor color;
    private static final VoxelShape AABB0 = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape AABB1 = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape AABB2 = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    private static final VoxelShape AABB3 = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)14.0);

    public BlockArcade(Block block, DyeColor color) {
        super(block);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OFFSET, (Comparable)Boolean.TRUE)).m_61124_((Property)MODULE, (Comparable)Integer.valueOf(17)));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean isPrimary = (Boolean)state.m_61143_((Property)OFFSET);
        BlockEntityMachine tile = (BlockEntityMachine)world.m_7702_(this.getTilePosition(pos, isPrimary, Direction.DOWN));
        if (tile != null && tile.settingDropItemsOnBreak) {
            tile.m_6836_(3, new ItemStack((ItemLike)tile.m_8020_(3).m_41720_(), tile.storageToken));
            tile.m_6836_(4, new ItemStack((ItemLike)tile.m_8020_(4).m_41720_(), tile.storageToken));
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void interact(Level world, BlockPos pos, Player player, BlockEntityBase tile) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new mod.casinocraft.menu.MenuProvider((BlockEntityMachine)tile), buf -> buf.m_130064_(pos));
    }

    public static void setModuleState(Level world, BlockPos pos) {
        BlockState iblockstate = world.m_8055_(pos);
        BlockEntityMachine tileentity = (BlockEntityMachine)world.m_7702_(pos);
        if (tileentity != null) {
            if (tileentity.m_8020_(0).m_41619_()) {
                world.m_7731_(pos, (BlockState)iblockstate.m_61124_((Property)MODULE, (Comparable)Integer.valueOf(17)), 3);
                world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)iblockstate.m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MODULE, (Comparable)Integer.valueOf(17)), 3);
            } else {
                world.m_7731_(pos, (BlockState)iblockstate.m_61124_((Property)MODULE, (Comparable)Integer.valueOf(BlockArcade.itemToInt(tileentity.m_8020_(1).m_41720_()))), 3);
                world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)iblockstate.m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MODULE, (Comparable)Integer.valueOf(BlockArcade.itemToInt(tileentity.m_8020_(1).m_41720_()))), 3);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)OFFSET) != false ? new BlockEntityArcade(pos, state, this.color, 0) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockArcade.createTicker(level, type, (BlockEntityType<? extends BlockEntityArcade>)((BlockEntityType)CasinoKeeper.TILE_ARCADE_BASE.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends BlockEntityArcade> typeCustom) {
        return BlockArcade.createTickerHelper(type, typeCustom, BlockEntityMachine::serverTick);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction enumfacing = (Direction)state.m_61143_((Property)FACING);
        switch (enumfacing) {
            case NORTH: {
                return AABB1;
            }
            case SOUTH: {
                return AABB3;
            }
            case EAST: {
                return AABB2;
            }
            case WEST: {
                return AABB0;
            }
        }
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OFFSET, MODULE});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BlockPos pos2 = this.getTilePosition(pos, (Boolean)state.m_61143_((Property)OFFSET), Direction.DOWN);
        BlockEntityMachine tileEntity = (BlockEntityMachine)worldIn.m_7702_(pos2);
        boolean unbreakable = tileEntity.settingIndestructableBlock;
        float f = state.m_60800_(worldIn, pos);
        if (unbreakable) {
            f *= 1000.0f;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        BlockPos pos2 = this.getTilePosition(pos, (Boolean)state.m_61143_((Property)OFFSET), Direction.DOWN);
        BlockEntityMachine tileEntity = (BlockEntityMachine)world.m_7702_(pos2);
        boolean unbreakable = tileEntity.settingIndestructableBlock;
        return this.m_7374_().m_7325_() * (float)(unbreakable ? 1000 : 1);
    }

    private static int itemToInt(Item item) {
        if (item == CasinoKeeper.MODULE_CHIP_BLACK.get()) {
            return 0;
        }
        if (item == CasinoKeeper.MODULE_CHIP_RED.get()) {
            return 1;
        }
        if (item == CasinoKeeper.MODULE_CHIP_GREEN.get()) {
            return 2;
        }
        if (item == CasinoKeeper.MODULE_CHIP_BROWN.get()) {
            return 3;
        }
        if (item == CasinoKeeper.MODULE_CHIP_BLUE.get()) {
            return 4;
        }
        if (item == CasinoKeeper.MODULE_CHIP_PURPLE.get()) {
            return 5;
        }
        if (item == CasinoKeeper.MODULE_CHIP_CYAN.get()) {
            return 6;
        }
        if (item == CasinoKeeper.MODULE_CHIP_LIGHT_GRAY.get()) {
            return 7;
        }
        if (item == CasinoKeeper.MODULE_CHIP_GRAY.get()) {
            return 8;
        }
        if (item == CasinoKeeper.MODULE_CHIP_PINK.get()) {
            return 9;
        }
        if (item == CasinoKeeper.MODULE_CHIP_LIME.get()) {
            return 10;
        }
        if (item == CasinoKeeper.MODULE_CHIP_YELLOW.get()) {
            return 11;
        }
        if (item == CasinoKeeper.MODULE_CHIP_LIGHT_BLUE.get()) {
            return 12;
        }
        if (item == CasinoKeeper.MODULE_CHIP_MAGENTA.get()) {
            return 13;
        }
        if (item == CasinoKeeper.MODULE_CHIP_ORANGE.get()) {
            return 14;
        }
        if (item == CasinoKeeper.MODULE_CHIP_WHITE.get()) {
            return 15;
        }
        return 16;
    }
}

