/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.util.function.Supplier;
import mod.casinocraft.blockentity.BlockEntityMachine;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.network.MessageStateClient;
import mod.casinocraft.system.CasinoPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageStateServer {
    static boolean system;
    static int state;
    static BlockPos pos;

    public MessageStateServer(boolean system, int state, BlockPos pos) {
        MessageStateServer.system = system;
        MessageStateServer.state = state;
        MessageStateServer.pos = pos;
    }

    public static void encode(MessageStateServer msg, FriendlyByteBuf buf) {
        buf.writeBoolean(system);
        buf.writeInt(state);
        buf.m_130064_(pos);
    }

    public static MessageStateServer decode(FriendlyByteBuf buf) {
        boolean _system = buf.readBoolean();
        int _state = buf.readInt();
        BlockPos _pos = buf.m_130135_();
        return new MessageStateServer(_system, _state, _pos);
    }

    public static class Handler {
        public static void handle(MessageStateServer message, Supplier<NetworkEvent.Context> context) {
            BlockEntityMachine te = (BlockEntityMachine)context.get().getSender().m_9236_().m_46745_(pos).m_7702_(pos);
            context.get().enqueueWork(() -> {
                if (system) {
                    if (state == -1) {
                        ((LogicModule)te.logic).pause = !((LogicModule)te.logic).pause;
                    } else if (state == -2) {
                        ((LogicModule)te.logic).resetPlayers();
                        ((LogicModule)te.logic).turnstate = 0;
                    } else if (state == -3) {
                        ((LogicModule)te.logic).resetPlayers();
                    } else if (state >= 10) {
                        ((LogicModule)te.logic).reward[MessageStateServer.state - 10] = 0;
                    } else {
                        ((LogicModule)te.logic).turnstate = state;
                    }
                } else {
                    ((LogicModule)te.logic).command(state);
                }
            });
            CasinoPacketHandler.sendToChunk(new MessageStateClient(system, state, pos), context.get().getSender().f_19853_.m_46745_(pos));
            context.get().setPacketHandled(true);
        }
    }
}

