/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.function.Predicate;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.Config;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.logic.other.LogicDummy;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.network.MessageInventoryServer;
import mod.casinocraft.network.MessagePlayerServer;
import mod.casinocraft.network.MessageScoreServer;
import mod.casinocraft.network.MessageStartServer;
import mod.casinocraft.network.MessageStateServer;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.util.ButtonMap;
import mod.casinocraft.util.ButtonSet;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.Ship;
import mod.lucky77.menu.MenuBase;
import mod.lucky77.screen.ScreenBase;
import mod.lucky77.system.SystemInventory;
import mod.lucky77.util.Vector2;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public abstract class ScreenCasino
extends ScreenBase<MenuCasino> {
    protected int tableID;
    protected int playerToken = -1;
    protected int bet = 0;
    private int colour = 0;
    private int colourize = 65793;
    private final int grayscale = 0xFFFFFF;
    private int camera1 = 0;
    private int camera0 = 0;
    protected boolean showDebug = false;
    protected boolean showForfeit = false;
    private final Inventory inventory;
    protected ButtonSet buttonSet = new ButtonSet();

    public ScreenCasino(MenuCasino container, Inventory player, Component name) {
        super((MenuBase)container, player, name, 256, 256);
        this.tableID = container.tableID;
        this.inventory = player;
        if (this.tableID == 1 || this.tableID == 2) {
            this.createButtons();
            this.createGameButtons();
        }
    }

    private LogicModule logic() {
        return ((MenuCasino)this.f_97732_).logic();
    }

    private void createButtons() {
        this.buttonSet.addButton(ButtonMap.POS_TOP_MIDDLE, ButtonMap.SCORE, () -> this.logic().turnstate == 0 && this.logic().hasHighscore(), this::commandReset);
        this.buttonSet.addButton(ButtonMap.POS_MID_MIDDLE, ButtonMap.FINISH, () -> this.logic().turnstate == 5, this::commandReset);
        this.buttonSet.addButton(ButtonMap.POS_MID_MIDDLE, ButtonMap.BACK, () -> this.logic().turnstate == 7, this::commandReset);
        this.buttonSet.addButton(ButtonMap.POS_MID_MIDDLE, ButtonMap.START, () -> this.logic().turnstate == 0 && this.hasBet(), this::commandStart);
        this.buttonSet.addButton(new Vector2(56, 212), ButtonMap.ARROW_DOWN_OFF, ButtonMap.ARROW_DOWN_ON, 1, 32, () -> this.logic().turnstate == 0 && ((MenuCasino)this.f_97732_).hasToken() && this.bet > ((MenuCasino)this.f_97732_).getBettingLow(), this::commandBetDown);
        this.buttonSet.addButton(new Vector2(174, 212), ButtonMap.ARROW_UP_OFF, ButtonMap.ARROW_UP_ON, 1, 32, () -> this.logic().turnstate == 0 && ((MenuCasino)this.f_97732_).hasToken() && this.bet < ((MenuCasino)this.f_97732_).getBettingHigh(), this::commandBetUp);
        this.buttonSet.addButton(ButtonMap.POS_MID_MIDDLE, ButtonMap.JOIN, () -> this.logic().turnstate == 2 && this.logic().isMultiplayer() && !this.isCurrentPlayer(), this::commandJoinGame);
        this.buttonSet.addButton(new Vector2(this.tableID == 1 ? 240 : 336, 240), ButtonMap.FORFEIT_OFF, ButtonMap.FORFEIT_ON, 0, 96, () -> this.logic().turnstate == 2 && !this.logic().isMultiplayer(), this::commandForfeit);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.keyTyped(keyCode);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void keyTyped(int keyCode) {
        if (keyCode == 259) {
            boolean bl = this.showDebug = !this.showDebug;
        }
        if (this.tableID < 3 && this.isCurrentPlayer() && !this.logic().pause && (this.logic().turnstate == 2 || this.logic().turnstate == 3)) {
            if (keyCode == 265) {
                this.action(265);
            }
            if (keyCode == 264) {
                this.action(264);
            }
            if (keyCode == 263) {
                this.action(263);
            }
            if (keyCode == 262) {
                this.action(262);
            }
            if (keyCode == 257) {
                this.action(257);
            }
            if (keyCode == 48) {
                this.action(348);
            }
            if (keyCode == 49) {
                this.action(349);
            }
            if (keyCode == 50) {
                this.action(350);
            }
            if (keyCode == 51) {
                this.action(351);
            }
            if (keyCode == 52) {
                this.action(352);
            }
            if (keyCode == 53) {
                this.action(353);
            }
            if (keyCode == 54) {
                this.action(354);
            }
            if (keyCode == 55) {
                this.action(355);
            }
            if (keyCode == 56) {
                this.action(356);
            }
            if (keyCode == 57) {
                this.action(357);
            }
        }
        if (this.tableID == 0) {
            if (this.logic().turnstate == 0 && keyCode == 257) {
                this.commandStart();
            }
            if (this.logic().turnstate >= 5 && keyCode == 257) {
                this.commandReset();
            }
            if ((this.logic().turnstate == 2 || this.logic().turnstate == 3) && keyCode == 32) {
                this.turnstate(-1);
            }
            if ((this.logic().turnstate == 2 || this.logic().turnstate == 3) && ((MenuCasino)this.f_97732_).logic().pause && keyCode == 257) {
                this.turnstate(4);
            }
        }
        if (this.tableID == 3 && this.logic().scoreLives > 0) {
            if (this.logic().turnstate == 0 && keyCode == 257) {
                this.commandStart();
            }
            if (this.logic().turnstate == 5 && keyCode == 257) {
                this.commandReset();
            }
            if (keyCode == 32) {
                this.action(1);
            }
            if (this.logic().turnstate == 2 && keyCode == 257 && this.logic().scoreLevel < 5 && this.playerToken >= this.bet) {
                this.collectBet();
                this.playerToken = -1;
                this.action(0);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 || mouseButton == 1) {
            if (this.logic().turnstate < 2 || this.logic().turnstate > 3) {
                this.buttonSet.interact(this.f_97735_, this.f_97736_, mouseX, mouseY);
            }
            if (this.logic().turnstate == 2 && !this.isActivePlayer() && this.logic().isMultiplayer()) {
                this.buttonSet.interact(this.f_97735_, this.f_97736_, mouseX, mouseY);
            }
            if ((this.logic().turnstate == 2 || this.logic().turnstate == 3) && this.isActivePlayer()) {
                this.buttonSet.interact(this.f_97735_, this.f_97736_, mouseX, mouseY);
                if (!(this.logic() instanceof LogicDummy)) {
                    this.interact(mouseX, mouseY, mouseButton);
                }
            }
        }
        return false;
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        if (this.logic() instanceof LogicDummy) {
            return;
        }
        if (this.tableID == 0) {
            this.colour += this.colourize;
            if (this.colour <= 0 || this.colour >= 0xFFFFFF) {
                this.colourize = -this.colourize;
            }
        }
        if (this.showDebug) {
            this.f_96547_.m_92883_(matrix, "PLAYER1: " + this.logic().currentPlayer[0], this.tableID == 2 ? 355.0f : 260.0f, 15.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "PLAYER2: " + this.logic().currentPlayer[1], this.tableID == 2 ? 355.0f : 260.0f, 25.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "PLAYER3: " + this.logic().currentPlayer[2], this.tableID == 2 ? 355.0f : 260.0f, 35.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "PLAYER4: " + this.logic().currentPlayer[3], this.tableID == 2 ? 355.0f : 260.0f, 45.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "PLAYER5: " + this.logic().currentPlayer[4], this.tableID == 2 ? 355.0f : 260.0f, 55.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "PLAYER6: " + this.logic().currentPlayer[5], this.tableID == 2 ? 355.0f : 260.0f, 65.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "TIMEOUT: " + this.logic().timeout, this.tableID == 2 ? 355.0f : 260.0f, 75.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "STATE:   " + this.logic().turnstate, this.tableID == 2 ? 355.0f : 260.0f, 85.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "PLAYERS: " + this.logic().getFirstFreePlayerSlot(), this.tableID == 2 ? 355.0f : 260.0f, 95.0f, 0xFFFFFF);
            this.f_96547_.m_92883_(matrix, "ACTIVE:  " + this.logic().activePlayer, this.tableID == 2 ? 355.0f : 260.0f, 105.0f, 0xFFFFFF);
        }
        if (this.playerToken == -1 && this.logic().turnstate < 4) {
            this.validateTokens();
        }
        if (((MenuCasino)this.f_97732_).logic().isMultiplayer() && this.logic().turnstate == 2 && !this.isCurrentPlayer() && ((MenuCasino)this.f_97732_).logic().hasFreePlayerSlots()) {
            this.drawFont(matrix, "BET:", 96, 196);
            this.f_96542_.m_274569_(matrix, ((MenuCasino)this.f_97732_).getItemToken(), 180, 192);
            if (((MenuCasino)this.f_97732_).getBettingLow() > 1) {
                this.drawFont(matrix, "x" + ((MenuCasino)this.f_97732_).getBettingLow(), 138, 196);
            }
        }
        if (this.logic().turnstate == 0 && (this.tableID == 1 || this.tableID == 2) && ((MenuCasino)this.f_97732_).hasToken() && ((MenuCasino)this.f_97732_).getBettingHigh() > 0) {
            this.drawFontCenter(matrix, "The entry fee is:", 128, 112);
            this.f_96542_.m_274569_(matrix, ((MenuCasino)this.f_97732_).getItemToken(), 120, 124);
            if (this.bet > 1) {
                this.drawFont(matrix, "x" + this.bet, 140, 128);
            }
            if (((MenuCasino)this.f_97732_).getBettingHigh() != ((MenuCasino)this.f_97732_).getBettingLow()) {
                this.drawFontCenter(matrix, "You can change the amount to pay.", 128, 144);
            }
            if (this.playerToken < this.bet) {
                this.drawFontCenter(matrix, "You don't have enough Token to play...", 128, 160);
            }
            if (this.playerToken >= this.bet) {
                this.drawFontCenter(matrix, "Do you wish to play?", 128, 160);
            }
        }
        if (this.logic().turnstate == 0 && this.tableID == 0) {
            if (((MenuCasino)this.f_97732_).hasToken() && ((MenuCasino)this.f_97732_).getBettingHigh() > 0) {
                this.drawFontCenter(matrix, "INSERT TOKEN", 128, 180, 0xFFFFFF);
                this.f_96542_.m_274569_(matrix, ((MenuCasino)this.f_97732_).getItemToken(), 120, 192);
                if (this.bet > 1) {
                    this.drawFont(matrix, "x" + ((MenuCasino)this.f_97732_).getBettingLow(), 140, 196, 0xFFFFFF);
                }
                if (this.playerToken < ((MenuCasino)this.f_97732_).getBettingLow()) {
                    this.drawFontCenter(matrix, "NOT ENOUGH TOKEN", 128, 228, 0xFFFFFF);
                } else {
                    this.drawFontCenter(matrix, "Press ENTER", 128, 228, this.colour);
                }
            } else {
                this.drawFontCenter(matrix, "Press ENTER", 128, 228, this.colour);
            }
        }
        if (this.logic().turnstate == 7) {
            if (this.tableID == 0) {
                this.drawFontCenter(matrix, "Press ENTER", 128, 228, this.colour);
            }
            int max = this.tableID == 0 ? 20 : 18;
            for (int i = 0; i < max; ++i) {
                this.drawFont(matrix, this.logic().scoreName[i], 40, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
                this.drawFontInvert(matrix, "" + this.logic().scoreHigh[i], 216, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
            }
        }
        if (this.tableID < 3 && this.logic().turnstate >= 2 && this.logic().turnstate <= 5) {
            this.drawForegroundLayer(matrix, mouseX, mouseY);
        }
        if (this.tableID == 3 && this.logic().scoreLives > 0) {
            this.drawForegroundLayer(matrix, mouseX, mouseY);
        }
        if (this.logic().turnstate == 2 && ((MenuCasino)this.f_97732_).logic().pause) {
            this.drawFontCenter(matrix, "PAUSE", 128, 196, 0xFFFFFF);
            this.drawFontCenter(matrix, "Press ENTER to FORFEIT", 128, 228, this.colour);
        }
        if (this.logic().turnstate == 5 && this.tableID == 0) {
            this.drawFontCenter(matrix, "GAME OVER", 128, 196, 0xFFFFFF);
            this.drawFontCenter(matrix, "Press ENTER", 128, 228, this.colour);
        }
        if (this.logic().turnstate == 4) {
            this.gameOver();
        }
        if (((MenuCasino)this.f_97732_).getID() != this.logic().getID()) {
            this.m_7379_();
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.buttonSet.update(this.f_97735_, this.f_97736_, mouseX, mouseY);
        if ((this.tableID == 1 || this.tableID == 2) && this.colour > 0) {
            --this.colour;
            if (this.colour == 0) {
                this.showForfeit = false;
            }
        }
        if (this.tableID == 0 && this.logic() instanceof LogicDummy) {
            Random RANDOM = new Random();
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_STATIC);
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 6; ++x) {
                    ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 32 + 32 * x), (int)(this.f_97736_ + 32 * y), (int)(32 * RANDOM.nextInt(8)), (int)(32 * RANDOM.nextInt(8)), (int)32, (int)32);
                }
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_GROUND_ARCADE);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        }
        if (this.tableID == 0 && !(this.logic() instanceof LogicDummy)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getParallaxTexture(true));
            ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)this.camera1, (int)256, (int)256);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getParallaxTexture(false));
            ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)this.camera0, (int)256, (int)256);
        }
        if (this.tableID == 1) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackgroundCardTable());
            ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        }
        if (this.tableID == 2) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackgroundCardTable());
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ - 96), (int)this.f_97736_, (int)0, (int)0, (int)(this.f_97726_ - 32), (int)this.f_97727_);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 128), (int)this.f_97736_, (int)32, (int)0, (int)(this.f_97726_ - 32), (int)this.f_97727_);
        }
        if (this.tableID == 3) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackgroundSlotMachine());
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 31), (int)(this.f_97736_ - 1), (int)0, (int)0, (int)194, (int)162);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)(this.f_97736_ + 163), (int)0, (int)162, (int)256, (int)94);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 256), (int)(this.f_97736_ + 178), (int)224, (int)64, (int)32, (int)64);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 38), (int)(this.f_97736_ + 161), (int)195, (int)129, (int)60, (int)2);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 98), (int)(this.f_97736_ + 161), (int)195, (int)129, (int)60, (int)2);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 158), (int)(this.f_97736_ + 161), (int)195, (int)129, (int)60, (int)2);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 10), (int)(this.f_97736_ + 257), (int)195, (int)129, (int)52, (int)30);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 62), (int)(this.f_97736_ + 257), (int)203, (int)129, (int)44, (int)30);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 106), (int)(this.f_97736_ + 257), (int)203, (int)129, (int)44, (int)30);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 150), (int)(this.f_97736_ + 257), (int)203, (int)129, (int)44, (int)30);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 194), (int)(this.f_97736_ + 257), (int)203, (int)129, (int)52, (int)30);
            if (this.logic().scoreLives == 2) {
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 261), (int)(this.f_97736_ + 220), (int)197, (int)64, (int)22, (int)8);
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 249), (int)(this.f_97736_ + 224), (int)201, (int)9, (int)46, (int)46);
            } else {
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 261), (int)(this.f_97736_ + 142), (int)197, (int)68, (int)24, (int)60);
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 261), (int)(this.f_97736_ + 100), (int)197, (int)68, (int)22, (int)42);
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 249), (int)(this.f_97736_ + 60), (int)201, (int)9, (int)46, (int)46);
            }
        }
        if (this.logic().turnstate <= 1) {
            this.drawLogo(matrix);
        }
        if (this.logic() instanceof LogicDummy) {
            return;
        }
        if (this.tableID < 3 && this.logic().turnstate >= 2 && this.logic().turnstate < 6) {
            if (this.logic().pause) {
                RenderSystem.m_157429_((float)0.35f, (float)0.35f, (float)0.35f, (float)1.0f);
            }
            this.drawBackgroundLayer(matrix, partialTicks, mouseX, mouseY);
            if (this.logic().pause) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (this.tableID == 3 && this.logic().scoreLives > 0) {
            this.drawBackgroundLayer(matrix, partialTicks, mouseX, mouseY);
        }
        if (this.tableID == 1 || this.tableID == 2) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_BUTTONS);
            while (this.buttonSet.next()) {
                if (this.buttonSet.visible()) {
                    ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + this.buttonSet.pos().X), (int)(this.f_97736_ + this.buttonSet.pos().Y), (int)this.buttonSet.map().X, (int)this.buttonSet.map().Y, (int)this.buttonSet.sizeX(), (int)this.buttonSet.sizeY());
                }
                if (!this.buttonSet.isHighlighted()) continue;
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + this.buttonSet.pos().X), (int)(this.f_97736_ + this.buttonSet.pos().Y), (int)this.buttonSet.highlight().X, (int)this.buttonSet.highlight().Y, (int)this.buttonSet.sizeX(), (int)this.buttonSet.sizeY());
            }
            if (this.colour > 0) {
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 89), (int)(this.f_97736_ + 240), (int)28, (int)242, (int)78, (int)14);
            }
        }
        if (this.tableID == 0) {
            int shift2;
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_GROUND_ARCADE);
            ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
            int n = shift2 = this.logic().turnstate == 2 || this.logic().turnstate == 3 ? 2 : 1;
            if (this.logic().turnstate != 5 && !((MenuCasino)this.f_97732_).logic().pause) {
                this.camera1 = (this.camera1 + shift2) % 256;
            }
            if (this.logic().turnstate != 5 && !((MenuCasino)this.f_97732_).logic().pause) {
                this.camera0 = (this.camera0 + shift2 * 2) % 256;
            }
        }
        if ((this.logic().turnstate == 2 || this.logic().turnstate == 3) && this.logic().isMultiplayer()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_DICE);
            for (int i = 0; i < this.logic().getFirstFreePlayerSlot(); ++i) {
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + (this.tableID == 2 ? 340 : 245)), (int)(this.f_97736_ + 32 + 36 * i), (int)224, (int)(32 + 32 * i), (int)32, (int)32);
            }
            if (this.logic().activePlayer < this.logic().getFirstFreePlayerSlot()) {
                ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + (this.tableID == 2 ? 340 : 245)), (int)(this.f_97736_ + 32 + 36 * this.logic().activePlayer), (int)192, (int)(32 + 32 * this.logic().activePlayer), (int)32, (int)32);
            }
        }
    }

    private void gameOver() {
        this.buttonSet.releaseToggle();
        int pos = this.getPlayerPosition();
        if (pos > -1 && this.playerToken != -1) {
            this.payBet(this.logic().reward[pos]);
            this.turnstate(10 + pos);
            this.playerToken = -1;
        }
        if (this.allCleared()) {
            this.turnstate(5);
            if (this.logic().hasHighscore() && this.isActivePlayer()) {
                this.highscore();
            } else {
                this.turnstate(-3);
            }
        }
    }

    private boolean allCleared() {
        for (int i = 0; i < 6; ++i) {
            if (this.logic().reward[i] <= 0) continue;
            return false;
        }
        return true;
    }

    private void highscore() {
        CasinoPacketHandler.sendToServer(new MessageScoreServer(this.inventory.f_35978_.m_7755_().getString(), this.logic().scorePoint, ((MenuCasino)this.f_97732_).pos()));
        int lastScore = 0;
        int prizeSET = 0;
        int prizeCON = 0;
        for (int i = 0; i < 3; ++i) {
            if (((MenuCasino)this.f_97732_).getPrizeCount(i) <= 0) continue;
            if (((MenuCasino)this.f_97732_).getPrizeMode(i)) {
                if (((MenuCasino)this.f_97732_).getPrizeScore(i) > ((MenuCasino)this.f_97732_).logic().scorePoint || ((MenuCasino)this.f_97732_).getPrizeScore(i) <= lastScore) continue;
                lastScore = ((MenuCasino)this.f_97732_).getPrizeScore(i);
                prizeSET = ((MenuCasino)this.f_97732_).getPrizeCount(i);
                continue;
            }
            if (((MenuCasino)this.f_97732_).getPrizeScore(i) <= 0) continue;
            prizeCON += ((MenuCasino)this.f_97732_).getPrizeCount(i) * (((MenuCasino)this.f_97732_).logic().scorePoint / ((MenuCasino)this.f_97732_).getPrizeScore(i));
        }
        this.payPrize(prizeSET + prizeCON);
    }

    private void sendMessageBlock() {
        NonNullList inv = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        inv.set(0, (Object)((MenuCasino)this.f_97732_).container.m_8020_(0));
        inv.set(1, (Object)((MenuCasino)this.f_97732_).container.m_8020_(1));
        inv.set(2, (Object)((MenuCasino)this.f_97732_).container.m_8020_(2));
        inv.set(3, (Object)((MenuCasino)this.f_97732_).container.m_8020_(3));
        inv.set(4, (Object)((MenuCasino)this.f_97732_).container.m_8020_(4));
        CasinoPacketHandler.sendToServer(new MessageInventoryServer((NonNullList<ItemStack>)inv, ((MenuCasino)this.f_97732_).getStorageToken(), ((MenuCasino)this.f_97732_).getStoragePrize(), ((MenuCasino)this.f_97732_).pos()));
    }

    private boolean hasBet() {
        return !((MenuCasino)this.f_97732_).hasToken() || this.playerToken >= this.bet;
    }

    protected void validateTokens() {
        this.playerToken = -2;
        if (this.bet < ((MenuCasino)this.f_97732_).getBettingLow()) {
            this.bet = ((MenuCasino)this.f_97732_).getBettingLow();
        }
        if (this.bet > ((MenuCasino)this.f_97732_).getBettingHigh()) {
            this.bet = ((MenuCasino)this.f_97732_).getBettingHigh();
        }
        if (((MenuCasino)this.f_97732_).hasToken()) {
            Item item = ((MenuCasino)this.f_97732_).getItemToken().m_41720_();
            int count = 0;
            for (int i = 0; i < 36; ++i) {
                if (item != this.inventory.m_8020_(i).m_41720_()) continue;
                count += this.inventory.m_8020_(i).m_41613_();
            }
            this.playerToken = count;
        }
    }

    protected void collectBet() {
        if (((MenuCasino)this.f_97732_).hasToken()) {
            SystemInventory.decreaseInventory((Inventory)this.inventory, (ItemStack)((MenuCasino)this.f_97732_).getItemToken(), (int)this.bet);
            int i = 0;
            ItemStack itemStack = ItemStack.f_41583_;
            Predicate<ItemStack> stack = Predicate.isEqual(((MenuCasino)this.f_97732_).getItemToken());
            int count = this.bet;
            for (int j = 0; j < this.inventory.m_6643_(); ++j) {
                ItemStack itemstack = this.inventory.m_8020_(j);
                if (itemstack.m_41619_() || !stack.test(itemstack)) continue;
                int k = count <= 0 ? itemstack.m_41613_() : Math.min(count - i, itemstack.m_41613_());
                i += k;
                if (count == 0) continue;
                itemstack.m_41774_(k);
                if (!itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, ItemStack.f_41583_);
            }
            if (!itemStack.m_41619_() && stack.test(itemStack)) {
                int l;
                int n = l = count <= 0 ? itemStack.m_41613_() : Math.min(count - i, itemStack.m_41613_());
                if (count != 0) {
                    itemStack.m_41774_(l);
                }
            }
            CasinoPacketHandler.sendToServer(new MessagePlayerServer(((MenuCasino)this.f_97732_).getItemToken().m_41720_(), -this.bet));
            if (!((MenuCasino)this.f_97732_).getSettingInfiniteToken()) {
                ((MenuCasino)this.f_97732_).setStorageToken(((MenuCasino)this.f_97732_).getStorageToken() + this.bet);
                this.sendMessageBlock();
            }
            this.playerToken = -1;
        }
    }

    private void payBet(int multi) {
        if (multi <= 0) {
            return;
        }
        if (((MenuCasino)this.f_97732_).hasToken()) {
            if (!((MenuCasino)this.f_97732_).getSettingInfiniteToken()) {
                Item item = ((MenuCasino)this.f_97732_).getItemToken().m_41720_();
                int count = this.bet * multi;
                int count2 = 0;
                count2 = Math.min(((MenuCasino)this.f_97732_).getStorageToken(), count);
                ((MenuCasino)this.f_97732_).setStorageToken(((MenuCasino)this.f_97732_).getStorageToken() - count);
                if (((MenuCasino)this.f_97732_).getStorageToken() <= 0) {
                    ((MenuCasino)this.f_97732_).setStorageToken(0);
                    ((MenuCasino)this.f_97732_).setItemToken(new ItemStack((ItemLike)Blocks.f_50016_));
                }
                this.sendMessageBlock();
                this.inventory.m_36054_(new ItemStack((ItemLike)item, count2));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count2));
            } else {
                Item item = ((MenuCasino)this.f_97732_).getItemToken().m_41720_();
                int count = this.bet * multi;
                this.inventory.m_36054_(new ItemStack((ItemLike)item, count));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count));
            }
        }
    }

    private void payPrize(int amount) {
        if (amount <= 0) {
            return;
        }
        if (((MenuCasino)this.f_97732_).hasReward()) {
            if (!((MenuCasino)this.f_97732_).getSettingInfinitePrize()) {
                Item item = ((MenuCasino)this.f_97732_).getItemPrize().m_41720_();
                int count = 0;
                count = Math.min(((MenuCasino)this.f_97732_).getStoragePrize(), amount);
                ((MenuCasino)this.f_97732_).setStoragePrize(((MenuCasino)this.f_97732_).getStoragePrize() - amount);
                if (((MenuCasino)this.f_97732_).getStoragePrize() <= 0) {
                    ((MenuCasino)this.f_97732_).setStoragePrize(0);
                    ((MenuCasino)this.f_97732_).setItemPrize(new ItemStack((ItemLike)Blocks.f_50016_));
                }
                this.sendMessageBlock();
                this.inventory.m_36054_(new ItemStack((ItemLike)item, count));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, count));
            } else {
                Item item = ((MenuCasino)this.f_97732_).getItemPrize().m_41720_();
                this.inventory.m_36054_(new ItemStack((ItemLike)item, amount));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, amount));
            }
        }
    }

    protected boolean isCurrentPlayer() {
        if (((MenuCasino)this.f_97732_).logic().isMultiplayer()) {
            if (((MenuCasino)this.f_97732_).getCurrentPlayer(0).matches("void")) {
                return true;
            }
            for (int i = 0; i < 6; ++i) {
                if (!((MenuCasino)this.f_97732_).getCurrentPlayer(i).matches(this.inventory.f_35978_.m_7755_().getString())) continue;
                return true;
            }
        } else {
            return ((MenuCasino)this.f_97732_).getCurrentPlayer(0).matches("void") || ((MenuCasino)this.f_97732_).getCurrentPlayer(0).matches(this.inventory.f_35978_.m_7755_().getString());
        }
        return false;
    }

    protected boolean isActivePlayer() {
        if (((MenuCasino)this.f_97732_).logic().isMultiplayer()) {
            for (int i = 0; i < 6; ++i) {
                if (!((MenuCasino)this.f_97732_).getCurrentPlayer(i).matches(this.inventory.f_35978_.m_7755_().getString()) || i != this.logic().activePlayer) continue;
                return true;
            }
        } else {
            return ((MenuCasino)this.f_97732_).getCurrentPlayer(0).matches(this.inventory.f_35978_.m_7755_().getString());
        }
        return false;
    }

    protected int getPlayerPosition() {
        if (((MenuCasino)this.f_97732_).logic().isMultiplayer()) {
            for (int i = 0; i < 6; ++i) {
                if (!((MenuCasino)this.f_97732_).getCurrentPlayer(i).matches(this.inventory.f_35978_.m_7755_().getString())) continue;
                return i;
            }
        } else {
            return ((MenuCasino)this.f_97732_).getCurrentPlayer(0).matches(this.inventory.f_35978_.m_7755_().getString()) ? 0 : -1;
        }
        return -1;
    }

    protected void drawBackground(PoseStack matrix, ResourceLocation rl) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)rl);
        ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
    }

    protected void drawBackground(PoseStack matrix, ResourceLocation rl, int offset) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)rl);
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + offset), (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
    }

    protected void drawBackground(PoseStack matrix, ResourceLocation rl, ResourceLocation rl2) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)rl);
        ScreenCasino.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)rl2);
    }

    protected void drawTimer(PoseStack matrix) {
        if (this.logic().turnstate == 2 || this.logic().turnstate == 3) {
            if ((Integer)Config.ConfigMachine.config_timeout.get() - this.logic().timeout > 0) {
                this.drawFontInvert(matrix, "" + ((Integer)Config.ConfigMachine.config_timeout.get() - this.logic().timeout), this.tableID == 1 ? 238 : 336, 7);
            }
        }
    }

    protected void drawValueLeft(PoseStack matrix, String name, int value) {
        this.drawFontCenter(matrix, name, 32, 7, 0xA9A9A9);
        this.drawFontCenter(matrix, "" + value, 64, 7);
    }

    protected void drawValueRight(PoseStack matrix, String name, int value) {
        this.drawFontCenter(matrix, name, 224, 7, 0xA9A9A9);
        this.drawFontCenter(matrix, "" + value, 192, 7);
    }

    protected void drawFont(PoseStack matrix, String text, int x, int y) {
        this.drawFont(matrix, text, x, y, 0xFFFFFF);
    }

    protected void drawFont(PoseStack matrix, String text, int x, int y, int color) {
        this.f_96547_.m_92883_(matrix, text, (float)(x + 1), (float)(y + 1), 0);
        this.f_96547_.m_92883_(matrix, text, (float)x, (float)y, color);
    }

    protected void drawFontInvert(PoseStack matrix, String text, int x, int y) {
        this.drawFontInvert(matrix, text, x, y, 0xFFFFFF);
    }

    protected void drawFontInvert(PoseStack matrix, String text, int x, int y, int color) {
        int w = this.f_96547_.m_92895_(text);
        this.f_96547_.m_92883_(matrix, text, (float)(x + 1 - w), (float)(y + 1), 0);
        this.f_96547_.m_92883_(matrix, text, (float)(x - w), (float)y, color);
    }

    protected void drawFontCenter(PoseStack matrix, String text, int x, int y) {
        this.drawFontCenter(matrix, text, x, y, 0xFFFFFF);
    }

    protected void drawFontCenter(PoseStack matrix, String text, int x, int y, int color) {
        int w = this.f_96547_.m_92895_(text) / 2;
        this.f_96547_.m_92883_(matrix, text, (float)(x + 1 - w), (float)(y + 1), 0);
        this.f_96547_.m_92883_(matrix, text, (float)(x - w), (float)y, color);
    }

    public void drawCard(PoseStack matrix, int posX, int posY, Card card) {
        if (card.suit == -1) {
            return;
        }
        if (card.hidden) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getCardsTexture(true));
        } else {
            if (card.suit <= 1) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.getCardsTexture(false));
            }
            if (card.suit >= 2) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.getCardsTexture(true));
            }
        }
        int texX = card.suit == -1 || card.hidden ? 0 : card.number % 8;
        int texY = card.suit == -1 || card.hidden ? 4 : card.suit % 2 * 2 + card.number / 8;
        if (((Boolean)Config.ConfigMachine.config_animated_cards.get()).booleanValue() && !card.hidden && card.number >= 10 && this.logic().frame == card.suit * 12 + (card.number - 10) * 3) {
            texX += 3;
        }
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX + card.shiftX), (int)(this.f_97736_ + posY + card.shiftY), (int)(texX * 32), (int)(texY * 48), (int)32, (int)(48 - card.deathtimer));
    }

    public void drawCardBack(PoseStack matrix, int posX, int posY, int color) {
        if (color <= 6) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getCardsTexture(true));
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getCardsTexture(false));
        }
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)(color % 7 * 32), (int)192, (int)32, (int)48);
    }

    private void drawLetter(PoseStack matrix, char c, int posX, int posY) {
        if (c == 'a') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)0, (int)0, (int)32, (int)32);
        }
        if (c == 'b') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)32, (int)0, (int)32, (int)32);
        }
        if (c == 'c') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)64, (int)0, (int)32, (int)32);
        }
        if (c == 'd') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)96, (int)0, (int)32, (int)32);
        }
        if (c == 'e') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)128, (int)0, (int)32, (int)32);
        }
        if (c == 'f') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)160, (int)0, (int)32, (int)32);
        }
        if (c == 'g') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)192, (int)0, (int)32, (int)32);
        }
        if (c == 'h') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)224, (int)0, (int)32, (int)32);
        }
        if (c == 'i') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)0, (int)32, (int)32, (int)32);
        }
        if (c == 'j') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)32, (int)32, (int)32, (int)32);
        }
        if (c == 'k') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)64, (int)32, (int)32, (int)32);
        }
        if (c == 'l') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)96, (int)32, (int)32, (int)32);
        }
        if (c == 'm') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)128, (int)32, (int)32, (int)32);
        }
        if (c == 'n') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)160, (int)32, (int)32, (int)32);
        }
        if (c == 'o') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)192, (int)32, (int)32, (int)32);
        }
        if (c == 'p') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)224, (int)32, (int)32, (int)32);
        }
        if (c == 'q') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)0, (int)64, (int)32, (int)32);
        }
        if (c == 'r') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)32, (int)64, (int)32, (int)32);
        }
        if (c == 's') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)64, (int)64, (int)32, (int)32);
        }
        if (c == 't') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)96, (int)64, (int)32, (int)32);
        }
        if (c == 'u') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)128, (int)64, (int)32, (int)32);
        }
        if (c == 'v') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)160, (int)64, (int)32, (int)32);
        }
        if (c == 'w') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)192, (int)64, (int)32, (int)32);
        }
        if (c == 'x') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)224, (int)64, (int)32, (int)32);
        }
        if (c == 'y') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)0, (int)96, (int)32, (int)32);
        }
        if (c == 'z') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)32, (int)96, (int)32, (int)32);
        }
        if (c == '0') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)64, (int)96, (int)32, (int)32);
        }
        if (c == '1') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)96, (int)96, (int)32, (int)32);
        }
        if (c == '2') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)128, (int)96, (int)32, (int)32);
        }
        if (c == '3') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)160, (int)96, (int)32, (int)32);
        }
        if (c == '4') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)192, (int)96, (int)32, (int)32);
        }
        if (c == '5') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)224, (int)96, (int)32, (int)32);
        }
        if (c == '6') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)0, (int)128, (int)32, (int)32);
        }
        if (c == '7') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)32, (int)128, (int)32, (int)32);
        }
        if (c == '8') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)64, (int)128, (int)32, (int)32);
        }
        if (c == '9') {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)posX, (int)posY, (int)96, (int)128, (int)32, (int)32);
        }
    }

    private ResourceLocation getBackgroundCardTable() {
        if (((MenuCasino)this.f_97732_).color == DyeColor.BLACK) {
            return CasinoKeeper.TEXTURE_GROUND_BLACK;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.BLUE) {
            return CasinoKeeper.TEXTURE_GROUND_BLUE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.BROWN) {
            return CasinoKeeper.TEXTURE_GROUND_BROWN;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.CYAN) {
            return CasinoKeeper.TEXTURE_GROUND_CYAN;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.GRAY) {
            return CasinoKeeper.TEXTURE_GROUND_GRAY;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.GREEN) {
            return CasinoKeeper.TEXTURE_GROUND_GREEN;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.LIGHT_BLUE) {
            return CasinoKeeper.TEXTURE_GROUND_LIGHT_BLUE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.LIME) {
            return CasinoKeeper.TEXTURE_GROUND_LIME;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.MAGENTA) {
            return CasinoKeeper.TEXTURE_GROUND_MAGENTA;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.ORANGE) {
            return CasinoKeeper.TEXTURE_GROUND_ORANGE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.PINK) {
            return CasinoKeeper.TEXTURE_GROUND_PINK;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.PURPLE) {
            return CasinoKeeper.TEXTURE_GROUND_PURPLE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.RED) {
            return CasinoKeeper.TEXTURE_GROUND_RED;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.LIGHT_GRAY) {
            return CasinoKeeper.TEXTURE_GROUND_LIGHT_GRAY;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.WHITE) {
            return CasinoKeeper.TEXTURE_GROUND_WHITE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.YELLOW) {
            return CasinoKeeper.TEXTURE_GROUND_YELLOW;
        }
        return CasinoKeeper.TEXTURE_GROUND_GRAY;
    }

    private ResourceLocation getBackgroundSlotMachine() {
        if (((MenuCasino)this.f_97732_).color == DyeColor.BLACK) {
            return CasinoKeeper.TEXTURE_SLOTS_BLACK;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.BLUE) {
            return CasinoKeeper.TEXTURE_SLOTS_BLUE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.BROWN) {
            return CasinoKeeper.TEXTURE_SLOTS_BROWN;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.CYAN) {
            return CasinoKeeper.TEXTURE_SLOTS_CYAN;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.GRAY) {
            return CasinoKeeper.TEXTURE_SLOTS_GRAY;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.GREEN) {
            return CasinoKeeper.TEXTURE_SLOTS_GREEN;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.LIGHT_BLUE) {
            return CasinoKeeper.TEXTURE_SLOTS_LIGHT_BLUE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.LIME) {
            return CasinoKeeper.TEXTURE_SLOTS_LIME;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.MAGENTA) {
            return CasinoKeeper.TEXTURE_SLOTS_MAGENTA;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.ORANGE) {
            return CasinoKeeper.TEXTURE_SLOTS_ORANGE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.PINK) {
            return CasinoKeeper.TEXTURE_SLOTS_PINK;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.PURPLE) {
            return CasinoKeeper.TEXTURE_SLOTS_PURPLE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.RED) {
            return CasinoKeeper.TEXTURE_SLOTS_RED;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.LIGHT_GRAY) {
            return CasinoKeeper.TEXTURE_SLOTS_LIGHT_GRAY;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.WHITE) {
            return CasinoKeeper.TEXTURE_SLOTS_WHITE;
        }
        if (((MenuCasino)this.f_97732_).color == DyeColor.YELLOW) {
            return CasinoKeeper.TEXTURE_SLOTS_YELLOW;
        }
        return CasinoKeeper.TEXTURE_SLOTS_GRAY;
    }

    private void drawLogo(PoseStack matrix) {
        int sizeX = 0;
        String[] logo = this.getGameName().split("_");
        if (this.tableID <= 2) {
            if (this.tableID == 0) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_FONT_ARCADE);
                sizeX = 16;
            } else if (this.tableID == 1 || this.tableID == 2) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_FONT_CARDTABLE);
                sizeX = 32;
            }
            for (int i = 0; i < logo.length; ++i) {
                for (int k = 0; k < logo[i].length(); ++k) {
                    this.drawLetter(matrix, logo[i].charAt(k), this.f_97735_ + 128 - logo[i].length() * (sizeX / 2) + sizeX * k, this.f_97736_ + 32 + 32 * i);
                }
            }
        }
    }

    protected void drawMino(PoseStack matrix, int posX, int posY, int idX, int idY) {
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)(24 * idX), (int)(24 * idY), (int)24, (int)24);
    }

    protected void drawMino(PoseStack matrix, int posX, int posY) {
        this.drawMino(matrix, posX, posY, 0, 0);
    }

    protected void drawMinoSmall(PoseStack matrix, int posX, int posY, int id, boolean alternate) {
        if (alternate) {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)240, (int)(16 * id), (int)16, (int)16);
        } else {
            ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)(16 * id), (int)240, (int)16, (int)16);
        }
    }

    protected void drawMinoSmall(PoseStack matrix, int posX, int posY) {
        this.drawMinoSmall(matrix, posX, posY, 0, false);
    }

    protected void drawDigi(PoseStack matrix, int posX, int posY, int idX, int idY) {
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)(16 * idX), (int)(16 + 16 * idY), (int)16, (int)16);
    }

    protected void drawDigi(PoseStack matrix, int posX, int posY) {
        this.drawDigi(matrix, posX, posY, 0, 0);
    }

    protected void drawDigiSmall(PoseStack matrix, int posX, int posY, int id) {
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)(16 * id), (int)16, (int)6, (int)6);
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX + 6), (int)(this.f_97736_ + posY), (int)(16 * id + 10), (int)16, (int)6, (int)6);
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY + 6), (int)(16 * id), (int)26, (int)6, (int)6);
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX + 6), (int)(this.f_97736_ + posY + 6), (int)(16 * id + 10), (int)26, (int)6, (int)6);
    }

    protected void drawDigiSmall(PoseStack matrix, int posX, int posY) {
        this.drawDigiSmall(matrix, posX, posY, 0);
    }

    protected void drawDigiSymbol(PoseStack matrix, int posX, int posY, int id) {
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)(16 * id), (int)0, (int)16, (int)16);
    }

    protected void drawDigiSymbol(PoseStack matrix, int posX, int posY) {
        this.drawDigiSymbol(matrix, posX, posY, 0);
    }

    protected void drawShip(PoseStack matrix, Ship ship, int shipID, int lookDirection, boolean animate) {
        int frame;
        int n = frame = this.logic().turnstate < 4 && animate ? this.logic().frame % 12 / 2 : 0;
        if (frame == 4) {
            frame = 2;
        }
        if (frame == 5) {
            frame = 1;
        }
        int direction = lookDirection == -1 ? ship.getLookDirection() : lookDirection;
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 32 + ship.getPos().X), (int)(this.f_97736_ + 8 + ship.getPos().Y), (int)(64 * (shipID % 4) + 16 * frame), (int)(128 + direction * 16 + shipID / 4 * 64), (int)16, (int)16);
    }

    protected void drawShip(PoseStack matrix, Vector2 vec, int shipID) {
        int frame;
        int n = frame = this.logic().turnstate < 4 ? this.logic().frame % 12 / 2 : 0;
        if (frame == 4) {
            frame = 2;
        }
        if (frame == 5) {
            frame = 1;
        }
        ScreenCasino.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + 32 + vec.X * 16), (int)(this.f_97736_ + 8 + vec.Y * 16), (int)(64 * (shipID % 4) + 16 * frame), (int)(128 + shipID / 4 * 64), (int)16, (int)16);
    }

    private ResourceLocation getParallaxTexture(boolean lowTexture) {
        return switch (((MenuCasino)this.f_97732_).getSettingAlternateColor()) {
            case 0 -> {
                if (lowTexture) {
                    yield CasinoKeeper.TEXTURE_PARALLAX_0_LOW;
                }
                yield CasinoKeeper.TEXTURE_PARALLAX_0_HIGH;
            }
            case 1 -> {
                if (lowTexture) {
                    yield CasinoKeeper.TEXTURE_PARALLAX_1_LOW;
                }
                yield CasinoKeeper.TEXTURE_PARALLAX_1_HIGH;
            }
            case 2 -> {
                if (lowTexture) {
                    yield CasinoKeeper.TEXTURE_PARALLAX_2_LOW;
                }
                yield CasinoKeeper.TEXTURE_PARALLAX_2_HIGH;
            }
            case 3 -> {
                if (lowTexture) {
                    yield CasinoKeeper.TEXTURE_PARALLAX_3_LOW;
                }
                yield CasinoKeeper.TEXTURE_PARALLAX_3_HIGH;
            }
            case 4 -> {
                if (lowTexture) {
                    yield CasinoKeeper.TEXTURE_PARALLAX_4_LOW;
                }
                yield CasinoKeeper.TEXTURE_PARALLAX_4_HIGH;
            }
            case 5 -> {
                if (lowTexture) {
                    yield CasinoKeeper.TEXTURE_PARALLAX_5_LOW;
                }
                yield CasinoKeeper.TEXTURE_PARALLAX_5_HIGH;
            }
            default -> CasinoKeeper.TEXTURE_STATIC;
        };
    }

    protected ResourceLocation getCardsTexture(boolean noirTexture) {
        return switch (((MenuCasino)this.f_97732_).getSettingAlternateColor()) {
            case 0 -> {
                if (noirTexture) {
                    yield CasinoKeeper.TEXTURE_CARDS_0_NOIR;
                }
                yield CasinoKeeper.TEXTURE_CARDS_0_ROUGE;
            }
            case 1 -> {
                if (noirTexture) {
                    yield CasinoKeeper.TEXTURE_CARDS_1_NOIR;
                }
                yield CasinoKeeper.TEXTURE_CARDS_1_ROUGE;
            }
            case 2 -> {
                if (noirTexture) {
                    yield CasinoKeeper.TEXTURE_CARDS_2_NOIR;
                }
                yield CasinoKeeper.TEXTURE_CARDS_2_ROUGE;
            }
            case 3 -> {
                if (noirTexture) {
                    yield CasinoKeeper.TEXTURE_CARDS_3_NOIR;
                }
                yield CasinoKeeper.TEXTURE_CARDS_3_ROUGE;
            }
            case 4 -> {
                if (noirTexture) {
                    yield CasinoKeeper.TEXTURE_CARDS_4_NOIR;
                }
                yield CasinoKeeper.TEXTURE_CARDS_4_ROUGE;
            }
            case 5 -> {
                if (noirTexture) {
                    yield CasinoKeeper.TEXTURE_CARDS_5_NOIR;
                }
                yield CasinoKeeper.TEXTURE_CARDS_5_ROUGE;
            }
            default -> CasinoKeeper.TEXTURE_STATIC;
        };
    }

    protected void commandStart() {
        if (!((MenuCasino)this.f_97732_).hasToken() || this.playerToken >= ((MenuCasino)this.f_97732_).getBettingLow()) {
            if (((MenuCasino)this.f_97732_).hasToken()) {
                this.collectBet();
            }
            Random r = new Random();
            CasinoPacketHandler.sendToServer(new MessageStartServer(this.inventory.f_35978_.m_7755_().getString(), r.nextInt(1000000), ((MenuCasino)this.f_97732_).pos()));
        }
    }

    private void commandJoinGame() {
        if (((MenuCasino)this.f_97732_).logic().hasFreePlayerSlots()) {
            if (!((MenuCasino)this.f_97732_).hasToken()) {
                this.addNewPlayer();
            } else if (this.playerToken >= this.bet) {
                this.collectBet();
                this.addNewPlayer();
            }
        }
    }

    private void commandForfeit() {
        if (this.showForfeit) {
            this.turnstate(4);
            this.colour = 0;
        } else {
            this.showForfeit = true;
            this.colour = 96;
        }
    }

    private void commandReset() {
        if (this.logic().hasHighscore() && this.logic().turnstate < 7) {
            this.turnstate(7);
        } else {
            this.turnstate(0);
        }
    }

    private void commandBetDown() {
        if (this.bet > ((MenuCasino)this.f_97732_).getBettingLow()) {
            --this.bet;
        }
    }

    private void commandBetUp() {
        if (this.bet < ((MenuCasino)this.f_97732_).getBettingHigh()) {
            ++this.bet;
        }
    }

    protected void action(int action) {
        CasinoPacketHandler.sendToServer(new MessageStateServer(false, action, ((MenuCasino)this.f_97732_).pos()));
    }

    protected void turnstate(int state) {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, state, ((MenuCasino)this.f_97732_).pos()));
    }

    private void addNewPlayer() {
        CasinoPacketHandler.sendToServer(new MessageStartServer(this.inventory.f_35978_.m_7755_().getString(), -1, ((MenuCasino)this.f_97732_).pos()));
    }

    protected abstract void createGameButtons();

    protected abstract void interact(double var1, double var3, int var5);

    protected abstract void drawForegroundLayer(PoseStack var1, int var2, int var3);

    protected abstract void drawBackgroundLayer(PoseStack var1, float var2, int var3, int var4);

    protected abstract String getGameName();
}

