/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.mino.LogicMinoRed;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import mod.lucky77.util.Vector2;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ScreenMinoRed
extends ScreenCasino {
    int colorRED = 10886686;
    int colorBLACK = 0x4E4E4E;
    int colorGREEN = 46080;

    public ScreenMinoRed(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicMinoRed logic() {
        return (LogicMinoRed)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return this.tableID == 1 ? "rou_lette" : "roulette";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_BOT_MIDDLE, ButtonMap.PLACE, () -> this.isActivePlayer() && this.logic().turnstate == 2 && !this.logic().hasPlaced, () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_BOT_LEFT, ButtonMap.ANOTHER, () -> this.isActivePlayer() && this.logic().turnstate == 2 && this.logic().hasPlaced && this.playerToken >= this.bet, () -> {
            this.action(-2);
            this.collectBet();
        });
        this.buttonSet.addButton(ButtonMap.POS_BOT_RIGHT, ButtonMap.WAIT, () -> this.isActivePlayer() && this.logic().turnstate == 2 && this.logic().hasPlaced, () -> this.action(-3));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2 && !this.logic().hasPlaced) {
            for (int y = 0; y < 7; ++y) {
                for (int x = 0; x < 25; ++x) {
                    int sizeY;
                    int posX;
                    int n = posX = this.tableID == 1 ? 24 + 8 * x : -72 + 16 * x;
                    int posY = y == 6 ? 200 : (y == 5 ? 168 : 32 + 24 * y);
                    int sizeX = this.tableID == 1 ? 8 : 16;
                    int n2 = sizeY = y > 4 ? 32 : 24;
                    if (!this.mouseRect(posX, posY, sizeX, sizeY, mouseX, mouseY)) continue;
                    this.action(x + y * 25);
                }
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        if (this.logic().turnstate == 2) {
            this.drawTimer(matrix);
        }
        if (this.logic().turnstate == 5) {
            this.drawFontCenter(matrix, "" + this.logic().result, 128, 7, this.getColor(this.logic().result));
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.tableID == 1) {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_ROULETTE_MIDDLE);
        } else {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_ROULETTE_LEFT, -128);
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_ROULETTE_RIGHT, 128);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_DICE);
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 25; ++x) {
                int posY;
                int posX;
                int color = this.logic().grid[x][y];
                int n = posX = this.tableID == 1 ? 16 + 8 * x : -72 + 16 * x;
                int n2 = y == 6 ? 200 : (posY = y == 5 ? 168 : 32 + 24 * y);
                if (color == -1) {
                    ScreenMinoRed.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)224, (int)224, (int)32, (int)32);
                }
                if (color > 0) {
                    ScreenMinoRed.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)192, (int)(32 * (color % 10)), (int)32, (int)32);
                }
                if (!this.logic().selector.matches(x, y)) continue;
                ScreenMinoRed.m_93228_((PoseStack)matrix, (int)(this.f_97735_ + posX), (int)(this.f_97736_ + posY), (int)224, (int)0, (int)32, (int)32);
            }
        }
        if (this.logic().turnstate == 3) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_ROULETTE_WHEEL);
            ScreenMinoRed.m_93228_((PoseStack)matrix, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_MINOS);
            Vector2 v = this.logic().vectorWheel();
            this.drawMinoSmall(matrix, v.X, v.Y, 15, false);
        }
    }

    private int getColor(int value) {
        if (value == 0) {
            return this.colorGREEN;
        }
        if (value == 1) {
            return this.colorRED;
        }
        if (value == 3) {
            return this.colorRED;
        }
        if (value == 5) {
            return this.colorRED;
        }
        if (value == 7) {
            return this.colorRED;
        }
        if (value == 9) {
            return this.colorRED;
        }
        if (value == 12) {
            return this.colorRED;
        }
        if (value == 14) {
            return this.colorRED;
        }
        if (value == 16) {
            return this.colorRED;
        }
        if (value == 18) {
            return this.colorRED;
        }
        if (value == 19) {
            return this.colorRED;
        }
        if (value == 21) {
            return this.colorRED;
        }
        if (value == 23) {
            return this.colorRED;
        }
        if (value == 25) {
            return this.colorRED;
        }
        if (value == 27) {
            return this.colorRED;
        }
        if (value == 30) {
            return this.colorRED;
        }
        if (value == 32) {
            return this.colorRED;
        }
        if (value == 34) {
            return this.colorRED;
        }
        if (value == 36) {
            return this.colorRED;
        }
        return this.colorBLACK;
    }
}

