/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles;

import com.mojang.datafixers.DSL;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import team.creative.littletiles.common.block.entity.BESignalConverter;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.entity.BETilesRendered;
import team.creative.littletiles.common.block.mc.BlockArrow;
import team.creative.littletiles.common.block.mc.BlockFlowingLava;
import team.creative.littletiles.common.block.mc.BlockFlowingWater;
import team.creative.littletiles.common.block.mc.BlockLava;
import team.creative.littletiles.common.block.mc.BlockSignalConverter;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.block.mc.BlockWater;
import team.creative.littletiles.common.entity.EntitySit;
import team.creative.littletiles.common.entity.PrimedSizedTnt;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.level.LittleLevelEntity;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleBag;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.item.ItemLittleChisel;
import team.creative.littletiles.common.item.ItemLittleGlove;
import team.creative.littletiles.common.item.ItemLittleHammer;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.item.ItemLittleSaw;
import team.creative.littletiles.common.item.ItemLittleScrewdriver;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.ItemPremadeStructure;

public class LittleTilesRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"littletiles");
    public static final RegistryObject<Item> HAMMER = ITEMS.register("hammer", () -> new ItemLittleHammer());
    public static final RegistryObject<Item> BLUEPRINT = ITEMS.register("blueprint", () -> new ItemLittleBlueprint());
    public static final RegistryObject<Item> ITEM_TILES = ITEMS.register("multi_tiles", () -> new ItemMultiTiles());
    public static final RegistryObject<Item> SAW = ITEMS.register("saw", () -> new ItemLittleSaw());
    public static final RegistryObject<Item> BAG = ITEMS.register("bag", () -> new ItemLittleBag());
    public static final RegistryObject<Item> WRENCH = ITEMS.register("wrench", () -> new ItemLittleWrench());
    public static final RegistryObject<Item> SCREWDRIVER = ITEMS.register("screwdriver", () -> new ItemLittleScrewdriver());
    public static final RegistryObject<Item> CHISEL = ITEMS.register("chisel", () -> new ItemLittleChisel());
    public static final RegistryObject<Item> PAINT_BRUSH = ITEMS.register("paint_brush", () -> new ItemLittlePaintBrush());
    public static final RegistryObject<Item> GLOVE = ITEMS.register("glove", () -> new ItemLittleGlove());
    public static final RegistryObject<Item> PREMADE = ITEMS.register("premade", () -> new ItemPremadeStructure());
    public static final RegistryObject<Item> BLOCK_INGREDIENT = ITEMS.register("blockingredient", () -> new ItemBlockIngredient());
    public static final RegistryObject<Item> BLACK_COLOR = ITEMS.register("bottle_black", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.black));
    public static final RegistryObject<Item> CYAN_COLOR = ITEMS.register("bottle_cyan", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.cyan));
    public static final RegistryObject<Item> MAGENTA_COLOR = ITEMS.register("bottle_magenta", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.magenta));
    public static final RegistryObject<Item> YELLOW_COLOR = ITEMS.register("bottle_yellow", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.yellow));
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"littletiles");
    public static final RegistryObject<Block> BLOCK_TILES = BLOCKS.register("tiles", () -> new BlockTile(Material.f_76278_, false, false));
    public static final RegistryObject<Block> BLOCK_TILES_TICKING = BLOCKS.register("tiles_ticking", () -> new BlockTile(Material.f_76278_, true, false));
    public static final RegistryObject<Block> BLOCK_TILES_RENDERED = BLOCKS.register("tiles_rendered", () -> new BlockTile(Material.f_76278_, false, true));
    public static final RegistryObject<Block> BLOCK_TILES_TICKING_RENDERED = BLOCKS.register("tiles_ticking_rendered", () -> new BlockTile(Material.f_76278_, true, true));
    public static final RegistryObject<Block> CLEAN = LittleTilesRegistry.register("colored_clean", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> FLOOR = LittleTilesRegistry.register("colored_floor", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> GRAINY_BIG = LittleTilesRegistry.register("colored_grainy_big", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> GRAINY = LittleTilesRegistry.register("colored_grainy", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> GRAINY_LOW = LittleTilesRegistry.register("colored_grainy_low", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> BRICK = LittleTilesRegistry.register("colored_brick", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> BRICK_BIG = LittleTilesRegistry.register("colored_brick_big", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> BORDERED = LittleTilesRegistry.register("colored_bordered", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> CHISELED = LittleTilesRegistry.register("colored_chiseled", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> BROKEN_BRICK_BIG = LittleTilesRegistry.register("colored_broken_brick_big", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> CLAY = LittleTilesRegistry.register("colored_clay", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> STRIPS = LittleTilesRegistry.register("colored_strips", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> GRAVEL = LittleTilesRegistry.register("colored_gravel", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> SAND = LittleTilesRegistry.register("colored_sand", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> STONE = LittleTilesRegistry.register("colored_stone", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> CORK = LittleTilesRegistry.register("colored_cork", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_)));
    public static final RegistryObject<Block> WATER = LittleTilesRegistry.register("colored_water", () -> new BlockWater(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60910_()));
    public static final RegistryObject<Block> WHITE_WATER = LittleTilesRegistry.register("colored_white_water", () -> new BlockWater(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60910_()));
    public static final RegistryObject<Block> LAVA = LittleTilesRegistry.register("colored_lava", () -> new BlockLava(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60910_()));
    public static final RegistryObject<Block> WHITE_LAVA = LittleTilesRegistry.register("colored_white_lava", () -> new BlockLava(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76406_).m_60910_().m_60953_(x -> 15)));
    public static final RegistryObject<Block> STORAGE_BLOCK = LittleTilesRegistry.register("storage", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155954_(1.5f).m_60978_(1.5f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> FLOWING_WATER = BLOCKS.register("colored_water_flowing", () -> new BlockFlowingWater((Block)WATER.get()));
    public static final RegistryObject<Block> WHITE_FLOWING_WATER = BLOCKS.register("colored_white_water_flowing", () -> new BlockFlowingWater((Block)WHITE_WATER.get()));
    public static final RegistryObject<Block> FLOWING_LAVA = BLOCKS.register("colored_lava_flowing", () -> new BlockFlowingLava((Block)LAVA.get()));
    public static final RegistryObject<Block> WHITE_FLOWING_LAVA = BLOCKS.register("colored_white_lava_flowing", () -> new BlockFlowingLava((Block)WHITE_LAVA.get()));
    public static final RegistryObject<Block> SINGLE_CABLE = BLOCKS.register("cable_single", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_)));
    public static final RegistryObject<Block> INPUT_ARROW = BLOCKS.register("arrow_input", () -> new BlockArrow());
    public static final RegistryObject<Block> OUTPUT_ARROW = BLOCKS.register("arrow_output", () -> new BlockArrow());
    public static final RegistryObject<Block> SIGNAL_CONVERTER = LittleTilesRegistry.register("signal_converter", () -> new BlockSignalConverter());
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"littletiles");
    public static final RegistryObject<BlockEntityType<BETiles>> BE_TILES_TYPE = LittleTilesRegistry.registerBlockEntity("tiles", () -> BlockEntityType.Builder.m_155273_(BETiles::new, (Block[])new Block[]{(Block)BLOCK_TILES.get(), (Block)BLOCK_TILES_TICKING.get()}));
    public static final RegistryObject<BlockEntityType<BETilesRendered>> BE_TILES_TYPE_RENDERED = LittleTilesRegistry.registerBlockEntity("tiles_rendered", () -> BlockEntityType.Builder.m_155273_(BETilesRendered::new, (Block[])new Block[]{(Block)BLOCK_TILES_RENDERED.get(), (Block)BLOCK_TILES_TICKING_RENDERED.get()}));
    public static final RegistryObject<BlockEntityType<BESignalConverter>> BE_SIGNALCONVERTER_TYPE = LittleTilesRegistry.registerBlockEntity("converter", () -> BlockEntityType.Builder.m_155273_(BESignalConverter::new, (Block[])new Block[]{(Block)SIGNAL_CONVERTER.get()}));
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"littletiles");
    public static final RegistryObject<EntityType<PrimedSizedTnt>> SIZED_TNT_TYPE = ENTITIES.register("primed_size_tnt", () -> EntityType.Builder.m_20704_(PrimedSizedTnt::new, (MobCategory)MobCategory.MISC).m_20712_("primed_size_tnt"));
    public static final RegistryObject<EntityType<EntitySit>> SIT_TYPE = ENTITIES.register("sit", () -> EntityType.Builder.m_20704_(EntitySit::new, (MobCategory)MobCategory.MISC).m_20712_("sit"));
    public static final RegistryObject<EntityType<LittleAnimationEntity>> ENTITY_ANIMATION = ENTITIES.register("litte_animation", () -> EntityType.Builder.m_20704_(LittleAnimationEntity::new, (MobCategory)MobCategory.MISC).m_20712_("litte_animation"));
    public static final RegistryObject<EntityType<LittleLevelEntity>> ENTITY_LEVEL = ENTITIES.register("little_level", () -> EntityType.Builder.m_20704_(LittleLevelEntity::new, (MobCategory)MobCategory.MISC).m_20712_("little_level"));
    public static final ResourceKey FAKE_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("littletiles", "fake"));

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        RegistryObject ret = BLOCKS.register(name, sup);
        ITEMS.register(name, () -> new BlockItem((Block)ret.get(), new Item.Properties()));
        return ret;
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntity(String name, Supplier<BlockEntityType.Builder<T>> sup) {
        return BLOCK_ENTITIES.register(name, () -> ((BlockEntityType.Builder)sup.get()).m_58966_(Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)name)));
    }
}

