/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.api.common.tool;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;

public interface ILittlePlacer
extends ILittleTool {
    public boolean hasTiles(ItemStack var1);

    public LittleGroup getTiles(ItemStack var1);

    public LittleGroup getLow(ItemStack var1);

    default public LittleGroup get(ItemStack stack, boolean low) {
        if (low) {
            return this.getLow(stack);
        }
        return this.getTiles(stack);
    }

    public PlacementPreview getPlacement(Level var1, ItemStack var2, PlacementPosition var3, boolean var4);

    public void saveTiles(ItemStack var1, LittleGroup var2);

    @Override
    default public void rotate(Player player, ItemStack stack, Rotation rotation, boolean client) {
        LittleGroup group = this.getTiles(stack);
        if (group == null || group.isEmpty()) {
            return;
        }
        group.rotate(rotation, group.getGrid().rotationCenter);
        this.saveTiles(stack, group);
    }

    @Override
    default public void mirror(Player player, ItemStack stack, Axis axis, boolean client) {
        LittleGroup group = this.getTiles(stack);
        if (group == null || group.isEmpty()) {
            return;
        }
        group.mirror(axis, group.getGrid().rotationCenter);
        this.saveTiles(stack, group);
    }

    default public LittleGrid getTilesGrid(ItemStack stack) {
        if (stack.m_41782_()) {
            return LittleGrid.get(stack.m_41783_());
        }
        return LittleGrid.defaultGrid();
    }

    public boolean containsIngredients(ItemStack var1);

    @OnlyIn(value=Dist.CLIENT)
    default public float getPreviewAlphaFactor() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean shouldCache() {
        return true;
    }

    default public PlacementMode getPlacementMode(ItemStack stack) {
        if (stack.m_41782_()) {
            return PlacementMode.getMode(stack.m_41783_().m_128461_("mode"));
        }
        return PlacementMode.getDefault();
    }

    default public boolean canSnapToGrid(ItemStack stack) {
        return true;
    }

    default public boolean snapToGridByDefault(ItemStack stack) {
        return false;
    }

    default public LittleVec getCachedSize(ItemStack stack) {
        return null;
    }

    default public LittleVec getCachedMin(ItemStack stack) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public List<RenderBox> getPositingCubes(Level level, BlockPos pos, ItemStack stack) {
        LittleStructureType type;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("structure") && (type = (LittleStructureType)LittleStructureRegistry.REGISTRY.get(stack.m_41783_().m_128469_("structure").m_128461_("id"))) != null) {
            return type.getPositingCubes(level, pos, stack);
        }
        return null;
    }
}

