/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.level.little;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.ClientLevelExtender;
import team.creative.littletiles.client.level.little.LittleClientChunkCache;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.entity.LittleLevelRenderManager;
import team.creative.littletiles.common.level.little.LevelBlockChangeListener;
import team.creative.littletiles.common.level.little.LittleLevel;

@OnlyIn(value=Dist.CLIENT)
public abstract class LittleClientLevel
extends ClientLevel
implements LittleLevel {
    public Entity holder;
    public IVecOrigin origin;
    public boolean preventNeighborUpdate = false;
    private RegistryAccess access;
    public LittleLevelRenderManager renderManager;
    private final List<LevelBlockChangeListener> blockChangeListeners = new ArrayList<LevelBlockChangeListener>();

    protected LittleClientLevel(ClientLevel.ClientLevelData data, ResourceKey<Level> dimension, Supplier<ProfilerFiller> supplier, boolean debug, long seed, RegistryAccess access) {
        super((ClientPacketListener)FakeClientPacketListener.get(access), data, dimension, (Holder)access.m_175515_(Registries.f_256787_).m_246971_(LittleTilesRegistry.FAKE_DIMENSION), 3, 3, supplier, null, debug, seed);
        this.access = access;
    }

    @Override
    public void removeEntityById(int id, Entity.RemovalReason reason) {
        this.m_171642_(id, reason);
    }

    public void m_5503_(Packet packet) {
        LittleTilesClient.PLAYER_CONNECTION.send(this, packet);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return this.renderManager;
    }

    public abstract RecipeManager m_7465_();

    public abstract FeatureFlagSet m_246046_();

    public LevelEntityGetter<Entity> m_142646_() {
        return super.m_142646_();
    }

    public void m_7462_() {
        Minecraft.m_91087_().f_91073_.m_7462_();
    }

    @Override
    public void registerBlockChangeListener(LevelBlockChangeListener listener) {
        this.blockChangeListeners.add(listener);
    }

    public void m_7260_(BlockPos pos, BlockState actualState, BlockState setState, int p_104688_) {
        this.renderManager.blockChanged((BlockGetter)this, pos, actualState, setState, p_104688_);
    }

    public void m_6550_(BlockPos pos, BlockState actualState, BlockState setState) {
        this.renderManager.setBlockDirty(pos, actualState, setState);
        this.blockChangeListeners.forEach(x -> x.blockChanged(pos, setState));
    }

    public void m_104793_(int x, int y, int z) {
        this.renderManager.setSectionDirtyWithNeighbors(x, y, z);
    }

    public void setSectionDirty(int x, int y, int z) {
        this.renderManager.setSectionDirty(x, y, z);
    }

    public void m_197405_(int x, int z) {
        LevelChunk levelchunk = this.getChunkSource().m_62227_(x, z, false);
        if (levelchunk != null) {
            levelchunk.m_196864_(true);
        }
    }

    public TransientEntitySectionManager<Entity> getEStorage() {
        return ((ClientLevelExtender)((Object)this)).getEntityStorage();
    }

    public void onChunkLoaded(LevelChunk chunk) {
        this.getEStorage().m_157651_(chunk.m_7697_());
        chunk.m_196864_(true);
        LevelChunkSection[] section = chunk.m_7103_();
        for (int i = 0; i < section.length; ++i) {
            if (section[i].m_188008_()) continue;
            this.renderManager.setSectionDirty(chunk.m_7697_().f_45578_, chunk.m_151568_(i), chunk.m_7697_().f_45579_);
        }
    }

    @Override
    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(Entity entity) {
        this.holder = entity;
    }

    public void m_46586_(BlockPos pos, Block block, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.f_46443_) {
            BlockState blockstate = this.m_8055_(pos);
            try {
                blockstate.m_60690_((Level)this, pos, block, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being updated");
                crashreportcategory.m_128165_("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", BuiltInRegistries.f_256975_.m_7981_((Object)block), block.m_7705_(), block.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + BuiltInRegistries.f_256975_.m_7981_((Object)block);
                    }
                });
                CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)this, (BlockPos)pos, (BlockState)blockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.m_46586_(pos, block, fromPos);
        }
    }

    public void m_46590_(BlockPos pos, Block block, Direction facing) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46590_(pos, block, facing);
    }

    public void m_46672_(BlockPos pos, Block block) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46672_(pos, block);
    }

    public LittleClientChunkCache getChunkSource() {
        return (LittleClientChunkCache)super.m_7726_();
    }

    public void m_104665_(LevelChunk chunk) {
        chunk.m_187957_();
        this.getChunkSource().m_7827_().m_6460_(chunk.m_7697_(), false);
    }

    @Override
    public void unload() {
        if (this.renderManager != null) {
            this.renderManager.unload();
        }
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int id, BlockPos pos, int progress) {
        this.renderManager.destroyBlockProgress(id, pos, progress);
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public void m_214171_(GameEvent event, Vec3 pos, GameEvent.Context context) {
    }

    @Override
    public Iterable<Entity> entities() {
        return this.m_142646_().m_142273_();
    }

    public RegistryAccess m_9598_() {
        return this.access;
    }

    @Override
    public Iterable<? extends ChunkAccess> chunks() {
        return this.getChunkSource().all();
    }

    @Override
    public void tick() {
        this.m_46463_();
    }

    private static class FakeClientPacketListener
    extends ClientPacketListener {
        private static final FakeClientPacketListener INSTANCE = (FakeClientPacketListener)((Object)CreativeHackery.allocateInstance(FakeClientPacketListener.class));
        private RegistryAccess access;

        public static FakeClientPacketListener get(RegistryAccess access) {
            FakeClientPacketListener.INSTANCE.access = access;
            return INSTANCE;
        }

        public FakeClientPacketListener(Minecraft p_253924_, Screen p_254239_, Connection p_253614_, ServerData p_254072_, GameProfile p_254079_, WorldSessionTelemetryManager p_262115_) {
            super(p_253924_, p_254239_, p_253614_, p_254072_, p_254079_, p_262115_);
        }

        public RegistryAccess m_105152_() {
            return this.access;
        }
    }
}

