/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.level.RenderUploader;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;

public class ChunkLayerUploadManager {
    private final VertexBuffer buffer;
    private ChunkLayerCache cache;
    private ChunkLayerCache uploaded;
    public int queued;

    public ChunkLayerUploadManager(RenderChunkExtender chunk, RenderType layer) {
        this.buffer = chunk.getVertexBuffer(layer);
        ((VertexBufferExtender)this.buffer).setManager(this);
    }

    public ChunkLayerCache get() {
        return this.cache;
    }

    public synchronized void set(ChunkLayerCache cache) {
        if (this.cache != null) {
            this.cache.discard();
        }
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploaded() {
        ChunkLayerUploadManager chunkLayerUploadManager = this;
        synchronized (chunkLayerUploadManager) {
            if (this.uploaded != null) {
                this.backToRAM();
            }
            this.uploaded = this.cache;
            this.cache = null;
            if (this.uploaded != null) {
                this.uploaded.uploaded(this.queued == 0);
            }
        }
    }

    public void backToRAM() {
        if (this.uploaded == null) {
            return;
        }
        Supplier<Boolean> run = () -> {
            ChunkLayerUploadManager chunkLayerUploadManager = this;
            synchronized (chunkLayerUploadManager) {
                if (Minecraft.m_91087_().f_91073_ == null || this.uploaded == null || ((VertexBufferExtender)this.buffer).getVertexBufferId() == -1) {
                    if (this.uploaded != null) {
                        this.uploaded.discard();
                    }
                    this.uploaded = null;
                    return false;
                }
                GlStateManager.m_84480_((int)34962, (int)((VertexBufferExtender)this.buffer).getVertexBufferId());
                try {
                    ByteBuffer uploadedData = RenderUploader.glMapBufferRange(this.uploaded.totalSize());
                    if (uploadedData != null) {
                        this.uploaded.download(uploadedData);
                    } else {
                        this.uploaded.discard();
                    }
                    this.uploaded = null;
                }
                catch (RenderUploader.NotSupportedException e) {
                    e.printStackTrace();
                }
                VertexBuffer.m_85931_();
                return true;
            }
        };
        try {
            if (Minecraft.m_91087_().m_18695_()) {
                run.get();
            } else {
                CompletableFuture future = Minecraft.m_91087_().m_18691_(run);
                future.get();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

