/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.entity;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.level.LittleChunkDispatcher;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;

@OnlyIn(value=Dist.CLIENT)
public class LittleAnimationRenderManager
extends LittleEntityRenderManager<LittleAnimationEntity>
implements RenderChunkExtender {
    private final ChunkLayerMap<VertexBuffer> buffers = new ChunkLayerMap();
    private final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.m_110506_().size());
    private List<BlockEntity> renderableBlockEntities = new ArrayList<BlockEntity>();
    private BufferBuilder.SortState transparencyState;
    private boolean needsUpdate = false;

    public LittleAnimationRenderManager(LittleAnimationEntity entity) {
        super(entity);
    }

    @Override
    public RenderChunkExtender getRenderChunk(BlockPos pos) {
        return this;
    }

    @Override
    public LittleAnimationLevel getLevel() {
        return (LittleAnimationLevel)super.getLevel();
    }

    @Override
    public boolean dynamicLightUpdate() {
        return false;
    }

    @Override
    public void dynamicLightUpdate(boolean value) {
    }

    @Override
    public void begin(BufferBuilder builder) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        VertexBuffer buffer = (VertexBuffer)this.buffers.get(layer);
        if (buffer == null) {
            buffer = new VertexBuffer();
            this.buffers.put(layer, (Object)buffer);
        }
        return buffer;
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void compileChunks(Camera camera) {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.hasBlocks.clear();
            this.renderableBlockEntities.clear();
            RebuildTask rebuild = new RebuildTask();
            Vec3 cam = camera.m_90583_();
            CompileResults results = rebuild.compile((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_, LittleTilesClient.ANIMATION_HANDLER.fixedBuffers);
            this.globalBlockEntities.clear();
            this.globalBlockEntities.addAll(results.globalBlockEntities);
            this.renderableBlockEntities = results.blockEntities;
            this.transparencyState = results.transparencyState;
            results.renderedLayers.forEach((layer, rendered) -> {
                VertexBuffer buffer = this.getVertexBuffer((RenderType)layer);
                if (!buffer.m_231230_()) {
                    buffer.m_85921_();
                    buffer.m_231221_(rendered);
                    VertexBuffer.m_85931_();
                }
                this.hasBlocks.add((RenderType)layer);
            });
            this.hasBlocks.addAll(results.renderedLayers.keySet());
        }
    }

    @Override
    protected void renderAllBlockEntities(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        if (this.renderableBlockEntities != null) {
            for (BlockEntity blockEntity : this.renderableBlockEntities) {
                this.renderBlockEntity(blockEntity, pose, frustum, cam, frameTime, bufferSource);
            }
        }
    }

    @Override
    public void prepareBlockTranslation(PoseStack posestack, BlockPos pos) {
        posestack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
    }

    @Override
    public Vec3i standardOffset() {
        return Vec3i.f_123288_;
    }

    @Override
    public BufferBuilder.SortState getTransparencyState() {
        return this.transparencyState;
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return !this.hasBlocks.contains(layer);
    }

    @Override
    public void setHasBlock(RenderType layer) {
        this.hasBlocks.add(layer);
    }

    @Override
    public void setQuadSortOrigin(BufferBuilder builder, Vec3 camera) {
        builder.m_166771_((float)camera.f_82479_, (float)camera.f_82480_, (float)camera.f_82481_);
    }

    @Override
    public void resortTransparency(RenderType layer, double x, double y, double z) {
        if (this.transparencyState != null && this.hasBlocks.contains(RenderType.m_110466_())) {
            BufferBuilder bufferbuilder = LittleTilesClient.ANIMATION_HANDLER.fixedBuffers.m_108839_(RenderType.m_110466_());
            this.begin(bufferbuilder);
            bufferbuilder.m_166775_(this.transparencyState);
            bufferbuilder.m_166771_((float)x, (float)y, (float)z);
            this.transparencyState = bufferbuilder.m_166770_();
            BufferBuilder.RenderedBuffer rendered = bufferbuilder.m_231175_();
            VertexBuffer buffer = this.getVertexBuffer(layer);
            if (!buffer.m_231230_()) {
                buffer.m_85921_();
                buffer.m_231221_(rendered);
                VertexBuffer.m_85931_();
            }
        }
    }

    @Override
    public void renderChunkLayer(RenderType layer, PoseStack pose, double x, double y, double z, Matrix4f projectionMatrix, Uniform offset) {
        if (this.hasBlocks.contains(layer)) {
            VertexBuffer vertexbuffer = (VertexBuffer)this.buffers.get(layer);
            if (vertexbuffer == null) {
                return;
            }
            if (offset != null) {
                offset.m_5889_((float)(-x), (float)(-y), (float)(-z));
                offset.m_85633_();
            }
            vertexbuffer.m_85921_();
            vertexbuffer.m_166882_();
        }
        if (offset != null) {
            offset.m_5889_(0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    protected void setSectionDirty(int x, int y, int z, boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void unload() {
        super.unload();
        this.buffers.forEach(VertexBuffer::close);
    }

    private class RebuildTask
    implements RebuildTaskExtender {
        private ChunkLayerMap<ChunkLayerCache> caches;
        private ChunkBufferBuilderPack pack;
        private Set<RenderType> renderTypes;

        private RebuildTask() {
        }

        private CompileResults compile(float x, float y, float z, ChunkBufferBuilderPack pack) {
            BufferBuilder builder;
            this.pack = pack;
            CompileResults results = new CompileResults();
            LittleChunkDispatcher.startCompile(LittleAnimationRenderManager.this);
            this.renderTypes = new ReferenceArraySet(RenderType.m_110506_().size());
            for (BETiles block : LittleAnimationRenderManager.this.getLevel()) {
                this.handleBlockEntity(results, block);
            }
            if (this.renderTypes.contains(RenderType.m_110466_()) && !(builder = pack.m_108839_(RenderType.m_110466_())).m_231164_()) {
                builder.m_166771_(x, y, z);
                results.transparencyState = builder.m_166770_();
            }
            for (RenderType layer : this.renderTypes) {
                BufferBuilder.RenderedBuffer rendered = pack.m_108839_(layer).m_231168_();
                if (rendered == null) continue;
                results.renderedLayers.put(layer, rendered);
            }
            LittleChunkDispatcher.endCompile(LittleAnimationRenderManager.this, this);
            return results;
        }

        private void handleBlockEntity(CompileResults results, BETiles entity) {
            LittleChunkDispatcher.add(LittleAnimationRenderManager.this, entity, this);
            BlockEntityRenderer blockentityrenderer = Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)entity);
            if (blockentityrenderer != null) {
                if (blockentityrenderer.m_5932_((BlockEntity)entity)) {
                    results.globalBlockEntities.add((BlockEntity)entity);
                } else {
                    results.blockEntities.add((BlockEntity)entity);
                }
            }
        }

        @Override
        public BufferBuilder builder(RenderType layer) {
            BufferBuilder builder = this.pack.m_108839_(layer);
            if (this.renderTypes.add(layer)) {
                LittleAnimationRenderManager.this.begin(builder);
            }
            return builder;
        }

        @Override
        public ChunkLayerMap<ChunkLayerCache> getLayeredCache() {
            return this.caches;
        }

        @Override
        public ChunkLayerCache getOrCreate(RenderType layer) {
            ChunkLayerCache cache;
            if (this.caches == null) {
                this.caches = new ChunkLayerMap();
            }
            if ((cache = (ChunkLayerCache)this.caches.get(layer)) == null) {
                cache = new ChunkLayerCache();
                this.caches.put(layer, (Object)cache);
            }
            return cache;
        }

        @Override
        public void clear() {
            this.pack = null;
            this.renderTypes = null;
        }
    }

    static final class CompileResults {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Map<RenderType, BufferBuilder.RenderedBuffer> renderedLayers = new Reference2ObjectArrayMap();
        @Nullable
        public BufferBuilder.SortState transparencyState;

        CompileResults() {
        }

        public boolean isEmpty() {
            return this.renderedLayers.isEmpty() && this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
        }
    }
}

