/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.entity;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import org.joml.Matrix4f;
import team.creative.littletiles.client.render.entity.LittleEntityRenderer;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.little.LittleSubLevel;

@OnlyIn(value=Dist.CLIENT)
public abstract class LittleEntityRenderManager<T extends LittleEntity> {
    public static final Minecraft mc = Minecraft.m_91087_();
    public Boolean isInSight;
    public boolean needsFullRenderChunkUpdate = false;
    protected final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
    private final Int2ObjectMap<BlockDestructionProgress> destroyingBlocks = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = new Long2ObjectOpenHashMap();
    private int ticks;
    public final T entity;

    public LittleEntityRenderManager(T entity) {
        this.entity = entity;
    }

    public LittleSubLevel getLevel() {
        return ((LittleEntity)this.entity).getSubLevel();
    }

    public abstract RenderChunkExtender getRenderChunk(BlockPos var1);

    public void setupRender(Camera camera, @Nullable Frustum frustum, boolean capturedFrustum, boolean spectator) {
        Vec3 cam = camera.m_90583_();
        this.isInSight = frustum != null ? Boolean.valueOf(LittleEntityRenderer.isVisible(this.entity, frustum, cam.f_82479_, cam.f_82480_, cam.f_82481_)) : Boolean.valueOf(true);
    }

    public void unload() {
        this.globalBlockEntities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allChanged() {
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            this.globalBlockEntities.clear();
        }
    }

    public Iterable<Long2ObjectMap.Entry<SortedSet<BlockDestructionProgress>>> getDestructions() {
        return this.destructionProgress.long2ObjectEntrySet();
    }

    public SortedSet<BlockDestructionProgress> getDestructionProgress(BlockPos pos) {
        return (SortedSet)this.destructionProgress.get(pos.m_121878_());
    }

    public void clientTick() {
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            ObjectIterator iterator = this.destroyingBlocks.values().iterator();
            while (iterator.hasNext()) {
                BlockDestructionProgress destruction = (BlockDestructionProgress)iterator.next();
                int i = destruction.m_139991_();
                if (this.ticks - i <= 400) continue;
                iterator.remove();
                this.removeProgress(destruction);
            }
        }
    }

    public void destroyBlockProgress(int id, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            BlockDestructionProgress destruction = (BlockDestructionProgress)this.destroyingBlocks.get(id);
            if (destruction != null) {
                this.removeProgress(destruction);
            }
            if (destruction == null || !destruction.m_139985_().equals((Object)pos)) {
                destruction = new BlockDestructionProgress(id, pos);
                this.destroyingBlocks.put(id, (Object)destruction);
            }
            destruction.m_139981_(progress);
            destruction.m_139986_(this.ticks);
            ((SortedSet)this.destructionProgress.computeIfAbsent(destruction.m_139985_().m_121878_(), x -> Sets.newTreeSet())).add(destruction);
        } else {
            BlockDestructionProgress destruction = (BlockDestructionProgress)this.destroyingBlocks.remove(id);
            if (destruction != null) {
                this.removeProgress(destruction);
            }
        }
    }

    private void removeProgress(BlockDestructionProgress destruction) {
        long i = destruction.m_139985_().m_121878_();
        Set set = (Set)this.destructionProgress.get(i);
        set.remove(destruction);
        if (set.isEmpty()) {
            this.destructionProgress.remove(i);
        }
    }

    public abstract void compileChunks(Camera var1);

    protected MultiBufferSource prepareBlockEntity(PoseStack pose, LittleSubLevel level, BlockPos pos, MultiBufferSource bufferSource) {
        int j1;
        SortedSet<BlockDestructionProgress> sortedset = this.getDestructionProgress(pos);
        MultiBufferSource newSource = bufferSource;
        if (sortedset != null && !sortedset.isEmpty() && (j1 = sortedset.last().m_139988_()) >= 0) {
            PoseStack.Pose posestack$pose1 = pose.m_85850_();
            SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(mc.m_91269_().m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(j1)), posestack$pose1.m_252922_(), posestack$pose1.m_252943_(), 1.0f);
            newSource = arg_0 -> LittleEntityRenderManager.lambda$prepareBlockEntity$1((VertexConsumer)vertexconsumer, bufferSource, arg_0);
        }
        return newSource;
    }

    protected abstract void renderAllBlockEntities(PoseStack var1, Frustum var2, Vec3 var3, float var4, MultiBufferSource var5);

    protected void renderBlockEntity(BlockEntity blockentity, PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        if (!frustum.m_113029_(blockentity.getRenderBoundingBox())) {
            return;
        }
        BlockPos blockpos4 = blockentity.m_58899_();
        pose.m_85836_();
        pose.m_85837_((double)blockpos4.m_123341_() - cam.f_82479_, (double)blockpos4.m_123342_() - cam.f_82480_, (double)blockpos4.m_123343_() - cam.f_82481_);
        mc.m_167982_().m_112267_(blockentity, frameTime, pose, this.prepareBlockEntity(pose, this.getLevel(), blockpos4, bufferSource));
        pose.m_85849_();
    }

    public void renderBlockEntitiesAndDestruction(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        pose.m_85836_();
        ((LittleEntity)this.entity).getOrigin().setupRendering(pose, cam.f_82479_, cam.f_82480_, cam.f_82481_, frameTime);
        this.renderAllBlockEntities(pose, frustum, cam, frameTime, bufferSource);
        LittleSubLevel level = ((LittleEntity)this.entity).getSubLevel();
        for (Long2ObjectMap.Entry<SortedSet<BlockDestructionProgress>> entry : this.getDestructions()) {
            SortedSet sortedset1;
            double d5;
            double d4;
            BlockPos blockpos2 = BlockPos.m_122022_((long)entry.getLongKey());
            double d3 = (double)blockpos2.m_123341_() - cam.f_82479_;
            if (d3 * d3 + (d4 = (double)blockpos2.m_123342_() - cam.f_82480_) * d4 + (d5 = (double)blockpos2.m_123343_() - cam.f_82481_) * d5 > 1024.0 || (sortedset1 = (SortedSet)entry.getValue()) == null || sortedset1.isEmpty()) continue;
            int k1 = ((BlockDestructionProgress)sortedset1.last()).m_139988_();
            pose.m_85836_();
            pose.m_85837_((double)blockpos2.m_123341_() - cam.f_82479_, (double)blockpos2.m_123342_() - cam.f_82480_, (double)blockpos2.m_123343_() - cam.f_82481_);
            PoseStack.Pose last = pose.m_85850_();
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(mc.m_91269_().m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(k1)), last.m_252922_(), last.m_252943_(), 1.0f);
            ModelDataManager manager = level.getModelDataManager();
            ModelData modelData = null;
            if (manager != null) {
                modelData = manager.getAt(blockpos2);
            }
            mc.m_91289_().renderBreakingTexture(level.m_8055_(blockpos2), blockpos2, (BlockAndTintGetter)level, pose, (VertexConsumer)consumer, modelData == null ? ModelData.EMPTY : modelData);
            pose.m_85849_();
        }
        pose.m_85849_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderGlobalEntities(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            if (this.globalBlockEntities.isEmpty()) {
                return;
            }
            pose.m_85836_();
            ((LittleEntity)this.entity).getOrigin().setupRendering(pose, cam.f_82479_, cam.f_82480_, cam.f_82481_, frameTime);
            for (BlockEntity blockEntity : this.globalBlockEntities) {
                this.renderBlockEntity(blockEntity, pose, frustum, cam, frameTime, bufferSource);
            }
            pose.m_85849_();
        }
    }

    public abstract void resortTransparency(RenderType var1, double var2, double var4, double var6);

    public abstract void renderChunkLayer(RenderType var1, PoseStack var2, double var3, double var5, double var7, Matrix4f var9, Uniform var10);

    public void blockChanged(BlockGetter level, BlockPos pos, BlockState actualState, BlockState setState, int updateType) {
        this.setBlockDirty(pos, (updateType & 8) != 0);
    }

    private void setBlockDirty(BlockPos pos, boolean playerChanged) {
        for (int i = pos.m_123343_() - 1; i <= pos.m_123343_() + 1; ++i) {
            for (int j = pos.m_123341_() - 1; j <= pos.m_123341_() + 1; ++j) {
                for (int k = pos.m_123342_() - 1; k <= pos.m_123342_() + 1; ++k) {
                    this.setSectionDirty(SectionPos.m_123171_((int)j), SectionPos.m_123171_((int)k), SectionPos.m_123171_((int)i), playerChanged);
                }
            }
        }
    }

    public void setBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = minZ - 1; i <= maxZ + 1; ++i) {
            for (int j = minX - 1; j <= maxX + 1; ++j) {
                for (int k = minY - 1; k <= maxY + 1; ++k) {
                    this.setSectionDirty(SectionPos.m_123171_((int)j), SectionPos.m_123171_((int)k), SectionPos.m_123171_((int)i));
                }
            }
        }
    }

    public void setBlockDirty(BlockPos pos, BlockState actualState, BlockState setState) {
        if (mc.m_91304_().m_119415_(actualState, setState)) {
            this.setBlocksDirty(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    public void setSectionDirtyWithNeighbors(int x, int y, int z) {
        this.setSectionDirty(x - 1, y - 1, z - 1);
        this.setSectionDirty(x - 1, y, z - 1);
        this.setSectionDirty(x - 1, y + 1, z - 1);
        this.setSectionDirty(x, y - 1, z - 1);
        this.setSectionDirty(x, y, z - 1);
        this.setSectionDirty(x, y + 1, z - 1);
        this.setSectionDirty(x + 1, y - 1, z - 1);
        this.setSectionDirty(x + 1, y, z - 1);
        this.setSectionDirty(x + 1, y + 1, z - 1);
        this.setSectionDirty(x - 1, y - 1, z);
        this.setSectionDirty(x - 1, y, z);
        this.setSectionDirty(x - 1, y + 1, z);
        this.setSectionDirty(x, y - 1, z);
        this.setSectionDirty(x, y, z);
        this.setSectionDirty(x, y + 1, z);
        this.setSectionDirty(x + 1, y - 1, z);
        this.setSectionDirty(x + 1, y, z);
        this.setSectionDirty(x + 1, y + 1, z);
        this.setSectionDirty(x - 1, y - 1, z + 1);
        this.setSectionDirty(x - 1, y, z + 1);
        this.setSectionDirty(x - 1, y + 1, z + 1);
        this.setSectionDirty(x, y - 1, z + -1);
        this.setSectionDirty(x, y, z + 1);
        this.setSectionDirty(x, y + 1, z + 1);
        this.setSectionDirty(x + 1, y - 1, z + 1);
        this.setSectionDirty(x + 1, y, z + 1);
        this.setSectionDirty(x + 1, y + 1, z + 1);
    }

    public void setSectionDirty(int x, int y, int z) {
        this.setSectionDirty(x, y, z, false);
    }

    protected abstract void setSectionDirty(int var1, int var2, int var3, boolean var4);

    private static /* synthetic */ VertexConsumer lambda$prepareBlockEntity$1(VertexConsumer vertexconsumer, MultiBufferSource bufferSource, RenderType type) {
        return type.m_110405_() ? VertexMultiConsumer.m_86168_((VertexConsumer)vertexconsumer, (VertexConsumer)bufferSource.m_6299_(type)) : bufferSource.m_6299_(type);
    }
}

