/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.cache.BlockBufferCache;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.cache.ChunkLayerUploadManager;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;
import team.creative.littletiles.client.render.mc.VertexFormatUtils;
import team.creative.littletiles.common.block.entity.BETiles;

public class LittleChunkDispatcher {
    public static int currentRenderState = Integer.MIN_VALUE;
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void onReloadRenderers(LevelRenderer levelRenderer) {
        if (LittleChunkDispatcher.mc.f_91060_ == levelRenderer) {
            ++currentRenderState;
        }
        if (LittleTilesClient.ANIMATION_HANDLER != null) {
            LittleTilesClient.ANIMATION_HANDLER.allChanged();
        }
        VertexFormatUtils.update();
    }

    public static void onOptifineMarksChunkRenderUpdateForDynamicLights(RenderChunkExtender chunk) {
        chunk.dynamicLightUpdate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startCompile(RenderChunkExtender chunk) {
        for (RenderType layer : RenderType.m_110506_()) {
            VertexBuffer vertexBuffer = chunk.getVertexBuffer(layer);
            ChunkLayerUploadManager manager = ((VertexBufferExtender)vertexBuffer).getManager();
            if (manager != null) {
                ChunkLayerUploadManager chunkLayerUploadManager = manager;
                synchronized (chunkLayerUploadManager) {
                    ++manager.queued;
                }
                manager.backToRAM();
                continue;
            }
            manager = new ChunkLayerUploadManager(chunk, layer);
            ((VertexBufferExtender)vertexBuffer).setManager(manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endCompile(RenderChunkExtender chunk, RebuildTaskExtender task) {
        chunk.dynamicLightUpdate(false);
        for (RenderType layer : RenderType.m_110506_()) {
            ChunkLayerUploadManager manager;
            VertexBuffer vertexBuffer = chunk.getVertexBuffer(layer);
            ChunkLayerUploadManager chunkLayerUploadManager = manager = ((VertexBufferExtender)vertexBuffer).getManager();
            synchronized (chunkLayerUploadManager) {
                --manager.queued;
            }
        }
        ChunkLayerMap<ChunkLayerCache> caches = task.getLayeredCache();
        if (caches != null) {
            for (Map.Entry entry : caches.tuples()) {
                VertexBuffer vertexBuffer = chunk.getVertexBuffer((RenderType)entry.getKey());
                ChunkLayerUploadManager manager = ((VertexBufferExtender)vertexBuffer).getManager();
                manager.set((ChunkLayerCache)entry.getValue());
            }
        }
        task.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(RenderChunkExtender chunk, BETiles be, RebuildTaskExtender rebuildTask) {
        if (chunk.dynamicLightUpdate()) {
            be.render.hasLightChanged = true;
        }
        be.updateQuadCache(chunk);
        for (RenderType layer : RenderType.m_110506_()) {
            BlockBufferCache blockBufferCache = be.render.getBufferCache();
            synchronized (blockBufferCache) {
                if (!be.render.getBufferCache().has(layer)) {
                    continue;
                }
                be.render.getBufferCache().add(layer, rebuildTask.builder(layer), rebuildTask.getOrCreate(layer));
            }
        }
    }
}

