/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import team.creative.creativecore.common.be.BlockEntityCreative;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.block.ILittleBlockEntity;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.level.RenderUploader;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.BlockParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.face.LittleFace;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.math.transformation.LittleBlockTransformer;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;

public class BETiles
extends BlockEntityCreative
implements IGridBased,
ILittleBlockEntity,
IForgeBlockEntity {
    private boolean hasLoaded = false;
    private boolean preventUnload = false;
    protected final BlockEntityInteractor interactor = new BlockEntityInteractor();
    private LittleGrid grid = LittleGrid.min();
    private BlockParentCollection tiles;
    private boolean unloaded = false;
    public final SideSolidCache sideCache = new SideSolidCache();
    @OnlyIn(value=Dist.CLIENT)
    public BERenderManager render;

    public BETiles(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends BETiles>)((BlockEntityType)LittleTilesRegistry.BE_TILES_TYPE.get()), pos, state);
    }

    public BETiles(BlockEntityType<? extends BETiles> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void assign(BETiles te) {
        try {
            for (Field field : BETiles.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                field.set(this, field.get(te));
            }
            this.m_142339_(this.m_58904_());
            this.tiles.be = this;
            if (this.isClient()) {
                this.render.setBe(this);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (this.tiles == null) {
            this.init();
        }
    }

    private void init() {
        this.tiles = new BlockParentCollection(this, this.isClient());
        if (this.isClient()) {
            this.initClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClient() {
        this.render = new BERenderManager(this);
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertTo(LittleGrid to) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            ((LittleTile)pair.value).convertTo(this.grid, to);
        }
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        int size = LittleGrid.min().count;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            size = Math.max(size, ((LittleTile)pair.value).getSmallest(this.grid));
        }
        return size;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BETiles) {
            BETiles be = (BETiles)blockEntity;
            if (!be.tiles.hasTicking() && !be.f_58857_.f_46443_) {
                be.customTilesUpdate();
                System.out.println("Ticking tileentity which shouldn't " + be.m_58899_());
                return;
            }
            be.tick();
        }
    }

    public Iterable<LittleStructure> ticking() {
        return this.tiles.loadedStructures(1024);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Iterable<LittleStructure> rendering() {
        return this.tiles.loadedStructures(2048);
    }

    public int tilesCount() {
        return this.tiles.size();
    }

    public boolean hasLoaded() {
        return this.hasLoaded && this.f_58857_ != null && this.tiles != null;
    }

    public void setLoaded() {
        this.hasLoaded = true;
    }

    public boolean shouldCheckForCollision() {
        return this.tiles.hasCollisionListener();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateQuadCache(RenderChunkExtender chunk) {
        if (this.tiles == null) {
            return;
        }
        this.render.chunkUpdate(chunk);
    }

    public void updateLighting() {
        this.f_58857_.m_5518_().m_7174_(this.m_58899_());
    }

    public BETiles forceSupportAttribute(int attribute) {
        boolean rendered = this.tiles.hasRendered() || LittleStructureAttribute.tickRendering(attribute);
        boolean ticking = this.tiles.hasTicking() || LittleStructureAttribute.ticking(attribute);
        BlockState state = BlockTile.getState(ticking, rendered);
        if (ticking != this.isTicking() || rendered != this.isRendered()) {
            this.preventUnload = true;
            this.f_58857_.m_7731_(this.f_58858_, state, 20);
            BETiles newBE = (BETiles)this.f_58857_.m_7702_(this.f_58858_);
            newBE.assign(this);
            newBE.tiles.be = newBE;
            this.m_7651_();
            this.preventUnload = false;
            return newBE;
        }
        return this;
    }

    protected void customTilesUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean rendered = this.tiles.hasRendered();
        boolean ticking = this.tiles.hasTicking();
        BlockState state = BlockTile.getState(ticking, rendered);
        if (ticking != this.isTicking() || rendered != this.isRendered()) {
            this.preventUnload = true;
            this.f_58857_.m_7731_(this.f_58858_, state, 20);
            BETiles newBE = (BETiles)this.f_58857_.m_7702_(this.f_58858_);
            newBE.assign(this);
            newBE.tiles.be = newBE;
            this.m_7651_();
            this.preventUnload = false;
        }
    }

    private void updateNeighbour(Facing facing) {
        LittleServerFace face = new LittleServerFace(this);
        for (Pair<IParentCollection, LittleTile> pair : this.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                if (!box.hasOrCreateFaceState((IParentCollection)pair.key, (LittleTile)pair.value, face) || !box.getFaceState(facing).outside()) continue;
                box.setFaceState(facing, face.set((IParentCollection)pair.key, (LittleTile)pair.value, box, facing).calculate());
            }
        }
    }

    public void onNeighbourChanged(@Nullable Facing facing) {
        if (facing == null) {
            for (int i = 0; i < Facing.VALUES.length; ++i) {
                this.updateNeighbour(Facing.VALUES[i]);
            }
        } else {
            this.updateNeighbour(facing);
        }
        if (this.isClient()) {
            this.render.onNeighbourChanged();
        }
        this.notifyStructure();
    }

    public void notifyStructure() {
        for (LittleStructure structure : this.tiles.loadedStructures(65536)) {
            structure.neighbourChanged();
        }
    }

    public void updateTiles() {
        this.updateTiles(true);
    }

    public void updateTiles(boolean updateNeighbour) {
        this.tiles.removeEmptyLists();
        this.notifyStructure();
        this.sideCache.reset();
        this.rebuildFaces();
        if (this.f_58857_ != null) {
            this.markDirty();
            if (updateNeighbour) {
                this.updateNeighbour();
            }
            this.updateLighting();
        }
        if (this.isClient()) {
            this.render.tilesChanged();
        }
        if (!this.f_58857_.f_46443_ && this.tiles.isCompletelyEmpty()) {
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
        }
        this.customTilesUpdate();
    }

    public void updateTiles(Consumer<BlockEntityInteractor> action) {
        action.accept(this.interactor);
        this.updateTiles();
    }

    public void updateTilesSecretly(Consumer<BlockEntityInteractor> action) {
        action.accept(this.interactor);
    }

    public boolean convertBlockToVanilla() {
        LittleTile firstTile = null;
        if (this.tiles.isCompletelyEmpty()) {
            this.f_58857_.m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 35);
            return true;
        }
        if (this.f_58857_ instanceof IOrientatedLevel || this.tiles.countStructures() > 0) {
            return false;
        }
        if (this.tiles.size() == 1) {
            LittleTile first = this.tiles.first();
            if (!first.canBeConvertedToVanilla() || !first.doesFillEntireBlock(this.grid)) {
                return false;
            }
            firstTile = this.tiles.first();
            this.f_58857_.m_46597_(this.m_58899_(), firstTile.getBlock().getState());
            return true;
        }
        return false;
    }

    public boolean isBoxFilled(LittleBox box) {
        LittleVec size = box.getSize();
        boolean[][][] filled = new boolean[size.x][size.y][size.z];
        for (LittleTile tile : this.tiles) {
            tile.fillInSpace(box, filled);
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateNeighbour() {
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
    }

    private LittleBox getLittleBlockBox() {
        int minX = this.grid.count;
        int minY = this.grid.count;
        int minZ = this.grid.count;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                minX = Math.min(box.minX, minX);
                minY = Math.min(box.minY, minY);
                minZ = Math.min(box.minZ, minZ);
                maxX = Math.max(box.maxX, maxX);
                maxY = Math.max(box.maxY, maxY);
                maxZ = Math.max(box.maxZ, maxZ);
            }
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AABB getBlockBB() {
        return this.getLittleBlockBox().getBB(this.grid);
    }

    public AABB getBlockBBWithOffset() {
        return this.getLittleBlockBox().getBB(this.grid, this.f_58858_);
    }

    public VoxelShape getBlockShape() {
        return this.getLittleBlockBox().getShape(this.grid);
    }

    public void rebuildFaces() {
        LittleServerFace face = new LittleServerFace(this);
        for (Pair<IParentCollection, LittleTile> entry : this.allTiles()) {
            for (LittleBox box : (LittleTile)entry.value) {
                for (int i = 0; i < Facing.VALUES.length; ++i) {
                    Facing facing = Facing.VALUES[i];
                    box.setFaceState(facing, face.set((IParentCollection)entry.getKey(), (LittleTile)entry.getValue(), box, facing).calculate());
                }
            }
        }
    }

    public boolean shouldFaceBeRendered(LittleFace face, LittleTile rendered) {
        face.ensureGrid(this.grid);
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (((IParentCollection)pair.key).isStructure() && LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) || pair.value == rendered || !((LittleTile)pair.value).doesProvideSolidFace() && !((LittleTile)pair.value).canBeRenderCombined(rendered)) continue;
            ((LittleTile)pair.value).fillFace((IParentCollection)pair.key, face, this.grid);
        }
        return !face.isFilled(rendered.isTranslucent());
    }

    public List<LittleBox> cutOut(LittleBox box, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        ArrayList<LittleBox> cutting = new ArrayList<LittleBox>();
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            ((LittleTile)pair.value).getIntersectingBoxes(box, cutting);
        }
        return box.cutOut(cutting, cutout, volume);
    }

    public Pair<IParentCollection, LittleTile> intersectingTile(LittleBox box) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (!((LittleTile)pair.value).intersectsWith(box)) continue;
            return pair;
        }
        return null;
    }

    public boolean isSpaceFor(LittleBox box, BiPredicate<IParentCollection, LittleTile> predicate) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (predicate != null && !predicate.test((IParentCollection)pair.key, (LittleTile)pair.value) || !((LittleTile)pair.value).intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceFor(LittleBox box, Predicate<LittleTile> predicate) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (predicate != null && !predicate.test((LittleTile)pair.value) || !((LittleTile)pair.value).intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceFor(LittleBox box) {
        return this.isSpaceFor(box, (Predicate<LittleTile>)null);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (this.tiles == null) {
            this.init();
        }
        if (!this.tiles.isCompletelyEmpty()) {
            this.tiles.clearEverything();
        }
        this.grid = LittleGrid.get(nbt);
        this.tiles.load(nbt.m_128469_("content"));
        this.sideCache.load(nbt);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
            this.customTilesUpdate();
        }
    }

    protected int[] getIdentifier(LittleBox box) {
        return new int[]{box.minX, box.minY, box.minZ};
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.grid.set(nbt);
        nbt.m_128365_("content", (Tag)this.tiles.save(new LittleServerFace(this)));
        this.sideCache.write(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdate(CompoundTag nbt, boolean chunkUpdate) {
        RenderUploader.notifyReceiveClientUpdate(this);
        this.m_142466_(nbt);
        if (!chunkUpdate) {
            this.updateTiles(false);
        }
    }

    public BlockHitResult rayTrace(Player player) {
        Level level;
        Vec3 pos = player.m_20318_(TickUtils.getFrameTime((LevelAccessor)this.f_58857_));
        double distance = PlayerUtils.getReach((Player)player);
        Vec3 view = player.m_20252_(TickUtils.getFrameTime((LevelAccessor)this.f_58857_));
        Vec3 look = pos.m_82520_(view.f_82479_ * distance, view.f_82480_ * distance, view.f_82481_ * distance);
        if (this.f_58857_ != player.f_19853_ && (level = this.f_58857_) instanceof IOrientatedLevel) {
            IOrientatedLevel or = (IOrientatedLevel)level;
            pos = or.getOrigin().transformPointToFakeWorld(pos);
            look = or.getOrigin().transformPointToFakeWorld(look);
        }
        return this.rayTrace(pos, look);
    }

    public BlockHitResult rayTrace(Vec3 pos, Vec3 look) {
        BlockHitResult result = null;
        double distance = 0.0;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                BlockHitResult temphit = box.rayTrace(this.grid, this.m_58899_(), pos, look);
                if (temphit == null) continue;
                double tempDistance = temphit.m_82450_().m_82557_(pos);
                if (result != null && !(distance > tempDistance)) continue;
                distance = tempDistance;
                result = temphit;
            }
        }
        return result;
    }

    public LittleTileContext getFocusedTile(Player player, float partialTickTime) {
        Level level;
        if (!this.isClient()) {
            return null;
        }
        Vec3 pos = player.m_20299_(partialTickTime);
        double distance = PlayerUtils.getReach((Player)player);
        Vec3 view = player.m_20252_(partialTickTime);
        Vec3 look = pos.m_82520_(view.f_82479_ * distance, view.f_82480_ * distance, view.f_82481_ * distance);
        if (this.f_58857_ != player.f_19853_ && (level = this.f_58857_) instanceof IOrientatedLevel) {
            IOrientatedLevel or = (IOrientatedLevel)level;
            pos = or.getOrigin().transformPointToFakeWorld(pos);
            look = or.getOrigin().transformPointToFakeWorld(look);
        }
        return this.getFocusedTile(pos, look);
    }

    public LittleTileContext getFocusedTile(Vec3 pos, Vec3 look) {
        IParentCollection parent = null;
        LittleTile tileFocus = null;
        LittleBox boxFocus = null;
        double distance = 0.0;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                BlockHitResult Temphit = box.rayTrace(this.grid, this.m_58899_(), pos, look);
                if (Temphit == null) continue;
                double tempDistance = Temphit.m_82450_().m_82557_(pos);
                if (tileFocus != null && !(distance > tempDistance)) continue;
                distance = tempDistance;
                parent = (IParentCollection)pair.key;
                tileFocus = (LittleTile)pair.value;
                boxFocus = box;
            }
        }
        if (tileFocus == null) {
            return LittleTileContext.FAILED;
        }
        return new LittleTileContext(parent, tileFocus, boxFocus);
    }

    public void onLoad() {
        this.setLoaded();
    }

    public boolean isTicking() {
        return false;
    }

    public boolean isRendered() {
        return false;
    }

    public BlockState getBlockTileState() {
        return BlockTile.getState(this);
    }

    public boolean combineTiles(int structureIndex) {
        if (this.getStructure(structureIndex) == null) {
            return false;
        }
        boolean changed = ((StructureParentCollection)this.getStructure(structureIndex)).combine();
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineTilesSecretly(int structureIndex) {
        if (this.getStructure(structureIndex) == null) {
            return false;
        }
        boolean changed = ((StructureParentCollection)this.getStructure(structureIndex)).combine();
        this.convertToSmallest();
        return changed;
    }

    public boolean combineTiles() {
        boolean changed = this.tiles.combine();
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineTilesSecretly() {
        boolean changed = this.tiles.combine();
        this.convertToSmallest();
        return changed;
    }

    @Override
    @Nullable
    public BlockState getState(AABB box, boolean realistic) {
        if (this.tiles == null) {
            return null;
        }
        if (realistic) {
            box = box.m_82363_(0.0, -this.grid.pixelLength, 0.0);
            for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
                if (((LittleTile)pair.value).noCollision()) continue;
                for (LittleBox tileBox : (LittleTile)pair.value) {
                    if (!tileBox.getBB(this.grid, this.m_58899_()).m_82381_(box)) continue;
                    return ((LittleTile)pair.value).getBlock().getState();
                }
            }
            return null;
        }
        box = box.m_82363_(0.0, -1.0, 0.0);
        LittleElement highest = null;
        LittleBox highestBox = null;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (((LittleTile)pair.value).noCollision()) continue;
            Iterator<LittleBox> iterator = ((LittleTile)highest).iterator();
            while (iterator.hasNext()) {
                LittleBox tileBox = iterator.next();
                if (highest != null && (tileBox.maxY <= highestBox.maxY || !tileBox.getBB(this.grid, this.m_58899_()).m_82381_(box))) continue;
                highest = (LittleTile)pair.value;
                highestBox = tileBox;
            }
        }
        return highest != null ? highest.getBlock().getState() : null;
    }

    public boolean isEmpty() {
        return this.tiles.isCompletelyEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isRenderingEmpty() {
        return this.tiles.isCompletelyEmpty() && !this.render.getBufferCache().hasAdditional();
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.preventUnload) {
            this.tiles.unload();
        }
    }

    public boolean unloaded() {
        return this.unloaded;
    }

    public void onChunkUnloaded() {
        this.unloaded = true;
        super.onChunkUnloaded();
        this.tiles.unload();
        if (this.f_58857_.f_46443_) {
            this.tiles = null;
            this.render.chunkUnload();
        }
    }

    public void rotate(net.minecraft.world.level.block.Rotation rotation) {
        LittleBlockTransformer.rotate(this, Rotation.getRotation((net.minecraft.world.level.block.Rotation)rotation), Rotation.getRotationCount((net.minecraft.world.level.block.Rotation)rotation));
        this.updateTiles();
    }

    public void mirror(Mirror mirror) {
        LittleBlockTransformer.mirror(this, Axis.getMirrorAxis((Mirror)mirror));
        this.updateTiles();
    }

    public String toString() {
        return this.m_58899_().toString();
    }

    public void tick() {
        for (LittleStructure structure : this.ticking()) {
            structure.tick();
        }
    }

    public Iterable<IParentCollection> groups() {
        return this.tiles.groups();
    }

    public IParentCollection noneStructureTiles() {
        return this.tiles;
    }

    public Iterable<Pair<IParentCollection, LittleTile>> allTiles() {
        return this.tiles.allTiles();
    }

    public Iterable<Pair<IParentCollection, LittleTile>> allBoxes() {
        return this.tiles.allTiles();
    }

    public IStructureParentCollection getStructure(int index) {
        return this.tiles.getStructure(index);
    }

    public Iterable<LittleStructure> loadedStructures() {
        return this.tiles.loadedStructures();
    }

    public Iterable<LittleStructure> loadedStructures(int attribute) {
        return this.tiles.loadedStructures(attribute);
    }

    public Iterable<IStructureParentCollection> structures() {
        return this.tiles.structures();
    }

    public void fillUsedIds(BitSet usedIds) {
        this.tiles.fillUsedIds(usedIds);
    }

    public class BlockEntityInteractor {
        public Iterable<ParentCollection> groups() {
            return new Iterable<ParentCollection>(){

                @Override
                public Iterator<ParentCollection> iterator() {
                    return new Iterator<ParentCollection>(){
                        ParentCollection current;
                        Iterator<StructureParentCollection> children;
                        {
                            this.current = BETiles.this.tiles;
                            this.children = BlockEntityInteractor.this.structures().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.current != null) {
                                return true;
                            }
                            if (!this.children.hasNext()) {
                                return false;
                            }
                            this.current = this.children.next();
                            return true;
                        }

                        @Override
                        public ParentCollection next() {
                            ParentCollection result = this.current;
                            this.current = null;
                            return result;
                        }
                    };
                }
            };
        }

        public ParentCollection get(IParentCollection list) {
            return (ParentCollection)list;
        }

        public StructureParentCollection get(IStructureParentCollection list) {
            return (StructureParentCollection)list;
        }

        public ParentCollection noneStructureTiles() {
            return BETiles.this.tiles;
        }

        public Iterable<StructureParentCollection> structures() {
            return BETiles.this.tiles.structuresReal();
        }

        public StructureParentCollection getStructure(int index) {
            return BETiles.this.tiles.getStructure(index);
        }

        public boolean removeStructure(int index) {
            return BETiles.this.tiles.removeStructure(index);
        }

        public StructureParentCollection addStructure(int index, int attribute) {
            return BETiles.this.tiles.addStructure(index, attribute);
        }

        public void clearEverything() {
            BETiles.this.tiles.clearEverything();
        }
    }

    public class SideSolidCache {
        SideState EAST;
        SideState WEST;
        SideState UP;
        SideState DOWN;
        SideState SOUTH;
        SideState NORTH;
        SideState YAXIS;

        public void load(CompoundTag nbt) {
            this.EAST = nbt.m_128441_("east") ? SideState.values()[nbt.m_128451_("east")] : null;
            this.WEST = nbt.m_128441_("west") ? SideState.values()[nbt.m_128451_("west")] : null;
            this.UP = nbt.m_128441_("up") ? SideState.values()[nbt.m_128451_("up")] : null;
            this.DOWN = nbt.m_128441_("down") ? SideState.values()[nbt.m_128451_("down")] : null;
            this.SOUTH = nbt.m_128441_("south") ? SideState.values()[nbt.m_128451_("south")] : null;
            this.NORTH = nbt.m_128441_("north") ? SideState.values()[nbt.m_128451_("north")] : null;
            this.YAXIS = nbt.m_128441_("y_axis") ? SideState.values()[nbt.m_128451_("y_axis")] : null;
        }

        public void write(CompoundTag nbt) {
            if (this.EAST != null) {
                nbt.m_128405_("east", this.EAST.ordinal());
            }
            if (this.WEST != null) {
                nbt.m_128405_("west", this.WEST.ordinal());
            }
            if (this.UP != null) {
                nbt.m_128405_("up", this.UP.ordinal());
            }
            if (this.DOWN != null) {
                nbt.m_128405_("down", this.DOWN.ordinal());
            }
            if (this.SOUTH != null) {
                nbt.m_128405_("south", this.SOUTH.ordinal());
            }
            if (this.NORTH != null) {
                nbt.m_128405_("north", this.NORTH.ordinal());
            }
            if (this.YAXIS != null) {
                nbt.m_128405_("y_axis", this.YAXIS.ordinal());
            }
        }

        public void reset() {
            this.DOWN = null;
            this.UP = null;
            this.NORTH = null;
            this.SOUTH = null;
            this.WEST = null;
            this.EAST = null;
            this.YAXIS = null;
        }

        public SideState getYAxis() {
            if (this.YAXIS != null) {
                return this.YAXIS;
            }
            LittleBox box = new LittleBox(0, 0, 0, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
            boolean[][] filled = new boolean[BETiles.this.grid.count][BETiles.this.grid.count];
            boolean translucent = false;
            boolean noclip = false;
            for (Pair<IParentCollection, LittleTile> pair : BETiles.this.tiles.allTiles()) {
                if (!((LittleTile)pair.value).fillInSpaceInaccurate(box, Axis.X, Axis.Z, Axis.Y, filled)) continue;
                if (!((LittleTile)pair.value).doesProvideSolidFace()) {
                    translucent = true;
                }
                if (!LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) && !((LittleTile)pair.value).getBlock().noCollision()) continue;
                noclip = true;
            }
            for (int one = 0; one < filled.length; ++one) {
                for (int two = 0; two < filled[one].length; ++two) {
                    if (filled[one][two]) continue;
                    return SideState.EMPTY;
                }
            }
            this.YAXIS = SideState.getState(false, noclip, translucent);
            return this.YAXIS;
        }

        protected SideState calculate(Facing facing) {
            LittleBox box = switch (facing) {
                case Facing.EAST -> new LittleBox(BETiles.this.grid.count - 1, 0, 0, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.WEST -> new LittleBox(0, 0, 0, 1, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.UP -> new LittleBox(0, BETiles.this.grid.count - 1, 0, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.DOWN -> new LittleBox(0, 0, 0, BETiles.this.grid.count, 1, BETiles.this.grid.count);
                case Facing.SOUTH -> new LittleBox(0, 0, BETiles.this.grid.count - 1, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.NORTH -> new LittleBox(0, 0, 0, BETiles.this.grid.count, BETiles.this.grid.count, 1);
                default -> null;
            };
            return this.calculateState(facing, box);
        }

        protected SideState calculateState(Facing facing, LittleBox box) {
            LittleVec size = box.getSize();
            boolean[][][] filled = new boolean[size.x][size.y][size.z];
            boolean translucent = false;
            boolean noclip = false;
            for (Pair<IParentCollection, LittleTile> pair : BETiles.this.tiles.allTiles()) {
                if (!((LittleTile)pair.value).fillInSpaceInaccurate(box, filled)) continue;
                if (!((LittleTile)pair.value).doesProvideSolidFace()) {
                    translucent = true;
                }
                if (!LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) && !((LittleTile)pair.value).getBlock().noCollision()) continue;
                noclip = true;
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return SideState.EMPTY;
                    }
                }
            }
            return SideState.getState(false, noclip, translucent);
        }

        public SideState get(Facing facing) {
            SideState result;
            switch (facing) {
                case DOWN: {
                    SideState sideState = this.DOWN;
                    break;
                }
                case UP: {
                    SideState sideState = this.UP;
                    break;
                }
                case NORTH: {
                    SideState sideState = this.NORTH;
                    break;
                }
                case SOUTH: {
                    SideState sideState = this.SOUTH;
                    break;
                }
                case WEST: {
                    SideState sideState = this.WEST;
                    break;
                }
                case EAST: {
                    SideState sideState = this.EAST;
                    break;
                }
                default: {
                    SideState sideState = result = SideState.EMPTY;
                }
            }
            if (result == null) {
                result = this.calculate(facing);
                this.set(facing, result);
            }
            return result;
        }

        public void set(Facing facing, SideState value) {
            switch (facing) {
                case DOWN: {
                    this.DOWN = value;
                    break;
                }
                case UP: {
                    this.UP = value;
                    break;
                }
                case NORTH: {
                    this.NORTH = value;
                    break;
                }
                case SOUTH: {
                    this.SOUTH = value;
                    break;
                }
                case WEST: {
                    this.WEST = value;
                    break;
                }
                case EAST: {
                    this.EAST = value;
                }
            }
        }

        public boolean isCollisionFullBlock() {
            for (int i = 0; i < Facing.VALUES.length; ++i) {
                if (this.get(Facing.VALUES[i]).isFilled()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SideState {
        EMPTY{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return false;
            }
        }
        ,
        SEETHROUGH{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SEETHROUGH_NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SOLID{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        };


        public abstract boolean isFilled();

        public abstract boolean doesBlockCollision();

        public abstract boolean doesBlockLight();

        public static SideState getState(boolean empty, boolean noclip, boolean translucent) {
            if (empty) {
                return EMPTY;
            }
            if (noclip && translucent) {
                return SEETHROUGH_NOCLIP;
            }
            if (noclip) {
                return NOCLIP;
            }
            if (translucent) {
                return SEETHROUGH;
            }
            return SOLID;
        }
    }
}

