/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.box.volume.LittleVolumes;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleBlockCollection {
    protected HashMap<BlockPos, LittleCollection> content = new HashMap();
    public final BlockPos pos;
    public final LittleGrid grid;

    public LittleBlockCollection(BlockPos pos, LittleGrid grid) {
        this.pos = pos;
        this.grid = grid;
    }

    public void add(LittleGroup group, LittleVec offset, LittleVolumes removedVolume) {
        LittleBoxReturnedVolume volume = new LittleBoxReturnedVolume();
        HashMapList map = new HashMapList();
        Iterator<LittleTile> iterator = group.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            tile.split((HashMapList<BlockPos, LittleBox>)map, this.pos, this.grid, offset, volume);
            for (Map.Entry entry : map.entrySet()) {
                LittleCollection collection = this.content.get(entry.getKey());
                if (collection == null) {
                    collection = new LittleCollection();
                    this.content.put((BlockPos)entry.getKey(), collection);
                }
                collection.add(tile.copy((List)entry.getValue()));
            }
            if (volume.has()) {
                removedVolume.add(this.grid, tile, volume.getVolume());
            }
            volume.clear();
            map.clear();
        }
    }

    public Set<Map.Entry<BlockPos, LittleCollection>> entrySet() {
        return this.content.entrySet();
    }
}

