/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.util.type.itr.NestedIterator;
import team.creative.creativecore.common.util.type.list.CopyArrayCollection;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.api.common.block.LittleBlock;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.registry.LittleBlockRegistry;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.face.LittleServerFace;

public class LittleCollection
implements Iterable<LittleTile> {
    protected Collection<LittleTile> content = this.createInternalCollection();

    public void add(LittleElement element, Iterable<LittleBox> boxes) {
        for (LittleTile other : this) {
            if (!other.is(element)) continue;
            other.add(boxes);
            return;
        }
        this.content.add(new LittleTile(element, boxes));
    }

    public void add(LittleElement element, LittleBox box) {
        for (LittleTile other : this) {
            if (!other.is(element)) continue;
            other.add(box);
            return;
        }
        this.content.add(new LittleTile(element, box));
    }

    public void add(LittleTile tile) {
        if (!this.canAdd()) {
            return;
        }
        for (LittleTile other : this) {
            if (!other.equals(tile)) continue;
            other.add(tile);
            return;
        }
        this.content.add(tile);
    }

    public void addAll(Iterable<LittleTile> tiles) {
        for (LittleTile tile : tiles) {
            this.add(tile);
        }
    }

    protected boolean canAdd() {
        return true;
    }

    protected void added(LittleElement tile) {
    }

    protected void refresh() {
    }

    protected void removed(LittleElement tile) {
    }

    public void removeAll(Iterable<LittleTile> tiles) {
        for (LittleTile tile : tiles) {
            this.removeElementBoxes(tile);
        }
    }

    public boolean removeElement(LittleElement element) {
        if (this.content.remove(element)) {
            this.removed(element);
            return true;
        }
        return false;
    }

    public boolean removeElementBoxes(LittleTile tile) {
        for (LittleTile other : this) {
            if (!other.is(tile)) continue;
            return other.remove(this, tile);
        }
        return false;
    }

    public boolean remove(LittleElement element, LittleBox box) {
        for (LittleTile other : this) {
            if (!other.is(element)) continue;
            return other.remove(this, box);
        }
        return false;
    }

    public void clear() {
        this.content.clear();
        this.refresh();
    }

    protected Collection<LittleTile> createInternalCollection() {
        return new ArrayList<LittleTile>();
    }

    public Iterator<LittleBox> boxes() {
        return new NestedIterator(this.content);
    }

    @Override
    public Iterator<LittleTile> iterator() {
        return new Iterator<LittleTile>(){
            Iterator<LittleTile> itr;
            {
                this.itr = LittleCollection.this.content.iterator();
            }

            @Override
            public LittleTile next() {
                return this.itr.next();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public void remove() {
                this.itr.remove();
                LittleCollection.this.refresh();
            }
        };
    }

    public boolean hasTranslucentBlocks() {
        for (LittleTile tile : this.content) {
            if (!tile.isTranslucent()) continue;
            return true;
        }
        return false;
    }

    public boolean combine() {
        boolean result = false;
        for (LittleTile tile : this.content) {
            result |= tile.combine();
        }
        return result;
    }

    public void combineBlockwise(LittleGrid grid) {
        for (LittleTile tile : this.content) {
            tile.combineBlockwise(grid);
        }
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    public int boxesCount() {
        int count = 0;
        for (LittleTile tile : this.content) {
            count += tile.size();
        }
        return count;
    }

    public LittleTile first() {
        if (this.content instanceof CopyArrayCollection) {
            return (LittleTile)((CopyArrayCollection)this.content).first();
        }
        if (this.content instanceof List) {
            return (LittleTile)((List)this.content).get(0);
        }
        return this.content.iterator().next();
    }

    public String toString() {
        return this.content.toString();
    }

    public static void load(LittleCollection collection, CompoundTag nbt) {
        collection.clear();
        for (String name : nbt.m_128431_()) {
            ListTag boxes = nbt.m_128437_(name, 11);
            BlockState state = LittleBlockRegistry.loadState(name);
            LittleBlock block = state.m_60734_() instanceof AirBlock ? LittleBlockRegistry.getMissing(name) : LittleBlockRegistry.get(state);
            ArrayList<LittleBox> tileBoxes = null;
            int color = -1;
            for (int j = 0; j < boxes.size(); ++j) {
                int[] data = boxes.m_128767_(j);
                if (data.length == 1) {
                    if (tileBoxes != null) {
                        collection.content.add(new LittleTile(state, block, color, tileBoxes));
                    }
                    tileBoxes = new ArrayList<LittleBox>();
                    color = data[0];
                    continue;
                }
                tileBoxes.add(LittleBox.create(data));
            }
            if (tileBoxes == null || tileBoxes.isEmpty()) continue;
            collection.content.add(new LittleTile(state, block, color, tileBoxes));
        }
    }

    public static void loadExtended(LittleCollection collection, CompoundTag nbt) {
        collection.clear();
        for (String name : nbt.m_128431_()) {
            ListTag boxes = nbt.m_128437_(name, 11);
            BlockState state = LittleBlockRegistry.loadState(name);
            LittleBlock block = state.m_60734_() instanceof AirBlock ? LittleBlockRegistry.getMissing(name) : LittleBlockRegistry.get(state);
            ArrayList<LittleBox> tileBoxes = null;
            int color = -1;
            for (int j = 0; j < boxes.size(); ++j) {
                int[] data = boxes.m_128767_(j);
                if (data.length == 1) {
                    if (tileBoxes != null) {
                        collection.content.add(new LittleTile(state, block, color, tileBoxes));
                    }
                    tileBoxes = new ArrayList<LittleBox>();
                    color = data[0];
                    continue;
                }
                tileBoxes.add(LittleBox.createExtended(data));
            }
            if (tileBoxes == null || tileBoxes.isEmpty()) continue;
            collection.content.add(new LittleTile(state, block, color, tileBoxes));
        }
    }

    public static CompoundTag save(LittleCollection collection) {
        HashMapList sorted = new HashMapList();
        for (LittleTile tile : collection) {
            sorted.add((Object)tile.getBlockName(), (Object)tile);
        }
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry entry : sorted.entrySet()) {
            ListTag boxes = new ListTag();
            for (LittleTile tile : (ArrayList)entry.getValue()) {
                boxes.add((Object)new IntArrayTag(new int[]{tile.color}));
                for (LittleBox box : tile) {
                    boxes.add((Object)box.getArrayTag());
                }
            }
            nbt.m_128365_((String)entry.getKey(), (Tag)boxes);
        }
        return nbt;
    }

    public static CompoundTag saveExtended(IParentCollection collection, LittleServerFace face) {
        HashMapList sorted = new HashMapList();
        for (LittleTile tile : collection) {
            sorted.add((Object)tile.getBlockName(), (Object)tile);
        }
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry entry : sorted.entrySet()) {
            ListTag boxes = new ListTag();
            for (LittleTile tile : (ArrayList)entry.getValue()) {
                boxes.add((Object)new IntArrayTag(new int[]{tile.color}));
                for (LittleBox box : tile) {
                    boxes.add((Object)box.getArrayTagExtended(collection, tile, face));
                }
            }
            nbt.m_128365_((String)entry.getKey(), (Tag)boxes);
        }
        return nbt;
    }
}

