/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.api.common.block.ILittleMCBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class BlockFlowingWater
extends Block
implements ILittleMCBlock,
IFakeRenderingBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61372_;
    public final Block still;

    public BlockFlowingWater(Block still) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_));
        this.still = still;
    }

    public Block m_7374_() {
        return this;
    }

    public BlockState m_6843_(BlockState state, net.minecraft.world.level.block.Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_());
    }

    @Override
    public boolean noCollision() {
        return true;
    }

    @Override
    public boolean isMaterial(Material material) {
        return material == Material.f_76305_;
    }

    @Override
    public boolean isLiquid() {
        return true;
    }

    @Override
    public boolean checkEntityCollision() {
        return true;
    }

    @Override
    public Vec3d modifyAcceleration(IParentCollection parent, LittleTile tile, Entity entity, Vec3d motion) {
        AABB box = entity.m_20191_();
        LittleVec center = new LittleVec(parent.getGrid(), new Vec3((box.f_82288_ + box.f_82291_) / 2.0, (box.f_82289_ + box.f_82292_) / 2.0, (box.f_82290_ + box.f_82293_) / 2.0).m_82546_(Vec3.m_82528_((Vec3i)parent.getPos())));
        LittleBox testBox = new LittleBox(center, 1, 1, 1);
        if (tile.intersectsWith(testBox)) {
            double scale = 0.01;
            Vec3 vec = new Vec3(((Direction)tile.getState().m_61143_((Property)BlockStateProperties.f_61372_)).m_253071_()).m_82541_().m_82490_(scale);
            entity.m_20256_(entity.m_20184_().m_82549_(vec));
        }
        return new Vec3d(((Direction)tile.getState().m_61143_((Property)BlockStateProperties.f_61372_)).m_253071_());
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        return false;
    }

    @Override
    public BlockState getFakeState(BlockState state) {
        return Blocks.f_49990_.m_49966_();
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result) {
        if (player.m_21205_().m_41720_() instanceof BucketItem && LittleTiles.CONFIG.general.allowFlowingWater) {
            Direction facing = (Direction)tile.getState().m_61143_((Property)BlockStateProperties.f_61372_);
            int index = facing.ordinal() + 1;
            if (index >= Direction.values().length) {
                tile.setState(((Block)LittleTilesRegistry.WATER.get()).m_49966_());
            } else {
                tile.setState((BlockState)tile.getState().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.values()[index]));
            }
            parent.getBE().updateTiles();
            return InteractionResult.SUCCESS;
        }
        return ILittleMCBlock.super.use(parent, tile, box, player, result);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canBeRenderCombined(LittleTile thisTile, LittleTile tile) {
        if (tile.getBlock() == this) {
            return true;
        }
        return tile.getBlock() == LittleTilesRegistry.WATER.get();
    }

    @Override
    public Vector3d getFogColor(IParentCollection parent, LittleTile tile, Entity entity, Vector3d originalColor, float partialTicks) {
        float f12 = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            f12 = (float)EnchantmentHelper.m_44918_((LivingEntity)ent) * 0.2f;
            if (ent.m_21023_(MobEffects.f_19608_)) {
                f12 = f12 * 0.3f + 0.6f;
            }
        }
        return new Vector3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation, LittleVec doubledCenter) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.rotate(Facing.get((Direction)((Direction)state.m_61143_(FACING)))).toVanilla());
    }

    @Override
    public BlockState mirror(BlockState state, Axis axis, LittleVec doubledCenter) {
        return (BlockState)state.m_61124_(FACING, (Comparable)axis.mirror((Direction)state.m_61143_(FACING)));
    }
}

