/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeSoundType;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.block.LittlePhysicBlock;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.render.block.BlockTileRenderProperties;
import team.creative.littletiles.common.action.LittleActionActivated;
import team.creative.littletiles.common.action.LittleActionDestroy;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.entity.BETilesRendered;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.item.ItemLittleSaw;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.server.LittleTilesServer;

public class BlockTile
extends BaseEntityBlock
implements LittlePhysicBlock {
    public static final SoundType SILENT = new ForgeSoundType(-1.0f, 1.0f, () -> SoundEvents.f_12442_, () -> SoundEvents.f_12450_, () -> SoundEvents.f_12447_, () -> SoundEvents.f_12446_, () -> SoundEvents.f_12445_);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final boolean ticking;
    public final boolean rendered;
    private boolean lightLoopPreventer = true;

    public static BETiles loadBE(BlockGetter level, BlockPos pos) {
        if (level == null) {
            return null;
        }
        BlockEntity be = null;
        try {
            be = level.getExistingBlockEntity(pos);
        }
        catch (Exception e) {
            return null;
        }
        if (be instanceof BETiles && ((BETiles)be).hasLoaded()) {
            return (BETiles)be;
        }
        return null;
    }

    public static boolean selectEntireBlock(Player player, boolean secondMode) {
        return secondMode && !(player.m_21205_().m_41720_() instanceof ItemLittleSaw) && !(player.m_21205_().m_41720_() instanceof ItemLittlePaintBrush);
    }

    public static BlockState getStateByAttribute(int attribute) {
        return BlockTile.getState(LittleStructureAttribute.ticking(attribute), LittleStructureAttribute.tickRendering(attribute));
    }

    public static BlockState getState(boolean ticking, boolean rendered) {
        return rendered ? (ticking ? ((Block)LittleTilesRegistry.BLOCK_TILES_TICKING_RENDERED.get()).m_49966_() : ((Block)LittleTilesRegistry.BLOCK_TILES_RENDERED.get()).m_49966_()) : (ticking ? ((Block)LittleTilesRegistry.BLOCK_TILES_TICKING.get()).m_49966_() : ((Block)LittleTilesRegistry.BLOCK_TILES.get()).m_49966_());
    }

    public static BlockState getState(BETiles te) {
        return BlockTile.getState(te.isTicking(), te.isRendered());
    }

    public static BlockState getState(List<StructureParentCollection> structures) {
        boolean ticking = false;
        boolean rendered = false;
        for (StructureParentCollection structure : structures) {
            if (LittleStructureAttribute.ticking(structure.getAttribute())) {
                ticking = true;
            }
            if (LittleStructureAttribute.tickRendering(structure.getAttribute())) {
                rendered = true;
            }
            if (!ticking || !rendered) continue;
            break;
        }
        return BlockTile.getState(ticking, rendered);
    }

    public BlockTile(Material material, boolean ticking, boolean rendered) {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_155954_(1.0f).m_155956_(3.0f).m_60918_(SILENT).m_60988_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.ticking = ticking;
        this.rendered = rendered;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> definition) {
        definition.m_61104_(new Property[]{WATERLOGGED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(BlockTileRenderProperties.INSTANCE);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BETiles be = BlockTile.loadBE(level, pos);
        VoxelShape shape = Shapes.m_83040_();
        if (be != null) {
            for (IParentCollection list : be.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                if (list.isStructure() && LittleStructureAttribute.extraCollision(list.getAttribute())) {
                    try {
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)list.getStructure().getExtraShape(state, level, pos, context), (BooleanOp)BooleanOp.f_82695_);
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    if (tile.getBlock().noCollision()) continue;
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)tile.getShapes(list), (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        return shape;
    }

    @Deprecated
    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            return be.sideCache.isCollisionFullBlock() ? 0.2f : 1.0f;
        }
        return 0.2f;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            return be.sideCache.getYAxis().doesBlockLight();
        }
        return true;
    }

    public boolean m_6104_(BlockState state, BlockState state2, Direction direction) {
        return false;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            return be.sideCache.isCollisionFullBlock();
        }
        return false;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5939_(state, level, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        VoxelShape shape = Shapes.m_83040_();
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (((IParentCollection)pair.key).isStructure() && LittleStructureAttribute.lightEmitter(((IParentCollection)pair.key).getAttribute()) || ((LittleTile)pair.value).getBlock().isTranslucent()) continue;
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)((LittleTile)pair.value).getShapes((IParentCollection)pair.key), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape;
    }

    @Deprecated
    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.m_5939_(state, level, pos, CollisionContext.m_82749_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public VoxelShape getSelectionShape(BlockGetter level, BlockPos pos) {
        LittleTileContext tileContext = LittleTileContext.selectFocused(level, pos, (Player)Minecraft.m_91087_().f_91074_);
        if (tileContext.isComplete()) {
            if (BlockTile.selectEntireBlock((Player)Minecraft.m_91087_().f_91074_, LittleActionHandlerClient.isUsingSecondMode())) {
                return tileContext.parent.getBE().getBlockShape();
            }
            if (LittleTiles.CONFIG.rendering.highlightStructureBox && tileContext.parent.isStructure()) {
                try {
                    return tileContext.parent.getStructure().getSurroundingBox().getShape(pos);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return tileContext.box.getShape(tileContext.parent.getGrid());
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BETiles be = BlockTile.loadBE(level, pos);
        VoxelShape shape = Shapes.m_83040_();
        if (be != null) {
            for (IParentCollection list : be.groups()) {
                if (list.isStructure() && LittleStructureAttribute.extraCollision(list.getAttribute())) {
                    try {
                        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)list.getStructure().getExtraShape(state, level, pos, context), (BooleanOp)BooleanOp.f_82695_);
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    if (tile.getBlock().noCollision()) continue;
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)tile.getShapes(list), (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        return shape;
    }

    public List<VoxelShape> getOddShapes(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, AABB bb) {
        BETiles be = BlockTile.loadBE(level, pos);
        List<VoxelShape> shapes = null;
        if (be != null) {
            for (IParentCollection list : be.groups()) {
                if (list.isStructure() && LittleStructureAttribute.extraCollision(list.getAttribute())) {
                    try {
                        shapes = list.getStructure().collectOddShapes(state, level, pos, context, shapes, bb);
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    if (tile.getBlock().noCollision()) continue;
                    shapes = tile.collectOddShapes(list, shapes, bb);
                }
            }
        }
        return shapes;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return super.m_7357_(state, level, pos, type);
    }

    @org.jetbrains.annotations.Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @org.jetbrains.annotations.Nullable Mob mob) {
        return state.m_60734_() == Blocks.f_49991_ ? BlockPathTypes.LAVA : (state.isBurning(level, pos) ? BlockPathTypes.DAMAGE_FIRE : null);
    }

    public void setBedOccupied(BlockState state, Level world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity entity) {
        return this.getBed(level, pos, entity) != null;
    }

    public LittleStructure getBed(BlockGetter level, BlockPos pos, @Nullable Entity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            for (LittleStructure structure : be.loadedStructures()) {
                if (structure != ((ILittleBedPlayerExtension)entity).getBed()) continue;
                return structure;
            }
        }
        return null;
    }

    public Direction getBedDirection(BlockState state, LevelReader world, BlockPos pos) {
        return Direction.SOUTH;
    }

    public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader level, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        LittleStructure bed = this.getBed((BlockGetter)level, pos, (Entity)entity);
        if (bed != null && level instanceof Level && level.m_6042_().f_63862_()) {
            return BedBlock.m_260958_(type, (CollisionGetter)level, (BlockPos)pos, (Direction)bed.getBedDirection(), (float)orientation);
        }
        return Optional.empty();
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null && entity != null && entity.m_20191_() != null) {
            AABB bb = entity.m_20191_().m_82400_(0.001);
            for (IStructureParentCollection structure : be.structures()) {
                if (!LittleStructureAttribute.ladder(structure.getAttribute())) continue;
                for (LittleTile tile : structure) {
                    if (!tile.intersectsWith(bb, structure)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        LittleTileContext context = LittleTileContext.selectFocused(level, pos, player);
        if (context.isComplete()) {
            state = context.tile.getState();
            float hardness = state.m_60800_(level, pos);
            if (hardness < 0.0f) {
                return 0.0f;
            }
            if (hardness == -1.0f) {
                return 0.0f;
            }
            int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
            return player.getDigSpeed(state, pos) / hardness / (float)i;
        }
        return super.m_5880_(state, player, level, pos);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    protected void m_142387_(Level p_152422_, Player p_152423_, BlockPos p_152424_, BlockState p_152425_) {
        p_152422_.m_5898_(p_152423_, 2001, p_152424_, BlockTile.m_49956_((BlockState)p_152425_));
    }

    public void m_5707_(Level p_49852_, BlockPos p_49853_, BlockState p_49854_, Player p_49855_) {
        this.m_142387_(p_49852_, p_49855_, p_49853_, p_49854_);
        if (p_49854_.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)p_49855_, (boolean)false);
        }
        p_49852_.m_142346_((Entity)p_49855_, GameEvent.f_157794_, p_49853_);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null && be.sideCache.get(Facing.get((Direction)facing)).doesBlockCollision()) {
            LittleBox box = new LittleBox(0, be.getGrid().count - 1, 0, be.getGrid().count, be.getGrid().count, be.getGrid().count);
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(box)) continue;
                BlockState toCheck = ((LittleTile)pair.value).getState();
                if (toCheck.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    toCheck = (BlockState)toCheck.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
                if (!toCheck.canSustainPlant(level, pos, facing, plantable)) continue;
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        BETiles be;
        if (LittleTiles.CONFIG.rendering.enableRandomDisplayTick && (be = BlockTile.loadBE((BlockGetter)level, pos)) != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                ((LittleTile)pair.value).randomDisplayTick((IParentCollection)pair.key, rand);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return this.useClient(state, level, pos, player, hand, result);
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResult useClient(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        LittleTileContext context = LittleTileContext.selectFocused((BlockGetter)level, pos, player);
        if (context.isComplete() && !(player.m_21120_(hand).m_41720_() instanceof ItemLittleWrench)) {
            return LittleTilesClient.ACTION_HANDLER.execute(new LittleActionActivated(level, pos, player));
        }
        return InteractionResult.PASS;
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        float slipperiness = 1.0f;
        boolean found = false;
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null && entity != null && entity.m_20191_() != null) {
            AABB bb = entity.m_20191_().m_82386_(0.0, -0.001, 0.0);
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(bb, (IParentCollection)pair.key)) continue;
                slipperiness = Math.min(slipperiness, ((LittleTile)pair.value).getFriction((IParentCollection)pair.key, entity));
                found = true;
            }
        }
        if (found) {
            return slipperiness;
        }
        return super.getFriction(state, level, pos, entity);
    }

    public MaterialColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            double biggest = 0.0;
            LittleElement tile = null;
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                double tempVolume = ((LittleTile)pair.value).getVolume();
                if (!(tempVolume > biggest)) continue;
                biggest = tempVolume;
                tile = (LittleTile)pair.value;
            }
            if (tile != null) {
                return tile.getState().m_60780_(level, pos);
            }
        }
        return super.getMapColor(state, level, pos, defaultColor);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        int light = 0;
        if (!this.lightLoopPreventer) {
            return 0;
        }
        BETiles te = BlockTile.loadBE(level, pos);
        if (te != null) {
            for (IParentCollection list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.lightEmitter(list.getAttribute())) {
                    try {
                        light = Math.max(light, list.getStructure().getLightValue(pos));
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    this.lightLoopPreventer = false;
                    int tempLight = (int)Math.ceil((double)tile.getLightValue() * tile.getPercentVolume(te.getGrid()));
                    this.lightLoopPreventer = true;
                    if (tempLight <= light) continue;
                    light = tempLight;
                }
            }
        }
        return light;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.f_46443_) {
            return this.removedByPlayerClient(state, level, pos, player, willHarvest, fluid);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean removedByPlayerClient(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)level, pos, player, 1.0f);
        if (result.isComplete()) {
            return LittleTilesClient.ACTION_HANDLER.execute(new LittleActionDestroy(level, pos, player));
        }
        return false;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        BETiles be = BlockTile.loadBE((BlockGetter)context.m_43725_(), context.m_8083_());
        if (be != null) {
            return be.isEmpty();
        }
        return true;
    }

    public BlockState getStateAtViewpoint(BlockState state, BlockGetter level, BlockPos pos, Vec3 viewpoint) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            int x = be.getGrid().toGrid(viewpoint.f_82479_);
            int y = be.getGrid().toGrid(viewpoint.f_82480_);
            int z = be.getGrid().toGrid(viewpoint.f_82481_);
            LittleBox box = new LittleBox(x, y, z, x + 1, y + 1, z + 1);
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(box)) continue;
                return ((LittleTile)pair.value).getBlock().getState();
            }
        }
        return state;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        LittleTileContext result = LittleTileContext.selectFocused(level, pos, player);
        if (result.isComplete()) {
            if (BlockTile.selectEntireBlock(player, LittleActionHandlerClient.isUsingSecondMode())) {
                ItemStack drop = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.get());
                LittleGroup group = new LittleGroup();
                for (LittleTile tile : result.parent) {
                    group.add(result.parent.getGrid(), (LittleElement)tile, tile);
                }
                drop.m_41751_(LittleGroup.save(group));
                return drop;
            }
            if (result.parent.isStructure()) {
                try {
                    return result.parent.getStructure().getStructureDrop();
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return ItemMultiTiles.of(result.tile, result.parent.getGrid(), result.box);
        }
        return ItemStack.f_41583_;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            int heighest = 0;
            LittleElement heighestTile = null;
            for (IParentCollection list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    for (LittleBox box : tile) {
                        if (box == null || box.maxY <= heighest) continue;
                        heighest = box.maxY;
                        heighestTile = tile;
                    }
                }
            }
            if (heighestTile != null) {
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, heighestTile.getState()).setPos(pos), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            int heighest = 0;
            LittleElement heighestTile = null;
            for (IParentCollection list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    for (LittleBox box : tile) {
                        if (box == null || box.maxY <= heighest) continue;
                        heighest = box.maxY;
                        heighestTile = tile;
                    }
                }
            }
            Random random = new Random();
            if (heighestTile != null) {
                Vec3 vec3 = entity.m_20184_();
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, heighestTile.getState()).setPos(pos), entity.m_20185_() + (random.nextDouble() - 0.5) * (double)entity.m_6972_((Pose)entity.m_20089_()).f_20377_, entity.m_20186_() + 0.1, entity.m_20189_() + (random.nextDouble() - 0.5) * (double)entity.m_6972_((Pose)entity.m_20089_()).f_20377_, vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundType getSoundTypeClient(BlockState state, LevelReader level, BlockPos pos) {
        LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)level, pos, (Player)Minecraft.m_91087_().f_91074_);
        if (result.isComplete()) {
            return result.tile.getSound();
        }
        return null;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BETiles be;
        if (entity == null) {
            return SILENT;
        }
        SoundType sound = null;
        if (entity instanceof Player && level.m_5776_()) {
            sound = this.getSoundTypeClient(state, level, pos);
        }
        if (sound == null && (be = BlockTile.loadBE((BlockGetter)level, pos)) != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (IParentCollection list : be.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    for (LittleBox box : tile) {
                        if (box == null || box.maxY <= heighest) continue;
                        heighest = box.maxY;
                        heighestTile = tile;
                    }
                }
            }
            if (heighestTile != null) {
                return heighestTile.getSound();
            }
        }
        if (sound == null) {
            sound = SoundType.f_56742_;
        }
        return sound;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        float bonus = 0.0f;
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                bonus += ((LittleTile)pair.value).getEnchantPowerBonus((IParentCollection)pair.key);
            }
        }
        return bonus;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos origin, boolean p_60514_) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            te.onNeighbourChanged(origin.equals((Object)pos) ? null : Facing.direction((Vec3i)origin, (Vec3i)pos));
            if (!level.f_46443_) {
                LittleTilesServer.NEIGHBOR.add(level, pos);
            }
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            te.onNeighbourChanged(Facing.direction((Vec3i)pos, (Vec3i)neighbor));
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null && te.shouldCheckForCollision()) {
            for (IStructureParentCollection iStructureParentCollection : te.structures()) {
                if (!LittleStructureAttribute.collisionListener(iStructureParentCollection.getAttribute())) continue;
                try {
                    iStructureParentCollection.getStructure().onEntityCollidedWithBlock(level, iStructureParentCollection, pos, entity);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
            }
            for (Pair pair : te.allTiles()) {
                if (!((LittleTile)pair.value).checkEntityCollision()) continue;
                ((LittleTile)pair.value).entityCollided((IParentCollection)pair.key, entity);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (this.rendered) {
            return new BETilesRendered(pos, state);
        }
        return new BETiles(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (this.ticking) {
            return level.f_46443_ ? null : BETiles::serverTick;
        }
        return null;
    }

    public boolean m_6903_(Explosion p_49826_) {
        return false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        BETiles be = BlockTile.loadBE(level, pos);
        float calculatedResistance = 0.0f;
        float structureResistance = 0.0f;
        if (be != null) {
            for (IParentCollection list : be.groups()) {
                try {
                    if (list.isStructure() && list.getStructure().getExplosionResistance() > 0.0f) {
                        structureResistance = Math.max(structureResistance, list.getStructure().getExplosionResistance());
                        continue;
                    }
                    for (LittleTile tile : list) {
                        calculatedResistance += tile.getExplosionResistance();
                    }
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                }
            }
        }
        if (calculatedResistance > structureResistance) {
            return calculatedResistance;
        }
        return structureResistance;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null) {
            be.updateTiles(x -> {
                ParentCollection parent = x.noneStructureTiles();
                for (LittleTile tile : parent) {
                    tile.onTileExplodes(parent, explosion);
                }
                parent.clear();
                for (StructureParentCollection list : x.structures()) {
                    try {
                        list.getStructure().tileDestroyed();
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    @Override
    public double bound(LittleLevel level, BlockPos pos, Facing facing) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            int value = facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            for (Pair<IParentCollection, LittleTile> pair : te.allTiles()) {
                for (LittleBox box : (LittleTile)pair.value) {
                    value = facing.positive ? Math.max(value, box.get(facing)) : Math.min(value, box.get(facing));
                }
                if (!(facing.positive ? te.getGrid().count == value : value == 0)) continue;
                break;
            }
            return (double)pos.m_123304_(facing.axis.toVanilla()) + te.getGrid().toVanillaGrid(value);
        }
        return (facing.positive ? 0 : 1) + pos.m_123304_(facing.axis.toVanilla());
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null && be.sideCache.get(Facing.get((Direction)dir)).doesBlockLight()) {
            return neighborState.m_60804_(level, pos);
        }
        return false;
    }
}

