/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.convertion;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.AnimationTransition;
import team.creative.littletiles.common.structure.animation.PhysicalPart;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.animation.curve.ValueCurveInterpolation;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.animation.event.PlaySoundEvent;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class OldLittleTilesDataParser {
    private static boolean LOADED_BLOCK_MAP = false;
    private static final HashMap<String, String> BLOCK_MAP = new HashMap();

    public static boolean isOld(CompoundTag nbt) {
        return nbt.m_128425_("tiles", 9);
    }

    public static LittleTile createTile(CompoundTag nbt) {
        if (!LOADED_BLOCK_MAP) {
            try {
                char splitter = '\u00a7';
                try (BufferedReader br = new BufferedReader(new InputStreamReader(LittleStructurePremade.class.getClassLoader().getResourceAsStream("1.12.2.txt"), Charsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        String[] data = line.split("" + splitter);
                        if (data.length != 2) continue;
                        BLOCK_MAP.put(data[0], data[1]);
                    }
                }
                LittleTiles.LOGGER.info("Loaded {} entries of block conversions", (Object)BLOCK_MAP.size());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LOADED_BLOCK_MAP = true;
        }
        Object name = nbt.m_128461_("block");
        if (nbt.m_128441_("meta") && nbt.m_128451_("meta") != 0) {
            name = (String)name + ":" + nbt.m_128451_("meta");
        }
        int color = -1;
        if (nbt.m_128441_("color")) {
            color = nbt.m_128451_("color");
        }
        return new LittleTile(BLOCK_MAP.getOrDefault(name, (String)name), color, (List<LittleBox>)Collections.EMPTY_LIST);
    }

    public static LittleGroup load(CompoundTag nbt) throws LittleConvertException {
        LittleGrid grid;
        try {
            grid = LittleGrid.get(nbt);
        }
        catch (RuntimeException e) {
            throw new LittleConvertException("Invalid grid size " + nbt.m_128451_("grid"));
        }
        ArrayList<LittleGroup> children = Collections.EMPTY_LIST;
        if (nbt.m_128441_("children")) {
            ListTag list = nbt.m_128437_("children", 10);
            children = new ArrayList<LittleGroup>();
            for (int i = 0; i < list.size(); ++i) {
                children.add(OldLittleTilesDataParser.load(list.m_128728_(i)));
            }
        }
        LittleGroup group = new LittleGroup(OldLittleTilesDataParser.convertStructureData(nbt.m_128441_("structure") ? nbt.m_128469_("structure") : null), children);
        ListTag tiles = nbt.m_128437_("tiles", 10);
        for (int i = 0; i < tiles.size(); ++i) {
            CompoundTag tileNbt = tiles.m_128728_(i);
            LittleTile tile = OldLittleTilesDataParser.createTile(tileNbt.m_128469_("tile"));
            if (tileNbt.m_128441_("boxes")) {
                ListTag boxes = tileNbt.m_128437_("boxes", 11);
                for (int j = 0; j < boxes.size(); ++j) {
                    tile.add(LittleBox.create(boxes.m_128767_(j)));
                }
            } else {
                tile.add(LittleBox.create(tileNbt.m_128465_("bBox")));
            }
            group.addTile(grid, tile);
        }
        return group;
    }

    private static void convertDoorBaseData(CompoundTag oldData, CompoundTag newData) {
        newData.m_128379_("actP", oldData.m_128471_("activateParent"));
        newData.m_128379_("hand", !oldData.m_128471_("disableRightClick"));
        newData.m_128379_("stay", oldData.m_128471_("stayAnimated"));
        newData.m_128379_("sound", oldData.m_128441_("sounds") ? oldData.m_128471_("sounds") : true);
        newData.m_128379_("noClip", oldData.m_128471_("noClip"));
        newData.m_128405_("du", oldData.m_128451_("duration"));
        newData.m_128405_("in", oldData.m_128451_("interpolation"));
        if (oldData.m_128441_("axisCenter")) {
            newData.m_128385_("center", oldData.m_128465_("axisCenter"));
        }
        newData.m_128405_("aS", -1);
    }

    private static List<AnimationTimeline.AnimationEventEntry> collectEvents(CompoundTag nbt, boolean opening) {
        ListTag list = nbt.m_128437_("events", 10);
        ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
        for (int i = 0; i < list.size(); ++i) {
            ChildDoorEvent event;
            CompoundTag eventTag = list.m_128728_(i);
            switch (eventTag.m_128461_("id")) {
                case "sound-event": {
                    AnimationEvent animationEvent;
                    if (eventTag.m_128471_("opening") == opening) {
                        animationEvent = new PlaySoundEvent(PlaySoundEvent.get(new ResourceLocation(eventTag.m_128461_("sound"))), eventTag.m_128457_("volume"), eventTag.m_128457_("pitch"));
                        break;
                    }
                    animationEvent = null;
                    break;
                }
                case "child": {
                    AnimationEvent animationEvent = new ChildDoorEvent(eventTag.m_128451_("childId"));
                    break;
                }
                default: {
                    AnimationEvent animationEvent = event = null;
                }
            }
            if (event == null) continue;
            events.add(new AnimationTimeline.AnimationEventEntry(eventTag.m_128451_("tick"), event));
        }
        if (events.isEmpty()) {
            return null;
        }
        return events;
    }

    private static void saveDoor(CompoundTag nbt, PhysicalState start, PhysicalState end, AnimationTimeline opening, AnimationTimeline closing) {
        ArrayList<AnimationState> states = new ArrayList<AnimationState>();
        states.add(new AnimationState("closed", start, !nbt.m_128471_("stay")));
        states.add(new AnimationState("opened", end, !nbt.m_128471_("stay")));
        ListTag stateList = new ListTag();
        for (int i = 0; i < states.size(); ++i) {
            stateList.add((Object)((AnimationState)states.get(i)).save());
        }
        nbt.m_128365_("s", (Tag)stateList);
        ArrayList<AnimationTransition> transitions = new ArrayList<AnimationTransition>();
        if (opening != null) {
            transitions.add(new AnimationTransition("opening", 0, 1, opening));
        }
        if (closing != null) {
            transitions.add(new AnimationTransition("closing", 1, 0, closing));
        }
        ListTag transitionList = new ListTag();
        for (int i = 0; i < transitions.size(); ++i) {
            transitionList.add((Object)((AnimationTransition)transitions.get(i)).save());
        }
        nbt.m_128365_("t", (Tag)transitionList);
    }

    private static ValueCurveInterpolation<Vec1d> loadValueTimelineAndPrepare(PhysicalPart part, int[] data, PhysicalState start, PhysicalState end, LittleGrid grid, int duration) {
        if (data.length == 0) {
            return null;
        }
        ValueCurveInterpolation.CosineCurve<Vec1d> curve = switch (data[0]) {
            case 1 -> new ValueCurveInterpolation.CosineCurve();
            case 2 -> new ValueCurveInterpolation.CubicCurve();
            case 3 -> new ValueCurveInterpolation.HermiteCurve();
            default -> new ValueCurveInterpolation.LinearCurve();
        };
        for (int i = 0; i < data[1]; ++i) {
            double value = Double.longBitsToDouble((long)data[3 + i * 3] << 32 | (long)data[4 + i * 3] & 0xFFFFFFFFL);
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            curve.add(data[2 + i * 3], new Vec1d(value));
        }
        return OldLittleTilesDataParser.prepareValueCurve(part, curve, start, end, grid, duration);
    }

    private static ValueCurveInterpolation<Vec1d> prepareValueCurve(PhysicalPart part, ValueCurveInterpolation<Vec1d> curve, PhysicalState start, PhysicalState end, LittleGrid grid, int duration) {
        if (curve == null || curve.isEmpty()) {
            return null;
        }
        if (curve.size() == 1) {
            start.set(part, curve.getFirst().x);
            end.set(part, curve.getFirst().x);
            return null;
        }
        Pair<Integer, Vec1d> first = curve.getFirstPair();
        if (part.offset) {
            ((Vec1d)first.value).x = grid.toVanillaGrid(((Vec1d)first.value).x);
        }
        start.set(part, ((Vec1d)first.value).x);
        if ((Integer)first.key == 0) {
            curve.remove(0);
        }
        Pair<Integer, Vec1d> last = curve.getLastPair();
        if (part.offset) {
            ((Vec1d)last.value).x = grid.toVanillaGrid(((Vec1d)last.value).x);
        }
        end.set(part, ((Vec1d)last.value).x);
        if ((Integer)last.key == duration) {
            curve.remove(curve.size() - 1);
        }
        if (curve.isEmpty()) {
            return null;
        }
        return curve;
    }

    public static CompoundTag convertStructureData(CompoundTag nbt) throws LittleConvertException {
        if (nbt == null) {
            return null;
        }
        return switch (nbt.m_128461_("id")) {
            case "workbench", "importer", "exporter", "blankomatic", "particle_emitter", "signal_display", "structure_builder", "fixed", "ladder", "bed", "chair", "storage", "noclip", "message", "item_holder" -> nbt;
            case "single_cable1", "single_cable4", "single_cable16", "single_input1", "single_input4", "single_input16", "single_output1", "single_output4", "single_output16" -> nbt;
            case "light" -> {
                nbt.m_128379_("right", !nbt.m_128471_("disableRightClick"));
                nbt.m_128473_("disableRightClick");
                yield nbt;
            }
            case "door" -> {
                List<AnimationTimeline.AnimationEventEntry> closingEvents;
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                CompoundTag rotation = new CompoundTag();
                Axis axis = Axis.values()[nbt.m_128451_("axis")];
                rotation.m_128405_("a", axis.ordinal());
                PhysicalState end = new PhysicalState();
                if (nbt.m_128451_("rot-type") == 1) {
                    double degree = nbt.m_128459_("degree");
                    rotation.m_128347_("d", degree);
                    end.rot(axis, degree);
                } else {
                    boolean clockwise = nbt.m_128471_("clockwise");
                    rotation.m_128379_("c", clockwise);
                    end.rot(axis, clockwise ? 90.0 : -90.0);
                }
                converted.m_128365_("rotation", (Tag)rotation);
                List<AnimationTimeline.AnimationEventEntry> openingEvents = OldLittleTilesDataParser.collectEvents(nbt, true);
                AnimationTimeline opening = null;
                AnimationTimeline closing = null;
                if (openingEvents != null) {
                    opening = new AnimationTimeline(nbt.m_128451_("duration"), openingEvents);
                }
                if ((closingEvents = OldLittleTilesDataParser.collectEvents(nbt, false)) != null) {
                    closing = new AnimationTimeline(nbt.m_128451_("duration"), closingEvents);
                }
                OldLittleTilesDataParser.saveDoor(converted, new PhysicalState(), end, opening, closing);
                converted.m_128359_("id", "axis");
                yield converted;
            }
            case "slidingDoor" -> {
                List<AnimationTimeline.AnimationEventEntry> closingEvents;
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                PhysicalState end = new PhysicalState();
                Facing direction = Facing.VALUES[nbt.m_128451_("direction")];
                converted.m_128405_("direction", direction.ordinal());
                int distance = nbt.m_128451_("distance");
                converted.m_128405_("dis", distance);
                LittleGrid grid = LittleGrid.get(nbt.m_128451_("grid"));
                converted.m_128405_("disG", grid.count);
                end.off(direction, grid.toVanillaGrid(distance));
                List<AnimationTimeline.AnimationEventEntry> openingEvents = OldLittleTilesDataParser.collectEvents(nbt, true);
                AnimationTimeline opening = null;
                AnimationTimeline closing = null;
                if (openingEvents != null) {
                    opening = new AnimationTimeline(nbt.m_128451_("duration"), openingEvents);
                }
                if ((closingEvents = OldLittleTilesDataParser.collectEvents(nbt, false)) != null) {
                    closing = new AnimationTimeline(nbt.m_128451_("duration"), closingEvents);
                }
                OldLittleTilesDataParser.saveDoor(converted, new PhysicalState(), end, opening, closing);
                converted.m_128359_("id", "sliding");
                yield converted;
            }
            case "doorActivator" -> {
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                int duration = 1;
                converted.m_128405_("du", duration);
                int[] toActivate = nbt.m_128465_("activate");
                converted.m_128385_("act", toActivate);
                ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
                for (int i = 0; i < toActivate.length; ++i) {
                    events.add(new AnimationTimeline.AnimationEventEntry(0, new ChildDoorEvent(toActivate[i])));
                }
                AnimationTimeline opening = null;
                AnimationTimeline closing = null;
                if (events != null) {
                    opening = new AnimationTimeline(duration, events);
                    closing = new AnimationTimeline(duration, events);
                }
                OldLittleTilesDataParser.saveDoor(converted, new PhysicalState(), new PhysicalState(), opening, closing);
                converted.m_128359_("id", "activator");
                yield converted;
            }
            case "advancedDoor" -> {
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                int duration = nbt.m_128451_("duration");
                CompoundTag animation = nbt.m_128469_("animation");
                PhysicalState start = new PhysicalState();
                PhysicalState end = new PhysicalState();
                LittleGrid grid = LittleGrid.get(animation.m_128451_("offGrid"));
                HashMap<PhysicalPart, ValueCurveInterpolation<Vec1d>> curves = new HashMap<PhysicalPart, ValueCurveInterpolation<Vec1d>>();
                for (PhysicalPart part : PhysicalPart.values()) {
                    curves.put(part, OldLittleTilesDataParser.loadValueTimelineAndPrepare(part, animation.m_128465_(part.oldKey), start, end, grid, duration));
                }
                AnimationTimeline opening = new AnimationTimeline(duration, OldLittleTilesDataParser.collectEvents(nbt, true));
                AnimationTimeline closing = new AnimationTimeline(duration, OldLittleTilesDataParser.collectEvents(nbt, false));
                for (Map.Entry entry : curves.entrySet()) {
                    if (entry.getValue() == null) continue;
                    opening.set((PhysicalPart)((Object)entry.getKey()), (ValueCurve)entry.getValue());
                    closing.set((PhysicalPart)((Object)entry.getKey()), (ValueCurve)entry.getValue());
                }
                OldLittleTilesDataParser.saveDoor(converted, start, end, opening, closing);
                converted.m_128359_("id", "door");
                yield converted;
            }
            default -> throw new LittleConvertException("Cannot convert " + nbt.m_128461_("id") + " yet");
        };
    }

    public static CompoundTag convert(CompoundTag nbt) throws LittleConvertException {
        return LittleGroup.save(OldLittleTilesDataParser.load(nbt));
    }

    public static class LittleConvertException
    extends Exception {
        public LittleConvertException(String name) {
            super(name);
        }
    }
}

