/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.OrientationAwareEntity;
import team.creative.littletiles.common.level.handler.LittleAnimationHandlers;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.structure.animation.PhysicalState;

public abstract class LittleEntityPhysic<T extends LittleEntity<? extends LittleEntityPhysic>> {
    private static final Predicate<Entity> NO_ANIMATION = x -> !(x instanceof INoPushEntity);
    protected double minX;
    protected double minY;
    protected double minZ;
    protected double maxX;
    protected double maxY;
    protected double maxZ;
    protected boolean preventPush = false;
    protected boolean noCollision;
    private AABB bb;
    private Vec3 center;
    private boolean bbChanged = false;
    public final T parent;

    public LittleEntityPhysic(T parent) {
        this.parent = parent;
        this.bb = parent.m_20191_();
    }

    public double get(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> this.maxX;
            case Facing.WEST -> this.minX;
            case Facing.UP -> this.maxY;
            case Facing.DOWN -> this.minY;
            case Facing.SOUTH -> this.maxZ;
            case Facing.NORTH -> this.minZ;
        };
    }

    public void set(Facing facing, double value) {
        switch (facing) {
            case EAST: {
                this.maxX = value;
                break;
            }
            case WEST: {
                this.minX = value;
                break;
            }
            case UP: {
                this.maxY = value;
                break;
            }
            case DOWN: {
                this.minY = value;
                break;
            }
            case SOUTH: {
                this.maxZ = value;
                break;
            }
            case NORTH: {
                this.minZ = value;
            }
        }
    }

    public IVecOrigin getOrigin() {
        return ((LittleEntity)this.parent).getOrigin();
    }

    public void ignoreCollision(Runnable run) {
        this.preventPush = true;
        try {
            run.run();
        }
        finally {
            this.preventPush = false;
        }
    }

    public boolean shouldPush() {
        return !this.preventPush;
    }

    public abstract void setSubLevel(LittleSubLevel var1);

    public abstract void tick();

    public void setBB(AABB bb) {
        if (bb.f_82291_ >= Double.MAX_VALUE) {
            return;
        }
        this.bb = bb;
        this.bbChanged = true;
    }

    public void updateBoundingBox() {
        boolean originChanged;
        if (this.bb == null || ((LittleEntity)this.parent).getSubLevel() == null) {
            return;
        }
        boolean bl = originChanged = ((LittleEntity)this.parent).getOrigin().hasChanged() || ((LittleEntity)this.parent).getOrigin().hasChanged();
        if (this.bbChanged || originChanged) {
            if (originChanged) {
                ((LittleEntity)this.parent).markOriginChange();
            }
            this.parent.m_20011_(((LittleEntity)this.parent).getOrigin().getAABB(this.bb));
            if (originChanged) {
                ((LittleEntity)this.parent).resetOriginChange();
            }
            this.center = this.parent.m_20191_().m_82399_();
            this.bbChanged = false;
        }
    }

    public AABB getOBB() {
        return this.bb;
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public void load(CompoundTag nbt) {
        this.preventPush = true;
        this.set(nbt.m_128459_("offX"), nbt.m_128459_("offY"), nbt.m_128459_("offZ"), nbt.m_128459_("rotX"), nbt.m_128459_("rotY"), nbt.m_128459_("rotZ"));
        this.preventPush = false;
        this.minX = nbt.m_128459_("x");
        this.minY = nbt.m_128459_("y");
        this.minZ = nbt.m_128459_("z");
        this.maxX = nbt.m_128459_("x2");
        this.maxY = nbt.m_128459_("y2");
        this.maxZ = nbt.m_128459_("z2");
        this.setBB(new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ));
        this.loadExtra(nbt);
    }

    public abstract void loadExtra(CompoundTag var1);

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        IVecOrigin origin = this.getOrigin();
        nbt.m_128347_("offX", origin.offX());
        nbt.m_128347_("offY", origin.offY());
        nbt.m_128347_("offZ", origin.offZ());
        nbt.m_128347_("rotX", origin.rotX());
        nbt.m_128347_("rotY", origin.rotY());
        nbt.m_128347_("rotZ", origin.rotZ());
        nbt.m_128347_("x", this.minX);
        nbt.m_128347_("y", this.minY);
        nbt.m_128347_("z", this.minZ);
        nbt.m_128347_("x2", this.maxX);
        nbt.m_128347_("y2", this.maxY);
        nbt.m_128347_("z2", this.maxZ);
        this.saveExtra(nbt);
        return nbt;
    }

    protected abstract void saveExtra(CompoundTag var1);

    public void set(PhysicalState state) {
        this.set(state.offX(), state.offY(), state.offZ(), state.rotX(), state.rotY(), state.rotZ());
    }

    public void set(double offX, double offY, double offZ, double rotX, double rotY, double rotZ) {
        IVecOrigin origin = this.getOrigin();
        this.moveAndRotateAnimation(offX - origin.offX(), offY - origin.offY(), offZ - origin.offZ(), rotX - origin.rotX(), rotY - origin.rotY(), rotZ - origin.rotZ());
    }

    public void moveAndRotateAnimation(double x, double y, double z, double rotX, double rotY, double rotZ) {
        if (x == 0.0 && y == 0.0 && z == 0.0 && rotX == 0.0 && rotY == 0.0 && rotZ == 0.0) {
            return;
        }
        CollisionCoordinator coordinator = new CollisionCoordinator(x, y, z, rotX, rotY, rotZ, this.getOrigin(), this.getOrigin());
        if (LittleTiles.CONFIG.general.enableAnimationCollision) {
            this.transform(coordinator);
        }
        coordinator.move();
    }

    public void transform(CollisionCoordinator coordinator) {
        if (this.preventPush) {
            return;
        }
        this.noCollision = true;
        List entities = ((LittleEntity)this.parent).getRealLevel().m_6249_(this.parent, coordinator.computeSurroundingBox(this.bb), NO_ANIMATION);
        if (!entities.isEmpty()) {
            for (int j = 0; j < entities.size(); ++j) {
                Entity entity = (Entity)entities.get(j);
                AABB surroundingBB = coordinator.computeInverseSurroundingBox(entity.m_20191_());
                double t = -1.0;
                for (VoxelShape voxelShape : ((LittleEntity)this.parent).getSubLevel().m_186431_(entity, surroundingBB)) {
                }
                AABB originalBox = entity.m_20191_();
                Vec3d newCenter = new Vec3d(originalBox.m_82399_());
                coordinator.transform(newCenter, Double.valueOf(1.0 - t));
                boolean collidedHorizontally = entity.f_19862_;
                boolean collidedVertically = entity.f_19863_;
                boolean onGround = entity.m_20096_();
                double moveX = newCenter.x - this.center.f_82479_;
                double moveY = newCenter.y - this.center.f_82480_;
                double moveZ = newCenter.z - this.center.f_82481_;
                entity.m_6478_(MoverType.SELF, new Vec3(moveX, moveY, moveZ));
                if (entity instanceof ServerPlayer) {
                    LittleAnimationHandlers.setPushedByDoor((ServerPlayer)entity);
                }
                if (LittleTiles.CONFIG.general.enableCollisionMotion) {
                    entity.m_20184_().m_82520_(moveX, moveY, moveZ);
                }
                if (moveX != 0.0 || moveZ != 0.0) {
                    collidedHorizontally = true;
                }
                if (moveY != 0.0) {
                    collidedVertically = true;
                    onGround = true;
                }
                entity.f_19862_ = collidedHorizontally;
                entity.f_19863_ = collidedVertically;
                entity.m_6853_(onGround);
            }
        }
        coordinator.move();
        for (OrientationAwareEntity child : ((LittleEntity)this.parent).children()) {
            coordinator.reset(child.getOrigin());
            child.transform(coordinator);
        }
        this.noCollision = false;
    }
}

