/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Vector3d;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.matrix.ChildVecOrigin;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.VecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.NestedFunctionIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.BlockStatePredictionHandlerExtender;
import team.creative.littletiles.client.level.ClientLevelExtender;
import team.creative.littletiles.client.level.little.LittleAnimationLevelClientCallback;
import team.creative.littletiles.client.render.entity.LittleAnimationRenderManager;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationChunkCache;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevelEntities;
import team.creative.littletiles.common.level.little.LevelBlockChangeListener;
import team.creative.littletiles.common.level.little.LittleAnimationLevelCallback;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationBlocksPacket;
import team.creative.littletiles.server.level.little.LittleAnimationLevelServerCallback;

public class LittleAnimationLevel
extends Level
implements LittleSubLevel,
Iterable<BETiles>,
ClientLevelExtender {
    private Level parentLevel;
    public final LittleAnimationLevelCallback entityCallback;
    private final LittleAnimationLevelEntities entities;
    public Entity holder;
    public IVecOrigin origin;
    public LittleAnimationChunkCache chunks;
    private final List<LevelBlockChangeListener> blockChangeListeners = new ArrayList<LevelBlockChangeListener>();
    @OnlyIn(value=Dist.CLIENT)
    public LittleAnimationRenderManager renderManager;
    private HashSet<BlockPos> trackedChanges;
    @OnlyIn(value=Dist.CLIENT)
    private BlockStatePredictionHandler blockStatePredictionHandler;

    public LittleAnimationLevel(Level level) {
        super((WritableLevelData)level.m_6106_(), level.m_46472_(), level.m_9598_(), (Holder)level.m_9598_().m_175515_(Registries.f_256787_).m_246971_(LittleTilesRegistry.FAKE_DIMENSION), level.m_46658_(), level.f_46443_, level.m_46659_(), 0L, 1000000);
        this.parentLevel = level;
        this.chunks = new LittleAnimationChunkCache(this);
        if (this.f_46443_) {
            this.blockStatePredictionHandler = new BlockStatePredictionHandler();
            this.entityCallback = new LittleAnimationLevelClientCallback(this);
        } else {
            this.trackedChanges = new HashSet();
            this.entityCallback = new LittleAnimationLevelServerCallback(this);
        }
        this.entities = new LittleAnimationLevelEntities(this.entityCallback);
    }

    @Override
    public LevelEntityGetter<Entity> getEntityGetter() {
        return this.entities;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return this.renderManager;
    }

    public MinecraftServer m_7654_() {
        return this.parentLevel.m_7654_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleBlockChangedAckExtender(int sequence) {
        ((BlockStatePredictionHandlerExtender)this.blockStatePredictionHandler).setLevel(this);
        this.blockStatePredictionHandler.m_233856_(sequence, null);
        ((BlockStatePredictionHandlerExtender)this.blockStatePredictionHandler).setLevel(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setServerVerifiedBlockStateExtender(BlockPos pos, BlockState state, int p_233656_) {
        if (!this.blockStatePredictionHandler.m_233864_(pos, state)) {
            super.m_6933_(pos, state, p_233656_, 512);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void syncBlockStateExtender(BlockPos pos, BlockState state, Vec3 vec) {
        BlockState blockstate = this.m_8055_(pos);
        if (blockstate != state) {
            this.m_7731_(pos, state, 19);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player.m_20039_(pos, state)) {
                player.m_20248_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockStatePredictionHandler blockStatePredictionHandler() {
        return this.blockStatePredictionHandler;
    }

    @Override
    public TransientEntitySectionManager getEntityStorage() {
        return null;
    }

    @Override
    public boolean allowPlacement() {
        return false;
    }

    public Level getParent() {
        return this.parentLevel;
    }

    public Level getRealLevel() {
        Level level = this.parentLevel;
        if (level instanceof LittleSubLevel) {
            LittleSubLevel sub = (LittleSubLevel)level;
            return sub.getRealLevel();
        }
        return this.parentLevel;
    }

    @Override
    public void setParent(Level level) {
        this.parentLevel = level;
    }

    @Override
    public UUID key() {
        return this.getHolder().m_20148_();
    }

    public IVecOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vec3d center) {
        this.origin = this.parentLevel instanceof IOrientatedLevel ? new ChildVecOrigin(((IOrientatedLevel)this.parentLevel).getOrigin(), center) : new VecOrigin(center);
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LittleAnimationChunkCache getChunkSource() {
        return this.chunks;
    }

    public void m_214171_(GameEvent event, Vec3 vec, GameEvent.Context context) {
        this.getRealLevel().m_214171_(event, vec, context);
    }

    public List<? extends Player> m_6907_() {
        return Collections.EMPTY_LIST;
    }

    public RegistryAccess m_9598_() {
        return this.getRealLevel().m_9598_();
    }

    @Override
    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(Entity entity) {
        this.holder = entity;
    }

    @Override
    public void unload(LevelChunk chunk) {
        chunk.m_187957_();
        this.getChunkSource().m_7827_().m_6460_(chunk.m_7697_(), false);
    }

    @Override
    public void unload() {
        this.entities.removeAll();
        if (this.f_46443_ && this.renderManager != null) {
            this.renderManager.unload();
        }
    }

    @Override
    public Iterable<Entity> entities() {
        return this.entities.m_142273_();
    }

    public Iterable<LevelChunk> chunks() {
        return this.chunks.all();
    }

    public void initialTick() {
        this.m_46463_();
    }

    @Override
    public void tick() {
        if (!this.f_46443_ && !this.trackedChanges.isEmpty()) {
            LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new LittleAnimationBlocksPacket((LittleAnimationEntity)this.holder, this.trackedChanges), this.holder);
            this.trackedChanges.clear();
        }
        this.m_46463_();
        this.entityCallback.tick();
    }

    @Override
    public void registerBlockChangeListener(LevelBlockChangeListener listener) {
        this.blockChangeListeners.add(listener);
    }

    public void m_7260_(BlockPos pos, BlockState actualState, BlockState setState, int p_104688_) {
        if (this.f_46443_) {
            this.renderManager.blockChanged((BlockGetter)this, pos, actualState, setState, p_104688_);
        } else {
            this.trackedChanges.add(pos);
        }
    }

    public void m_6550_(BlockPos pos, BlockState actualState, BlockState setState) {
        if (this.f_46443_) {
            this.renderManager.setBlockDirty(pos, actualState, setState);
        }
        this.blockChangeListeners.forEach(x -> x.blockChanged(pos, setState));
    }

    public String m_46464_() {
        return "";
    }

    public Entity m_6815_(int id) {
        return this.entities.get(id);
    }

    public MapItemSavedData m_7489_(String key) {
        return this.getRealLevel().m_7489_(key);
    }

    public void m_142325_(String key, MapItemSavedData data) {
        this.getRealLevel().m_142325_(key, data);
    }

    public int m_7354_() {
        return this.getRealLevel().m_7354_();
    }

    public void m_6801_(int id, BlockPos pos, int progress) {
        if (this.f_46443_) {
            this.renderManager.destroyBlockProgress(id, pos, progress);
        }
    }

    @Override
    public Iterator<BETiles> iterator() {
        return new NestedFunctionIterator(this.chunks(), x -> () -> new FilterIterator(x.m_62954_().values(), BETiles.class));
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.entities;
    }

    public void m_5594_(@Nullable Player p_184133_1_, BlockPos pos, SoundEvent p_184133_3_, SoundSource p_184133_4_, float p_184133_5_, float p_184133_6_) {
        if (this.getOrigin() == null) {
            return;
        }
        this.getRealLevel().m_5594_(p_184133_1_, this.transformToRealWorld(pos), p_184133_3_, p_184133_4_, p_184133_5_, p_184133_6_);
    }

    public void m_6263_(@Nullable Player p_184148_1_, double x, double y, double z, SoundEvent p_184148_8_, SoundSource p_184148_9_, float p_184148_10_, float p_184148_11_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealLevel().m_6263_(p_184148_1_, vec.x, vec.y, vec.z, p_184148_8_, p_184148_9_, p_184148_10_, p_184148_11_);
    }

    public void m_6269_(@Nullable Player p_217384_1_, Entity entity, SoundEvent p_217384_3_, SoundSource p_217384_4_, float p_217384_5_, float p_217384_6_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vec3 vec = this.getOrigin().transformPointToWorld(entity.m_20318_(1.0f));
        this.getRealLevel().m_6263_(p_217384_1_, vec.f_82479_, vec.f_82480_, vec.f_82481_, p_217384_3_, p_217384_4_, p_217384_5_, p_217384_6_);
    }

    public void m_7785_(double x, double y, double z, SoundEvent p_184134_7_, SoundSource p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().m_7785_(vec.x, vec.y, vec.z, p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_, p_184134_11_);
    }

    public void m_262808_(Player p_262953_, double x, double y, double z, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealLevel().m_262808_(p_262953_, vec.x, vec.y, vec.z, p_263359_, p_263020_, p_263055_, p_262914_, p_262991_);
    }

    public void m_214150_(Player player, double x, double y, double z, SoundEvent event, SoundSource source, float p_220369_, float p_220370_, long p_220371_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vec3 vec = this.getOrigin().transformPointToWorld(new Vec3(x, y, z));
        this.getRealLevel().m_214150_(player, vec.f_82479_, vec.f_82480_, vec.f_82481_, event, source, p_220369_, p_220370_, p_220371_);
    }

    public void m_213890_(Player player, Entity entity, Holder<SoundEvent> event, SoundSource source, float p_220376_, float p_220377_, long p_220378_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vec3 vec = this.getOrigin().transformPointToWorld(entity.m_146892_());
        this.getRealLevel().m_262808_(player, vec.f_82479_, vec.f_82480_, vec.f_82481_, event, source, p_220376_, p_220377_, p_220378_);
    }

    public void m_7106_(ParticleOptions p_195594_1_, double x, double y, double z, double p_195594_8_, double p_195594_10_, double p_195594_12_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().m_7106_(p_195594_1_, vec.x, vec.y, vec.z, p_195594_8_, p_195594_10_, p_195594_12_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6493_(ParticleOptions p_195590_1_, boolean p_195590_2_, double x, double y, double z, double p_195590_9_, double p_195590_11_, double p_195590_13_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().m_6493_(p_195590_1_, p_195590_2_, vec.x, vec.y, vec.z, p_195590_9_, p_195590_11_, p_195590_13_);
    }

    public void m_7107_(ParticleOptions p_195589_1_, double x, double y, double z, double p_195589_8_, double p_195589_10_, double p_195589_12_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().m_7107_(p_195589_1_, vec.x, vec.y, vec.z, p_195589_8_, p_195589_10_, p_195589_12_);
    }

    public void m_6485_(ParticleOptions p_217404_1_, boolean p_217404_2_, double x, double y, double z, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().m_6485_(p_217404_1_, p_217404_2_, vec.x, vec.y, vec.z, p_217404_9_, p_217404_11_, p_217404_13_);
    }

    public Holder<Biome> m_203675_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return this.getRealLevel().m_203675_(p_225604_1_, p_225604_2_, p_225604_3_);
    }

    public float m_7717_(Direction direction, boolean p_230487_2_) {
        return this.getRealLevel().m_7717_(direction, p_230487_2_);
    }

    public Scoreboard m_6188_() {
        return this.getRealLevel().m_6188_();
    }

    public RecipeManager m_7465_() {
        return this.getRealLevel().m_7465_();
    }

    public void m_5898_(Player player, int p_217378_2_, BlockPos pos, int p_217378_4_) {
        this.getRealLevel().m_5898_(player, p_217378_2_, pos, p_217378_4_);
    }

    public void m_142346_(Entity p_151549_, GameEvent p_151550_, BlockPos p_151551_) {
        this.getRealLevel().m_142346_(p_151549_, p_151550_, p_151551_);
    }

    public String toString() {
        return "SubAnimationLevel[" + this.holder.m_20149_() + "]";
    }

    @Override
    public FeatureFlagSet m_246046_() {
        return this.getParent().m_246046_();
    }

    @Override
    public boolean shouldUseLightingForRenderig() {
        return false;
    }

    public boolean isEmpty() {
        for (LevelChunk chunk : this.chunks()) {
            if (chunk.m_62954_().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void addFreshEntityFromPacket(Entity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, (Level)this))) {
            return;
        }
        this.removeEntityById(entity.m_19879_(), Entity.RemovalReason.DISCARDED);
        this.entities.addNewEntityWithoutEvent(entity);
        entity.onAddedToWorld();
    }

    @Override
    public void removeEntityById(int id, Entity.RemovalReason reason) {
        Entity entity = (Entity)this.m_142646_().m_142597_(id);
        if (entity != null) {
            entity.m_142467_(reason);
            if (LittleTilesClient.ANIMATION_HANDLER.checkInTransition(entity)) {
                return;
            }
            entity.m_142036_();
        }
    }

    public void clearTrackingChanges() {
        if (this.trackedChanges != null) {
            this.trackedChanges.clear();
        }
    }

    public boolean m_7967_(Entity entity) {
        if (this.f_46443_ || entity.m_213877_()) {
            return false;
        }
        if (this.entities.addNewEntity(entity)) {
            entity.onAddedToWorld();
            return true;
        }
        return false;
    }
}

